/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.PlatformUI;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.ArrayUtils;

public class KeyStrokeTextField
extends JTextField
implements KeyListener {
    private static final int[] modifierKeyCodes = new int[]{16, 17, 18, 65406, 157};
    private static final int[] modifierMasks = new int[]{1, 2, 8, 32, 4};
    private static final int[] ignoreKeyCodes = new int[]{8, 83, 524};
    private Integer keyCode;
    private int modifiers;

    public KeyStrokeTextField() {
        this.addKeyListener(this);
        this.setDragEnabled(false);
    }

    public KeyStroke getKeyStroke() {
        return this.keyCode != null ? KeyStroke.getKeyStroke(this.keyCode, this.modifiers) : null;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.keyCode = keyStroke.getKeyCode();
            this.modifiers = keyStroke.getModifiers();
            this.updateKeyStroke();
        } else {
            this.reset();
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (this.keyCode != null && (evt.getKeyCode() == 10 || evt.getKeyCode() == 27)) {
            return;
        }
        if (evt.getKeyCode() == 8 || evt.getKeyChar() == '\b') {
            this.reset();
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        }
        evt.consume();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (this.keyCode != null && (evt.getKeyCode() == 10 || evt.getKeyCode() == 27)) {
            return;
        }
        if (this.keyCode == null && evt.getKeyCode() > 0 && !ArrayUtils.contains((int[])ignoreKeyCodes, (int)evt.getKeyCode())) {
            int index = ArrayUtils.indexOf((int[])modifierKeyCodes, (int)evt.getKeyCode());
            if (index >= 0) {
                this.modifiers |= modifierMasks[index];
            } else {
                this.keyCode = evt.getKeyCode();
            }
            this.updateKeyStroke();
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        }
        evt.consume();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (this.keyCode != null && (evt.getKeyCode() == 10 || evt.getKeyCode() == 27)) {
            return;
        }
        if (this.keyCode == null && evt.getKeyCode() > 0 && this.modifiers > 0 && !ArrayUtils.contains((int[])ignoreKeyCodes, (int)evt.getKeyCode())) {
            int index = ArrayUtils.indexOf((int[])modifierKeyCodes, (int)evt.getKeyCode());
            if (index >= 0 && this.keyCode == null) {
                this.modifiers ^= modifierMasks[index];
                this.modifiers &= this.modifiers;
            } else {
                this.keyCode = evt.getKeyCode();
            }
            this.updateKeyStroke();
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        }
        evt.consume();
    }

    private void reset() {
        this.keyCode = null;
        this.modifiers = 0;
        this.updateKeyStroke();
    }

    private void updateKeyStroke() {
        StringBuilder builder = new StringBuilder();
        for (int mask : modifierMasks) {
            if ((this.modifiers & mask) <= 0) continue;
            if (builder.length() > 0) {
                builder.append('+');
            }
            builder.append(KeyEvent.getKeyModifiersText(mask));
        }
        if (this.keyCode != null) {
            if (builder.length() > 0) {
                builder.append('-');
            }
            builder.append(KeyEvent.getKeyText(this.keyCode));
        }
        this.setText(builder.toString());
    }
}

