/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class MirthComboBoxTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected MirthComboBox comboBox;
    private int clickCount;
    private boolean editable;
    private JTable table;

    public MirthComboBoxTableCellEditor(JTable table, Object[] items, int clickCount, boolean focusable, final ActionListener actionListener) {
        this.clickCount = clickCount;
        this.table = table;
        this.comboBox = new MirthComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(items));
        this.comboBox.setFocusable(focusable);
        this.comboBox.setMaximumRowCount(20);
        this.comboBox.setForeground(table.getForeground());
        this.comboBox.setBackground(table.getBackground());
        this.comboBox.setRenderer(new DataTypeListCellRenderer());
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (actionListener != null) {
                    actionListener.actionPerformed(e);
                }
                MirthComboBoxTableCellEditor.this.fireEditingStopped();
            }
        });
        for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
            if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
            ((AbstractButton)this.comboBox.getComponent(i)).setBorderPainted(false);
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCount;
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editable ? this.comboBox.getEditor().getItem() : this.comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.comboBox.setForeground(table.getSelectionForeground());
        this.comboBox.setBackground(table.getSelectionBackground());
        for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
            if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
            this.comboBox.getComponent(i).setBackground(this.comboBox.getBackground());
        }
        this.comboBox.setSelectedItem(value);
        return this.comboBox;
    }

    public void setTooltips(String[] tooltips) {
        DataTypeListCellRenderer renderer = (DataTypeListCellRenderer)this.comboBox.getRenderer();
        renderer.setTooltips(tooltips);
    }

    public MirthComboBox getComboBox() {
        return this.comboBox;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.comboBox.setEditable(editable);
        if (editable) {
            this.comboBox.setEditor(new MirthComboBoxEditor(this.table));
        }
    }

    private class DataTypeListCellRenderer
    extends DefaultListCellRenderer {
        String[] tooltips;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index >= 0) {
                if (!isSelected) {
                    component.setBackground(UIConstants.BACKGROUND_COLOR);
                }
                if (value != null && this.tooltips != null && index < this.tooltips.length) {
                    list.setToolTipText(this.tooltips[index]);
                }
            }
            return component;
        }

        public void setTooltips(String[] tooltips) {
            this.tooltips = tooltips;
        }
    }

    private class MirthComboBoxEditor
    implements ComboBoxEditor {
        private JTextField textfield = new JTextField();

        public MirthComboBoxEditor(final JTable table) {
            this.textfield.setEditable(true);
            this.textfield.setBackground(UIConstants.BACKGROUND_COLOR);
            this.textfield.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        table.getCellEditor().stopCellEditing();
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }

        @Override
        public void setItem(Object text) {
            this.textfield.setText("");
            if (text != null) {
                this.textfield.setText(text.toString());
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.textfield;
        }

        @Override
        public Object getItem() {
            return this.textfield.getText();
        }

        @Override
        public void selectAll() {
            this.textfield.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.textfield.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.textfield.removeActionListener(l);
        }
    }
}

