/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ObjectUtils;

public class MirthDialogTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0 1 0 0, novisualpadding, hidemode 3"));
    private JLabel label;
    private String text;
    private String originalValue;

    public MirthDialogTableCellEditor(final JTable table) {
        this.panel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.label = new JLabel();
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                new ValueDialog(table);
                MirthDialogTableCellEditor.this.stopCellEditing();
            }
        });
        this.panel.add((Component)this.label, "grow, pushx, h 19!");
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt == null) {
            return false;
        }
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.text;
    }

    @Override
    public boolean stopCellEditing() {
        if (ObjectUtils.equals((Object)this.getCellEditorValue(), (Object)this.originalValue)) {
            this.cancelCellEditing();
        } else {
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String text;
        this.panel.setBackground(table.getSelectionBackground());
        this.label.setBackground(this.panel.getBackground());
        this.label.setMaximumSize(new Dimension(table.getColumnModel().getColumn(column).getWidth(), 19));
        this.text = text = (String)value;
        this.originalValue = text;
        this.label.setText(text);
        return this.panel;
    }

    private class ValueDialog
    extends MirthDialog {
        public ValueDialog(final JTable table) {
            super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
            this.setTitle("Value");
            this.setPreferredSize(new Dimension(600, 500));
            this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill", "", "[grow]7[]"));
            this.setBackground(UIConstants.BACKGROUND_COLOR);
            this.getContentPane().setBackground(this.getBackground());
            final MirthSyntaxTextArea textArea = new MirthSyntaxTextArea();
            textArea.setSaveEnabled(false);
            textArea.setText(MirthDialogTableCellEditor.this.text);
            textArea.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)textArea, "grow");
            this.add((Component)new JSeparator(), "newline, grow");
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
            buttonPanel.setBackground(this.getBackground());
            JButton openFileButton = new JButton("Open File...");
            openFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String content = PlatformUI.MIRTH_FRAME.browseForFileString(null);
                    if (content != null) {
                        textArea.setText(content);
                    }
                }
            });
            buttonPanel.add(openFileButton);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MirthDialogTableCellEditor.this.text = textArea.getText();
                    MirthDialogTableCellEditor.this.label.setText(MirthDialogTableCellEditor.this.text);
                    table.getModel().setValueAt(MirthDialogTableCellEditor.this.text, table.getSelectedRow(), table.getSelectedColumn());
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                    ValueDialog.this.dispose();
                }
            });
            buttonPanel.add(okButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ValueDialog.this.dispose();
                }
            });
            buttonPanel.add(cancelButton);
            this.add((Component)buttonPanel, "newline, right");
            this.pack();
            this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
            this.setVisible(true);
        }
    }
}

