/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.components.MirthTextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;

public class MirthIconTextField
extends MirthTextField {
    private Icon icon;
    private Insets insets;
    private String originalToolTipText;
    private String alternateToolTipText;
    private Component iconPopupMenuComponent;

    public MirthIconTextField() {
        this((Icon)null);
    }

    public MirthIconTextField(Icon icon) {
        this.setIcon(icon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (MirthIconTextField.this.isIconActive(evt) && MirthIconTextField.this.iconPopupMenuComponent != null) {
                    JPopupMenu iconPopupMenu = new JPopupMenu();
                    iconPopupMenu.insert(MirthIconTextField.this.iconPopupMenuComponent, 0);
                    iconPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                if (MirthIconTextField.this.isIconActive(evt)) {
                    if (StringUtils.isNotBlank((CharSequence)MirthIconTextField.this.alternateToolTipText)) {
                        MirthIconTextField.super.setToolTipText(MirthIconTextField.this.alternateToolTipText);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)MirthIconTextField.this.alternateToolTipText)) {
                    MirthIconTextField.super.setToolTipText(MirthIconTextField.this.originalToolTipText);
                }
                MirthIconTextField.this.mouseMovedAction(evt);
            }
        });
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public void setToolTipText(String text) {
        this.originalToolTipText = text;
        super.setToolTipText(text);
    }

    public void setAlternateToolTipText(String text) {
        this.alternateToolTipText = text;
    }

    public void setIconPopupMenuComponent(Component component) {
        this.iconPopupMenuComponent = component;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.insets == null) {
            this.insets = this.getMargin();
            if (this.insets == null) {
                this.insets = new Insets(0, 0, 0, 0);
            }
        }
        if (this.icon != null) {
            this.setMargin(new Insets(this.insets.top, this.insets.left + this.icon.getIconWidth(), this.insets.bottom, this.insets.right));
        } else {
            this.setMargin(this.insets);
        }
        super.paintComponent(g);
        if (this.icon != null) {
            if (this.icon instanceof ImageIcon) {
                g.drawImage(((ImageIcon)this.icon).getImage(), 2, (this.getHeight() - this.icon.getIconHeight()) / 2, this);
            } else {
                this.icon.paintIcon(this, g, 2, (this.getHeight() - this.icon.getIconHeight()) / 2);
            }
        }
    }

    protected void mouseMovedAction(MouseEvent evt) {
        int cursorType = this.getCursor().getType();
        if (this.isIconActive(evt)) {
            if (this.iconPopupMenuComponent != null) {
                if (cursorType != 12) {
                    this.setCursor(new Cursor(12));
                }
            } else if (cursorType != 0) {
                this.setCursor(new Cursor(0));
            }
        } else if (cursorType != 2) {
            this.setCursor(new Cursor(2));
        }
    }

    protected boolean isIconActive(MouseEvent evt) {
        return this.icon != null && evt.getX() < this.icon.getIconWidth();
    }
}

