/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.actions.CopyAction;
import com.mirth.connect.client.ui.actions.CutAction;
import com.mirth.connect.client.ui.actions.DeleteAction;
import com.mirth.connect.client.ui.actions.FindAndReplaceAction;
import com.mirth.connect.client.ui.actions.PasteAction;
import com.mirth.connect.client.ui.actions.RedoAction;
import com.mirth.connect.client.ui.actions.SelectAllAction;
import com.mirth.connect.client.ui.actions.ShowLineEndingsAction;
import com.mirth.connect.client.ui.actions.UndoAction;
import com.mirth.connect.client.ui.components.MirthTextInterface;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;

public class MirthSyntaxTextArea
extends JEditTextArea
implements MirthTextInterface {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private DeleteAction deleteAction;
    private SelectAllAction selectAllAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private FindAndReplaceAction findReplaceAction;
    private ShowLineEndingsAction showLineEndingsAction;
    private boolean saveDisabled;

    public MirthSyntaxTextArea() {
        this(false);
    }

    public MirthSyntaxTextArea(boolean lineNumbers) {
        this.setFocusable(true);
        this.setCaretVisible(false);
        this.setShowLineEndings(false);
        this.saveDisabled = false;
        this.cutAction = new CutAction(this);
        this.copyAction = new CopyAction(this);
        this.pasteAction = new PasteAction(this);
        this.deleteAction = new DeleteAction(this);
        this.selectAllAction = new SelectAllAction(this);
        this.undoAction = new UndoAction(this);
        this.redoAction = new RedoAction(this);
        this.findReplaceAction = new FindAndReplaceAction(this);
        this.showLineEndingsAction = new ShowLineEndingsAction(this);
        this.popup = new JPopupMenu();
        this.popup.add(this.undoAction);
        this.popup.add(this.redoAction);
        this.popup.addSeparator();
        this.popup.add(this.cutAction);
        this.popup.add(this.copyAction);
        this.popup.add(this.pasteAction);
        this.popup.addSeparator();
        this.popup.add(this.deleteAction);
        this.popup.addSeparator();
        this.popup.add(this.selectAllAction);
        this.popup.add(this.findReplaceAction);
        this.popup.add(new JCheckBoxMenuItem(this.showLineEndingsAction));
        this.popupHandler = new JEditTextArea.PopUpHandler(){

            @Override
            public void showPopupMenu(JPopupMenu menu, MouseEvent evt) {
                menu.getComponent(0).setEnabled(MirthSyntaxTextArea.this.undoAction.isEnabled());
                menu.getComponent(1).setEnabled(MirthSyntaxTextArea.this.redoAction.isEnabled());
                menu.getComponent(3).setEnabled(MirthSyntaxTextArea.this.cutAction.isEnabled());
                menu.getComponent(4).setEnabled(MirthSyntaxTextArea.this.copyAction.isEnabled());
                menu.getComponent(5).setEnabled(MirthSyntaxTextArea.this.pasteAction.isEnabled());
                menu.getComponent(7).setEnabled(MirthSyntaxTextArea.this.deleteAction.isEnabled());
                menu.getComponent(9).setEnabled(MirthSyntaxTextArea.this.selectAllAction.isEnabled());
                menu.getComponent(10).setEnabled(MirthSyntaxTextArea.this.findReplaceAction.isEnabled());
                menu.getComponent(11).setEnabled(MirthSyntaxTextArea.this.showLineEndingsAction.isEnabled());
                if (MirthSyntaxTextArea.this.isShowLineEndings()) {
                    ((JCheckBoxMenuItem)menu.getComponent(11)).setState(true);
                } else {
                    ((JCheckBoxMenuItem)menu.getComponent(11)).setState(false);
                }
                menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        };
    }

    public void undo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
        }
    }

    public void redo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
        }
    }

    public boolean canRedo() {
        return this.undo.canRedo();
    }

    public boolean canUndo() {
        return this.undo.canUndo();
    }

    public void setSaveEnabled(boolean saveEnabled) {
        this.saveDisabled = !saveEnabled;
    }

    @Override
    public void setDocument(SyntaxDocument doc) {
        super.setDocument(doc);
        if (!this.saveDisabled) {
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    MirthSyntaxTextArea.this.parent.setSaveEnabled(true);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    MirthSyntaxTextArea.this.parent.setSaveEnabled(true);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    MirthSyntaxTextArea.this.parent.setSaveEnabled(true);
                }
            });
        }
    }

    @Override
    public void setText(String t) {
        boolean visible = this.parent.changesHaveBeenMade();
        super.setText(t);
        if (visible) {
            this.parent.setSaveEnabled(true);
        } else {
            this.parent.setSaveEnabled(false);
        }
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    public void replaceSelection(String text) {
        this.setSelectedText(text);
    }
}

