/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class MirthTableTransferHandler
extends TransferHandler {
    private int primaryColumnIndex;
    private int secondaryColumnIndex;

    public MirthTableTransferHandler(int primaryColumnIndex, int secondaryColumnIndex) {
        this.primaryColumnIndex = primaryColumnIndex;
        this.secondaryColumnIndex = secondaryColumnIndex;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        TableModel model = ((JTable)c).getModel();
        int[] rows = c instanceof MirthTreeTable ? ((MirthTreeTable)((Object)c)).getSelectedModelRows() : ((MirthTable)((Object)c)).getSelectedModelRows();
        if (rows.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < rows.length; ++i) {
            builder.append(model.getValueAt(rows[i], this.primaryColumnIndex));
            String secondaryValue = String.valueOf(model.getValueAt(rows[i], this.secondaryColumnIndex));
            if (StringUtils.isNotBlank((CharSequence)secondaryValue)) {
                builder.append(" (");
                builder.append(model.getValueAt(rows[i], this.secondaryColumnIndex));
                builder.append(")");
            }
            if (i == rows.length - 1) continue;
            builder.append("\n");
        }
        return new StringSelection(builder.toString());
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (this.canImport(support)) {
            try {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                boolean showAlerts = fileList.size() == 1;
                for (File file : fileList) {
                    if (!FilenameUtils.isExtension((String)file.getName(), (String)"xml")) continue;
                    this.importFile(file, showAlerts);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    if (FilenameUtils.isExtension((String)file.getName(), (String)"xml")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public abstract void importFile(File var1, boolean var2);
}

