/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.actions.CopyAction;
import com.mirth.connect.client.ui.actions.CutAction;
import com.mirth.connect.client.ui.actions.DeleteAction;
import com.mirth.connect.client.ui.actions.PasteAction;
import com.mirth.connect.client.ui.actions.SelectAllAction;
import com.mirth.connect.client.ui.components.MirthTextInterface;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class MirthTextArea
extends JTextArea
implements MirthTextInterface {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private JPopupMenu menu;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private DeleteAction deleteAction;
    private SelectAllAction selectAllAction;

    public MirthTextArea() {
        this.setFocusable(true);
        this.setFont(UIConstants.MONOSPACED_FONT);
        this.cutAction = new CutAction(this);
        this.copyAction = new CopyAction(this);
        this.pasteAction = new PasteAction(this);
        this.deleteAction = new DeleteAction(this);
        this.selectAllAction = new SelectAllAction(this);
        this.menu = new JPopupMenu();
        this.menu.add(this.cutAction);
        this.menu.add(this.copyAction);
        this.menu.add(this.pasteAction);
        this.menu.add(this.deleteAction);
        this.menu.addSeparator();
        this.menu.add(this.selectAllAction);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isAccelerated;
                boolean bl = isAccelerated = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 || (e.getModifiers() & 2) > 0;
                if (e.getKeyCode() == 83 && isAccelerated) {
                    PlatformUI.MIRTH_FRAME.doContextSensitiveSave();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MirthTextArea.this.showPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MirthTextArea.this.showPopupMenu(evt);
            }
        });
    }

    private void showPopupMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.menu.getComponent(0).setEnabled(this.cutAction.isEnabled());
            this.menu.getComponent(1).setEnabled(this.copyAction.isEnabled());
            this.menu.getComponent(2).setEnabled(this.pasteAction.isEnabled());
            this.menu.getComponent(3).setEnabled(this.deleteAction.isEnabled());
            this.menu.getComponent(5).setEnabled(this.selectAllAction.isEnabled());
            this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MirthTextArea.this.parent.setSaveEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MirthTextArea.this.parent.setSaveEnabled(true);
            }
        });
    }

    @Override
    public void setText(String t) {
        boolean visible = this.parent.changesHaveBeenMade();
        super.setText(t);
        if (visible) {
            this.parent.setSaveEnabled(true);
        } else {
            this.parent.setSaveEnabled(false);
        }
    }
}

