/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MapperDropData;
import com.mirth.connect.client.ui.MessageBuilderDropData;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TreeTransferable;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTreeNode;
import com.mirth.connect.donkey.model.message.SerializationType;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTree;

public class MirthTree
extends JXTree
implements DropTargetListener {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private MyFilter mf;
    private FilterTreeModel ftm;
    private String prefix;
    private String suffix;
    private DropTarget dropTarget;
    private DataFlavor supportedDropFlavor;

    public MirthTree() {
        this(null, null, null);
    }

    public MirthTree(MirthTreeNode root, String prefix, String suffix) {
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.setFont(UIConstants.MONOSPACED_FONT);
                this.putClientProperty("html.disable", Boolean.TRUE);
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
        });
        this.mf = new MyFilter();
        this.ftm = new FilterTreeModel(root, this.mf);
        this.setModel(this.ftm);
        this.dropTarget = new DropTarget((Component)((Object)this), this);
        this.prefix = prefix;
        this.suffix = suffix;
        if (prefix != null) {
            if (prefix.equals("msg")) {
                this.supportedDropFlavor = TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR;
            } else if (prefix.equals("tmp")) {
                this.supportedDropFlavor = TreeTransferable.MAPPER_DATA_FLAVOR;
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (this.parent.currentContentPage == this.parent.channelEditPanel.transformerPane && tr.isDataFlavorSupported(this.supportedDropFlavor)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(this.supportedDropFlavor)) {
            return;
        }
        Point cursorLocationBis = dtde.getLocation();
        TreePath destinationPath = this.getPathForLocation(cursorLocationBis.x, cursorLocationBis.y);
        if (destinationPath != null && ((MirthTreeNode)destinationPath.getLastPathComponent()).isLeaf()) {
            this.setSelectionPath(destinationPath);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.parent.currentContentPage != this.parent.channelEditPanel.transformerPane) {
            return;
        }
        try {
            TreeNode selectedNode = (TreeNode)this.getLastSelectedPathComponent();
            if (selectedNode == null) {
                return;
            }
            dtde.acceptDrop(3);
            Transferable tr = dtde.getTransferable();
            if (this.supportedDropFlavor == TreeTransferable.MAPPER_DATA_FLAVOR) {
                Object transferData = tr.getTransferData(TreeTransferable.MAPPER_DATA_FLAVOR);
                MapperDropData data = (MapperDropData)transferData;
                this.parent.channelEditPanel.transformerPane.addNewElement(MirthTree.constructMessageBuilderStepName(data.getNode(), selectedNode), MirthTree.constructPath(selectedNode, this.prefix, this.suffix).toString(), data.getMapping(), "Message Builder", true);
            } else if (this.supportedDropFlavor == TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR) {
                Object transferData = tr.getTransferData(TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR);
                MessageBuilderDropData data = (MessageBuilderDropData)transferData;
                this.parent.channelEditPanel.transformerPane.addNewElement(MirthTree.constructMessageBuilderStepName(selectedNode, data.getNode()), data.getMessageSegment(), MirthTree.constructPath(selectedNode, this.prefix, this.suffix).toString(), "Message Builder", true);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static int getIndexOfNode(TreeNode node) {
        String nodeName = node.toString().replaceAll(" \\(.*\\)", "");
        TreeNode parent = node.getParent();
        if (parent != null) {
            Enumeration<? extends TreeNode> children = parent.children();
            int indexCounter = 0;
            int foundIndex = -1;
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (child.getChildCount() <= 0 || !nodeName.equals(child.toString().replaceAll(" \\(.*\\)", ""))) continue;
                if (child != node) {
                    ++indexCounter;
                    continue;
                }
                foundIndex = indexCounter++;
            }
            if (indexCounter > 1) {
                return foundIndex;
            }
        }
        return -1;
    }

    public static StringBuilder constructPath(TreeNode parent, String prefix, String suffix) {
        Object nodeValue;
        StringBuilder sb = new StringBuilder();
        sb.insert(0, prefix);
        if (parent == null) {
            return sb.append(suffix);
        }
        MirthTreeNode node = (MirthTreeNode)parent;
        SerializationType serializationType = node.getSerializationType();
        if (node.isLeaf()) {
            node = (MirthTreeNode)node.getParent();
        }
        LinkedList<PathNode> nodeQ = new LinkedList<PathNode>();
        while (node != null && node.getParent() != null) {
            if (serializationType.equals((Object)SerializationType.JSON) && node.isArrayElement()) {
                nodeQ.add(new PathNode(String.valueOf(node.getParent().getIndex(node) - 1), PathNode.NodeType.ARRAY_CHILD));
            } else {
                int parentIndexValue;
                PathNode.NodeType type = PathNode.NodeType.OTHER;
                if (serializationType.equals((Object)SerializationType.XML)) {
                    type = MirthTree.getXmlNodeType(node);
                }
                nodeValue = node.getValue().replaceAll(" \\(.*\\)", "");
                nodeQ.add(new PathNode((String)nodeValue, type));
                if (serializationType.equals((Object)SerializationType.XML) && (parentIndexValue = MirthTree.getIndexOfNode(node)) != -1) {
                    nodeQ.add(nodeQ.size() - 1, new PathNode(String.valueOf(parentIndexValue), PathNode.NodeType.ARRAY_CHILD));
                }
            }
            node = (MirthTreeNode)node.getParent();
        }
        boolean foundImplicitNamespace = false;
        while (!nodeQ.isEmpty()) {
            nodeValue = (PathNode)nodeQ.removeLast();
            boolean includeNamespace = false;
            PathNode.NodeType type = ((PathNode)nodeValue).getType();
            if (serializationType.equals((Object)SerializationType.XML) && !Arrays.asList(PathNode.NodeType.XML_ATTRIBUTE, PathNode.NodeType.XMLNS_DEFINITION, PathNode.NodeType.XML_PREFIX_DEFINITION, PathNode.NodeType.ARRAY_CHILD).contains((Object)type)) {
                if (foundImplicitNamespace) {
                    includeNamespace = true;
                } else if (type == PathNode.NodeType.XML_XMLNS_NODE) {
                    foundImplicitNamespace = true;
                    includeNamespace = true;
                } else if (type == PathNode.NodeType.XML_PREFIXED_NODE) {
                    includeNamespace = true;
                }
            }
            if (includeNamespace) {
                int colonIndex = ((PathNode)nodeValue).getValue().indexOf(58) + 1;
                sb.append(".*::['" + StringUtils.substring((String)((PathNode)nodeValue).getValue(), (int)colonIndex) + "']");
                continue;
            }
            if (serializationType.equals((Object)SerializationType.XML) && type == PathNode.NodeType.XMLNS_DEFINITION) {
                sb.append(".namespace('')");
                continue;
            }
            if (serializationType.equals((Object)SerializationType.XML) && type == PathNode.NodeType.XML_PREFIX_DEFINITION) {
                sb.append(".namespace('" + StringUtils.substringAfter((String)((PathNode)nodeValue).getValue(), (String)"@xmlns:") + "')");
                continue;
            }
            if (type == PathNode.NodeType.XML_PREFIXED_ATTRIBUTE) {
                sb.append(".@*::['" + StringUtils.substringAfter((String)((PathNode)nodeValue).getValue(), (String)":") + "']");
                continue;
            }
            if (type == PathNode.NodeType.ARRAY_CHILD) {
                sb.append("[" + ((PathNode)nodeValue).getValue() + "]");
                continue;
            }
            sb.append("['" + ((PathNode)nodeValue).getValue() + "']");
        }
        if (!serializationType.equals((Object)SerializationType.JSON)) {
            sb.append(suffix);
        }
        return sb;
    }

    private static boolean nodeContainImplicitNamespace(MirthTreeNode treeNode) {
        MirthTreeNode childNode = null;
        Enumeration<TreeNode> children = treeNode.children();
        while (children.hasMoreElements()) {
            childNode = (MirthTreeNode)children.nextElement();
            if (!StringUtils.equals((CharSequence)childNode.getValue().replaceAll(" \\(.*\\)", ""), (CharSequence)"@xmlns")) continue;
            return true;
        }
        return false;
    }

    private static PathNode.NodeType getXmlNodeType(MirthTreeNode node) {
        PathNode.NodeType type = null;
        String nodeValue = node.getValue().replaceAll(" \\(.*\\)", "");
        if (MirthTree.nodeContainImplicitNamespace(node)) {
            type = PathNode.NodeType.XML_XMLNS_NODE;
        } else if (StringUtils.startsWith((CharSequence)nodeValue, (CharSequence)"@xmlns")) {
            type = StringUtils.contains((CharSequence)nodeValue, (CharSequence)":") ? PathNode.NodeType.XML_PREFIX_DEFINITION : PathNode.NodeType.XMLNS_DEFINITION;
        } else if (StringUtils.contains((CharSequence)nodeValue, (CharSequence)"@")) {
            type = StringUtils.contains((CharSequence)nodeValue, (CharSequence)":") ? PathNode.NodeType.XML_PREFIXED_ATTRIBUTE : PathNode.NodeType.XML_ATTRIBUTE;
        } else if (StringUtils.contains((CharSequence)nodeValue, (CharSequence)":")) {
            type = PathNode.NodeType.XML_PREFIXED_NODE;
        }
        return type;
    }

    public static String constructVariable(TreeNode parent) {
        Object variable = "";
        if (parent == null) {
            return "msg";
        }
        MirthTreeNode node = (MirthTreeNode)parent;
        SerializationType serializationType = node.getSerializationType();
        if (node.isLeaf()) {
            node = (MirthTreeNode)node.getParent();
        }
        boolean wasArrayElement = false;
        while (node != null && node.getParent() != null) {
            String parentName = node.getValue();
            Pattern pattern = Pattern.compile(" (\\(.*\\))");
            Matcher matcher = pattern.matcher(parentName.toString());
            if (serializationType.equals((Object)SerializationType.JSON) && node.isArrayElement()) {
                if (((String)variable).length() != 0) {
                    variable = "_" + (String)variable;
                }
                variable = node.getParent().getIndex(node) - 1 + (String)variable;
                wasArrayElement = true;
            } else {
                int parentIndexValue;
                Object parentIndex = "";
                if (serializationType.equals((Object)SerializationType.XML) && (parentIndexValue = MirthTree.getIndexOfNode(node)) != -1) {
                    parentIndex = (String)parentIndex + parentIndexValue;
                }
                if (((String)variable).length() != 0 && !wasArrayElement) {
                    variable = "_" + (String)variable;
                }
                variable = matcher.find() ? MirthTree.removeInvalidVariableCharacters(matcher.group(1)) + (String)parentIndex + (String)variable : MirthTree.removeInvalidVariableCharacters(node.getValue().replaceAll(" \\(.*\\)", "")) + (String)parentIndex + (String)variable;
                wasArrayElement = false;
            }
            node = (MirthTreeNode)node.getParent();
        }
        return variable;
    }

    public static String constructMessageBuilderStepName(TreeNode in, TreeNode out) {
        if (in != null) {
            return MirthTree.constructNodeDescription(out) + " (out) <-- " + MirthTree.constructNodeDescription(in) + " (in)";
        }
        return MirthTree.constructNodeDescription(out) + " (out)";
    }

    public static String constructNodeDescription(TreeNode parent) {
        Object description = "";
        MirthTreeNode node = (MirthTreeNode)parent;
        SerializationType serializationType = node.getSerializationType();
        if (node.isLeaf()) {
            node = (MirthTreeNode)node.getParent();
        }
        boolean wasArrayElement = false;
        while (node != null && node.getParent() != null) {
            String parentName = node.getValue();
            Pattern pattern = Pattern.compile(" (\\(.*\\))");
            Matcher matcher = pattern.matcher(parentName.toString());
            Object parentIndex = "";
            if (serializationType.equals((Object)SerializationType.JSON) && node.isArrayElement()) {
                if (!wasArrayElement) {
                    description = " - " + (String)description;
                }
                description = " [" + (node.getParent().getIndex(node) - 1) + "]" + (String)description;
                wasArrayElement = true;
            } else {
                int parentIndexValue;
                if (serializationType.equals((Object)SerializationType.XML) && (parentIndexValue = MirthTree.getIndexOfNode(node)) != -1) {
                    parentIndex = " [" + parentIndexValue + "]";
                }
                if (matcher.find()) {
                    String matchDescription = matcher.group(1);
                    matchDescription = matchDescription.substring(1, matchDescription.length() - 1);
                    description = matchDescription + (String)parentIndex + (String)(((String)description).length() == 0 ? " (" + node.getValue().replaceAll(" \\(.*\\)", "") + ")" : " - ") + (String)description;
                } else {
                    description = node.getValue() + (String)parentIndex + (((String)description).length() != 0 && !wasArrayElement ? " - " : "") + (String)description;
                }
                wasArrayElement = false;
            }
            node = (MirthTreeNode)node.getParent();
        }
        return description;
    }

    private static String removeInvalidVariableCharacters(String source) {
        source = ((String)source).toLowerCase();
        source = ((String)source).replaceAll("\\/", " or ");
        source = ((String)source).replaceAll(" - ", "_");
        source = ((String)source).replaceAll("&", " and ");
        source = ((String)source).replace("@", "att ");
        source = ((String)source).replaceAll("[^a-zA-Z0-9_\\s]", "");
        source = ((String)source).trim();
        while (((String)source).charAt(((String)source).length() - 1) == '.' || ((String)source).charAt(0) == '.') {
            if (((String)source).charAt(((String)source).length() - 1) == '.') {
                source = ((String)source).substring(0, ((String)source).length() - 1);
            }
            if (((String)source).charAt(0) == '.') {
                source = ((String)source).substring(1);
            }
            source = ((String)source).trim();
        }
        while (((String)source).indexOf(32) != -1 || ((String)source).indexOf(46) != -1) {
            int index = ((String)source).indexOf(32);
            int index2 = ((String)source).indexOf(46);
            if (index2 != -1 && index2 < index) {
                index = index2;
            }
            if (index == -1) {
                index = index2;
            }
            source = ((String)source).replaceFirst(" |\\.", "");
            source = ((String)source).substring(0, index) + ((String)source).substring(index, index + 1).toUpperCase() + ((String)source).substring(index + 1);
        }
        return source;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    class MyFilter
    implements Filter {
        boolean pass = true;

        MyFilter() {
        }

        @Override
        public boolean pass(Object obj, String text, boolean exact) {
            if (this.pass) {
                return true;
            }
            String s = obj.toString();
            if (exact) {
                return s.equals(text);
            }
            return s.toLowerCase().indexOf(text.toLowerCase()) != -1;
        }

        @Override
        public void setFiltered(boolean pass) {
            this.pass = pass;
        }

        @Override
        public boolean isFiltered() {
            return this.pass;
        }
    }

    public class FilterTreeModel
    extends DefaultTreeModel {
        Filter filter;

        @Override
        public TreeNode getRoot() {
            return this.root;
        }

        public FilterTreeModel(TreeNode root, Filter filter) {
            super(root);
            this.filter = filter;
        }

        public void setFiltered(boolean pass) {
            this.filter.setFiltered(!pass);
        }

        public void updateTreeStructure() {
            if (this.getRoot() != null) {
                TreeNode tn = this.getRoot();
                int count = tn.getChildCount();
                Object[] path = new Object[]{tn};
                int[] childIndices = new int[count];
                Object[] children = new Object[count];
                this.fireTreeStructureChanged(tn, path, childIndices, children);
            }
        }

        public boolean performFilter(TreeNode tn, String text, boolean exact, boolean ignoreChildren) {
            boolean passed;
            if (tn == null) {
                return false;
            }
            int realCount = super.getChildCount(tn);
            boolean originalPassed = passed = this.filter.pass(tn, text, exact) || ignoreChildren;
            for (int i = 0; i < realCount; ++i) {
                boolean childPassed = this.performFilter(tn.getChildAt(i), text, exact, originalPassed);
                passed = passed || childPassed;
            }
            ((MirthTreeNode)tn).setFiltered(!passed);
            int count = tn.getChildCount();
            Object[] path = new Object[]{tn};
            int[] childIndices = new int[count];
            Object[] children = new Object[count];
            return passed;
        }

        @Override
        public int getChildCount(Object parent) {
            int realCount = super.getChildCount(parent);
            int visibleCount = 0;
            for (int i = 0; i < realCount; ++i) {
                MirthTreeNode mtn = (MirthTreeNode)super.getChild(parent, i);
                if (mtn.isFiltered()) continue;
                ++visibleCount;
            }
            return visibleCount;
        }

        @Override
        public Object getChild(Object parent, int index) {
            int cnt = -1;
            for (int i = 0; i < super.getChildCount(parent); ++i) {
                MirthTreeNode child = (MirthTreeNode)super.getChild(parent, i);
                if (!child.isFiltered()) {
                    ++cnt;
                }
                if (cnt != index) continue;
                return child;
            }
            return null;
        }
    }

    static interface Filter {
        public boolean pass(Object var1, String var2, boolean var3);

        public void setFiltered(boolean var1);

        public boolean isFiltered();
    }

    private static class PathNode {
        private String value;
        private NodeType type;

        public PathNode(String value, NodeType type) {
            this.value = value;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public NodeType getType() {
            return this.type;
        }

        public static enum NodeType {
            ARRAY_CHILD,
            XML_PREFIXED_NODE,
            XML_XMLNS_NODE,
            XML_PREFIX_DEFINITION,
            XMLNS_DEFINITION,
            XML_ATTRIBUTE,
            XML_PREFIXED_ATTRIBUTE,
            OTHER;

        }
    }
}

