/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.mirth.connect.client.ui.AbstractDashboardTableNode;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.SortableHeaderCellRenderer;
import com.mirth.connect.client.ui.SortableTreeTable;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MirthTreeTable
extends SortableTreeTable {
    private static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static String PREFERENCE_COLUMN_ORDER_MAP = "TreeColumnOrderMap";
    private static String PREFERENCE_SORT_ORDER = "TreeSortOrder";
    private static String PREFERENCE_SORT_ORDER_COLUMN = "TreeSortOrderColumn";
    private Map<String, Set<String>> customHiddenColumnMap = new HashMap<String, Set<String>>();
    private String channelId;
    private Preferences userPreferences;
    private String prefix;
    private Map<String, Integer> columnOrderMap;
    private int sortOrderColumn;
    private SortOrder sortOrder;
    private Set<String> defaultVisibleColumns;
    private Set<String> metaDataColumns;
    private MouseAdapter treeTableSortAdapter;
    private MouseAdapter rightClickMouseAdapter;
    private TransferHandler transferHandler;

    public MirthTreeTable() {
        this(null, null);
    }

    public MirthTreeTable(String prefix, Set<String> defaultVisibleColumns) {
        this.prefix = prefix;
        this.defaultVisibleColumns = defaultVisibleColumns;
        this.columnOrderMap = new HashMap<String, Integer>();
        this.sortOrderColumn = -1;
        this.sortOrder = null;
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            try {
                this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
                String columns = this.userPreferences.get(prefix + PREFERENCE_COLUMN_ORDER_MAP, "");
                if (StringUtils.isNotEmpty((CharSequence)columns)) {
                    this.columnOrderMap = (Map)ObjectXMLSerializer.getInstance().deserialize(columns, Map.class);
                }
            }
            catch (Exception columns) {
                // empty catch block
            }
            try {
                String order = this.userPreferences.get(prefix + PREFERENCE_SORT_ORDER, "");
                if (StringUtils.isNotEmpty((CharSequence)order)) {
                    this.sortOrder = (SortOrder)((Object)ObjectXMLSerializer.getInstance().deserialize(order, SortOrder.class));
                    this.sortOrderColumn = this.userPreferences.getInt(prefix + PREFERENCE_SORT_ORDER_COLUMN, -1);
                }
            }
            catch (Exception order) {
                // empty catch block
            }
        }
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isAccelerated;
                boolean bl = isAccelerated = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0 || (e.getModifiers() & 2) > 0;
                if (e.getKeyCode() == 83 && isAccelerated) {
                    PlatformUI.MIRTH_FRAME.doContextSensitiveSave();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                MirthTreeTable.this.saveColumnOrder();
            }
        });
        header.setDefaultRenderer(new SortableHeaderCellRenderer(header.getDefaultRenderer()));
        JButton columnControlButton = new JButton(new ColumnControlButton((JXTable)this).getIcon());
        this.configureColumnControlAction(columnControlButton);
        this.setColumnControl(columnControlButton);
    }

    protected void configureColumnControlAction(final JButton columnControlButton) {
        columnControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu columnMenu = MirthTreeTable.this.getColumnMenu();
                Dimension buttonSize = columnControlButton.getSize();
                int xPos = columnControlButton.getComponentOrientation().isLeftToRight() ? buttonSize.width - columnMenu.getPreferredSize().width : 0;
                columnMenu.show(columnControlButton, xPos, columnControlButton.getHeight());
            }
        });
    }

    protected void beforeSort() {
    }

    protected void afterSort() {
    }

    public void setSortable(boolean enable) {
        super.setSortable(enable);
        JTableHeader header = this.getTableHeader();
        if (enable) {
            if (this.treeTableSortAdapter == null) {
                this.treeTableSortAdapter = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            int viewColumn;
                            JTableHeader h = (JTableHeader)e.getSource();
                            TableColumnModel columnModel = MirthTreeTable.this.getColumnModel();
                            int column = columnModel.getColumn(viewColumn = h.columnAtPoint(e.getPoint())).getModelIndex();
                            if (column != -1) {
                                MirthTreeTable.this.beforeSort();
                                SortableTreeTableModel model = (SortableTreeTableModel)MirthTreeTable.this.getTreeTableModel();
                                model.setColumnAndToggleSortOrder(column);
                                ((SortableHeaderCellRenderer)MirthTreeTable.this.getTableHeader().getDefaultRenderer()).setSortingIcon(model.getSortOrder());
                                ((SortableHeaderCellRenderer)MirthTreeTable.this.getTableHeader().getDefaultRenderer()).setColumnIndex(column);
                                MirthTreeTable.this.saveSortPreferences(column);
                                MirthTreeTable.this.afterSort();
                            }
                        }
                    }
                };
                header.addMouseListener(this.treeTableSortAdapter);
            }
        } else if (this.treeTableSortAdapter != null) {
            header.removeMouseListener(this.treeTableSortAdapter);
            this.treeTableSortAdapter = null;
        }
    }

    public void setMirthColumnControlEnabled(boolean enable) {
        if (enable) {
            if (this.rightClickMouseAdapter == null) {
                this.rightClickMouseAdapter = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            MirthTreeTable.this.getColumnMenu().show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                };
                this.getTableHeader().addMouseListener(this.rightClickMouseAdapter);
            }
        } else if (this.rightClickMouseAdapter != null) {
            this.getTableHeader().removeMouseListener(this.rightClickMouseAdapter);
            this.rightClickMouseAdapter = null;
        }
        this.setColumnControlVisible(enable);
    }

    public void setMirthTransferHandlerEnabled(boolean enable) {
        this.setDragEnabled(enable);
        if (this.transferHandler == null) {
            this.transferHandler = new TransferHandler(){

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                protected Transferable createTransferable(JComponent c) {
                    int row = MirthTreeTable.this.getSelectedRow();
                    ArrayList<Object> columnValuesList = new ArrayList<Object>();
                    for (TableColumn column : MirthTreeTable.this.getColumns()) {
                        Object value = MirthTreeTable.this.getValueAt(row, MirthTreeTable.this.convertColumnIndexToView(column.getModelIndex()));
                        if (value != null) {
                            if (value instanceof Calendar) {
                                GregorianCalendar calendar = (GregorianCalendar)value;
                                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                                dateFormat.setCalendar(calendar);
                                value = dateFormat.format(calendar.getTime());
                            } else {
                                value = value instanceof Long ? String.valueOf(value) : (value instanceof Status ? Status.fromChar((char)((Status)value).getStatusCode()) : String.valueOf(value));
                            }
                        } else {
                            value = "-";
                        }
                        columnValuesList.add(value);
                    }
                    return new StringSelection(StringUtils.join(columnValuesList, (String)" "));
                }
            };
            this.setTransferHandler(this.transferHandler);
        }
    }

    private JPopupMenu getColumnMenu() {
        SortableTreeTableModel model = (SortableTreeTableModel)this.getTreeTableModel();
        JPopupMenu columnMenu = new JPopupMenu();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            final String columnName = model.getColumnName(i);
            TableColumnExt column = this.getColumnExt(columnName);
            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(columnName);
            menuItem.setSelected(column.isVisible());
            if (!this.shouldAddMenuItem(columnName)) continue;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean enable;
                    TableColumnExt column = MirthTreeTable.this.getColumnExt(menuItem.getText());
                    boolean bl = enable = !column.isVisible();
                    if (enable || MirthTreeTable.this.getColumnCount() > 1) {
                        column.setVisible(enable);
                        Set<String> customHiddenColumns = MirthTreeTable.this.customHiddenColumnMap.get(MirthTreeTable.this.channelId);
                        if (customHiddenColumns != null) {
                            if (enable) {
                                customHiddenColumns.remove(columnName);
                            } else {
                                customHiddenColumns.add(columnName);
                            }
                        }
                    }
                    MirthTreeTable.this.saveColumnOrder();
                }
            });
            columnMenu.add(menuItem);
        }
        columnMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Collapse All");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MirthTreeTable.this.collapseAll();
            }
        });
        columnMenu.add(menuItem);
        menuItem = new JMenuItem("Expand All");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MirthTreeTable.this.expandAll();
            }
        });
        columnMenu.add(menuItem);
        columnMenu.addSeparator();
        menuItem = new JMenuItem("Restore Default");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MirthTreeTable.this.restoreDefaultVisibleColumns();
                MirthTreeTable.this.restoreDefaultColumnPreferences();
            }
        });
        columnMenu.add(menuItem);
        return columnMenu;
    }

    protected void restoreDefaultVisibleColumns() {
        if (this.metaDataColumns != null) {
            this.defaultVisibleColumns.addAll(this.metaDataColumns);
        }
    }

    public boolean shouldAddMenuItem(String columnName) {
        return true;
    }

    public Set<String> getMetaDataColumns() {
        return this.metaDataColumns;
    }

    public void setMetaDataColumns(Set<String> metaDataColumns, String channelId) {
        this.channelId = channelId;
        this.metaDataColumns = metaDataColumns;
    }

    public Map<String, Set<String>> getCustomHiddenColumnMap() {
        return this.customHiddenColumnMap;
    }

    public void saveColumnOrder() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                String columnName;
                int metaDataColumnOffset = 0;
                this.columnOrderMap.clear();
                for (TableColumn column : this.getColumns()) {
                    columnName = (String)column.getHeaderValue();
                    if (this.metaDataColumns != null && this.metaDataColumns.contains(columnName)) {
                        ++metaDataColumnOffset;
                    }
                    if (this.metaDataColumns != null && this.metaDataColumns.contains(columnName)) continue;
                    this.columnOrderMap.put(columnName, this.convertColumnIndexToView(column.getModelIndex()) - metaDataColumnOffset);
                }
                for (TableColumn column : this.getColumns(true)) {
                    columnName = (String)column.getHeaderValue();
                    if (this.columnOrderMap.keySet().contains(columnName) || this.metaDataColumns != null && this.metaDataColumns.contains(columnName)) continue;
                    this.columnOrderMap.put(columnName, -1);
                }
                this.userPreferences.put(this.prefix + PREFERENCE_COLUMN_ORDER_MAP, ObjectXMLSerializer.getInstance().serialize(new HashMap<String, Integer>(this.columnOrderMap)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restoreColumnPreferences() {
        if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
            try {
                Set<String> cachedColumns;
                Object column2;
                TableColumnModelExt columnModel = (TableColumnModelExt)this.getTableHeader().getColumnModel();
                TreeMap<Integer, Integer> columnOrder = new TreeMap<Integer, Integer>();
                int columnIndex = 0;
                for (Object column2 : columnModel.getColumns(true)) {
                    String columnName = (String)((TableColumn)column2).getIdentifier();
                    Integer viewIndex = this.columnOrderMap.get(columnName);
                    TableColumnExt columnExt = this.getColumnExt(columnName);
                    boolean visible = false;
                    visible = viewIndex == null ? this.defaultVisibleColumns == null || this.defaultVisibleColumns.contains(columnName) : viewIndex > -1;
                    columnExt.setVisible(visible);
                    if (viewIndex != null && viewIndex > -1) {
                        columnOrder.put(viewIndex, columnIndex);
                    }
                    ++columnIndex;
                }
                int viewIndex = 0;
                column2 = columnOrder.values().iterator();
                while (column2.hasNext()) {
                    int index = (Integer)column2.next();
                    columnModel.moveColumn(this.convertColumnIndexToView(index), viewIndex++);
                }
                if (CollectionUtils.isNotEmpty(this.metaDataColumns) && (cachedColumns = this.customHiddenColumnMap.get(this.channelId)) != null) {
                    for (String column3 : this.metaDataColumns) {
                        this.getColumnExt(column3).setVisible(!cachedColumns.contains(column3));
                    }
                }
                SortableTreeTableModel model = (SortableTreeTableModel)this.getTreeTableModel();
                if (this.sortOrderColumn > -1 && this.sortOrderColumn < model.getColumnCount()) {
                    model.setColumnAndToggleSortOrder(this.sortOrderColumn);
                    model.setSortOrder(this.sortOrder);
                    ((SortableHeaderCellRenderer)this.getTableHeader().getDefaultRenderer()).setSortingIcon(this.sortOrder);
                    ((SortableHeaderCellRenderer)this.getTableHeader().getDefaultRenderer()).setColumnIndex(this.sortOrderColumn);
                }
            }
            catch (Exception e) {
                this.restoreDefaultColumnPreferences();
            }
        }
    }

    public void saveSortPreferences(int column) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                SortOrder order = this.getSortOrder(column);
                this.userPreferences.put(this.prefix + PREFERENCE_SORT_ORDER, ObjectXMLSerializer.getInstance().serialize((Object)order));
                this.userPreferences.putInt(this.prefix + PREFERENCE_SORT_ORDER_COLUMN, column);
                this.sortOrder = order;
                this.sortOrderColumn = column;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restoreDefaultColumnPreferences() {
        try {
            this.userPreferences.put(this.prefix + PREFERENCE_COLUMN_ORDER_MAP, "");
            this.userPreferences.put(this.prefix + PREFERENCE_SORT_ORDER, "");
            this.userPreferences.putInt(this.prefix + PREFERENCE_SORT_ORDER_COLUMN, -1);
            if (StringUtils.isNotEmpty((CharSequence)this.prefix)) {
                TableColumnExt columnExt;
                this.columnOrderMap.clear();
                this.restoreDefaultCustomHiddenColumnMap();
                for (TableColumn column : this.getColumns(true)) {
                    TableColumnExt columnExt2 = (TableColumnExt)column;
                    columnExt2.setVisible(true);
                }
                int index = 0;
                for (TableColumn column : this.getColumns(true)) {
                    columnExt = (TableColumnExt)column;
                    this.columnModel.moveColumn(this.columnModel.getColumnIndex(columnExt.getTitle()), index++);
                }
                for (TableColumn column : this.getColumns(true)) {
                    columnExt = (TableColumnExt)column;
                    columnExt.setVisible(this.defaultVisibleColumns.contains(columnExt.getTitle()));
                }
                this.sortOrder = null;
                this.sortOrderColumn = -1;
                this.resetSortOrder();
                ((SortableHeaderCellRenderer)this.getTableHeader().getDefaultRenderer()).setSortingIcon(this.sortOrder);
                ((SortableHeaderCellRenderer)this.getTableHeader().getDefaultRenderer()).setColumnIndex(this.sortOrderColumn);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restoreDefaultCustomHiddenColumnMap() {
        if (this.customHiddenColumnMap.get(this.channelId) != null) {
            this.customHiddenColumnMap.get(this.channelId).clear();
        }
    }

    public void setCustomEditorControls(boolean enabled) {
        if (enabled) {
            AbstractAction toggleEditing = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MirthTreeTable.this.isEditing()) {
                        MirthTreeTable.this.getCellEditor().stopCellEditing();
                    } else {
                        boolean success = MirthTreeTable.this.editCellAt(MirthTreeTable.this.getSelectedRow(), MirthTreeTable.this.getSelectedColumn(), e);
                        if (success && MirthTreeTable.this.getCellEditor() instanceof TextFieldCellEditor) {
                            ((TextFieldCellEditor)MirthTreeTable.this.getCellEditor()).getTextField().requestFocusInWindow();
                        }
                    }
                }
            };
            this.setAutoStartEditOnKeyStroke(false);
            this.setSurrendersFocusOnKeystroke(true);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "toggleEditing");
            this.getActionMap().put("toggleEditing", toggleEditing);
        } else {
            this.setAutoStartEditOnKeyStroke(true);
            this.setSurrendersFocusOnKeystroke(false);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextRowCell");
        }
    }

    public Class getColumnClass(int column) {
        try {
            if (this.getRowCount() >= 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                return this.getValueAt(0, column).getClass();
            }
            return Object.class;
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public int getColumnViewIndex(String columnName) {
        int viewIndex = -1;
        for (TableColumn column : this.getColumns()) {
            if (!columnName.equals(column.getIdentifier())) continue;
            viewIndex = this.getColumnModel().getColumnIndex(columnName);
        }
        return viewIndex;
    }

    public int getColumnModelIndex(String columnName) {
        return this.convertColumnIndexToModel(this.getColumnModel().getColumnIndex(columnName));
    }

    public int getSelectedModelIndex() {
        int index = -1;
        index = this.isEditing() ? this.getEditingRow() : this.getSelectedRow();
        if (index == -1) {
            return index;
        }
        return this.convertRowIndexToModel(index);
    }

    public int[] getSelectedModelRows() {
        int[] views = this.getSelectedRows();
        for (int i = 0; i < views.length; ++i) {
            views[i] = this.convertRowIndexToModel(views[i]);
        }
        return views;
    }

    public List<AbstractDashboardTableNode> getSelectedNodes() {
        ArrayList<AbstractDashboardTableNode> nodes = new ArrayList<AbstractDashboardTableNode>();
        int[] selectedRows = this.getSelectedModelRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            AbstractDashboardTableNode node = (AbstractDashboardTableNode)((Object)this.getPathForRow(selectedRows[i]).getLastPathComponent());
            if (node.isGroupNode()) {
                Enumeration channelNodes = node.children();
                while (channelNodes.hasMoreElements()) {
                    nodes.add((AbstractDashboardTableNode)((Object)channelNodes.nextElement()));
                }
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }
}

