/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MirthTriStateCheckBox
extends JCheckBox {
    private static final int SIZE = LookUtils.IS_LOW_RESOLUTION ? 13 : 15;
    private static final int length = 7;
    public static final int CHECKED = 0;
    public static final int UNCHECKED = 1;
    public static final int PARTIAL = 2;

    public MirthTriStateCheckBox() {
        this(null, 1);
    }

    public MirthTriStateCheckBox(String text, int initial) {
        super.setText(text);
        this.setModel(new TriStateModel(initial));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int radius = 3;
        if (((TriStateModel)this.model).getState() == 2) {
            Object newAAHint = RenderingHints.VALUE_ANTIALIAS_ON;
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object oldAAHint = g2.getRenderingHint(key);
            if (newAAHint != oldAAHint) {
                g2.setRenderingHint(key, newAAHint);
            } else {
                oldAAHint = null;
            }
            this.drawFill(g2, this.model.isPressed(), 1, this.getHeight() / 2 - SIZE / 2 + 1, SIZE - 2, SIZE - 2);
            g2.setColor(this.isEnabled() ? UIManager.getColor("CheckBox.check").brighter().brighter() : MetalLookAndFeel.getControlDisabled());
            g2.fillRect(radius, this.getHeight() / 2 - radius, 7, 7);
            if (oldAAHint != null) {
                g2.setRenderingHint(key, oldAAHint);
            }
        }
    }

    private void drawFill(Graphics2D g2, boolean pressed, int x, int y, int w, int h) {
        ColorUIResource upperLeft = MetalLookAndFeel.getControlShadow();
        ColorUIResource lowerRight = PlasticLookAndFeel.getControlHighlight();
        g2.setPaint(new GradientPaint(x, y, upperLeft, x + w, y + h, lowerRight));
        g2.fillRect(x, y, w, h);
    }

    public void setState(int state) {
        ((TriStateModel)this.model).setState(state);
    }

    public int getState() {
        return ((TriStateModel)this.model).getState();
    }

    @Override
    public void setSelected(boolean selected) {
        ((TriStateModel)this.model).setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return ((TriStateModel)this.model).isSelected();
    }

    private class TriStateModel
    extends JToggleButton.ToggleButtonModel {
        protected int state;

        public TriStateModel(int state) {
            this.state = state;
        }

        @Override
        public boolean isSelected() {
            return this.state == 0;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
            this.fireStateChanged();
        }

        @Override
        public void setSelected(boolean selected) {
            switch (this.state) {
                case 1: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 0;
                    break;
                }
                case 0: {
                    this.state = 1;
                }
            }
        }
    }
}

