/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.mirth.connect.client.ui.components.rsta.MirthInputMap;
import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxTextArea;
import com.mirth.connect.client.ui.components.rsta.actions.ActionInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.fife.ui.rtextarea.RecordableTextAction;

public class CustomJCheckBoxMenuItem
extends JCheckBoxMenuItem
implements ActionListener {
    private JComponent parent;
    private ActionInfo actionInfo;

    public CustomJCheckBoxMenuItem(JComponent parent, Action action, ActionInfo actionInfo) {
        super(action);
        this.parent = parent;
        this.actionInfo = actionInfo;
        this.updateAccelerator();
        parent.getActionMap().put(actionInfo.getActionMapKey(), action);
        this.addActionListener(this);
    }

    public void updateAccelerator() {
        KeyStroke accelerator = MirthInputMap.getInstance().getKeyStroke(this.actionInfo);
        this.setAccelerator(accelerator);
        if (this.getAction() != null && this.getAction() instanceof RecordableTextAction) {
            ((RecordableTextAction)this.getAction()).setAccelerator(accelerator);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        MirthRSyntaxTextArea.getRSTAPreferences().getToggleOptions().put(this.actionInfo.getActionMapKey(), this.isSelected());
        MirthRSyntaxTextArea.updateToggleOptionPreferences();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.getAction() != null) {
            this.getAction().actionPerformed(new ActionEvent(this.parent, 1001, selected ? "forceOn" : "forceOff"));
        }
    }
}

