/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxTextArea;
import com.mirth.connect.model.codetemplates.ContextType;
import java.awt.Color;
import java.awt.Component;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rtextarea.RTextScrollPane;

public class MirthRTextScrollPane
extends RTextScrollPane
implements SyntaxConstants {
    private MirthRSyntaxTextArea textArea;

    public MirthRTextScrollPane(ContextType contextType) {
        this(contextType, true);
    }

    public MirthRTextScrollPane(ContextType contextType, boolean lineNumbers) {
        this(contextType, lineNumbers, "text/javascript");
    }

    public MirthRTextScrollPane(ContextType contextType, boolean lineNumbers, String styleKey) {
        this(contextType, lineNumbers, styleKey, true);
    }

    public MirthRTextScrollPane(ContextType contextType, boolean lineNumbers, String styleKey, boolean autoCompleteEnabled) {
        this.textArea = new MirthRSyntaxTextArea(contextType, styleKey, autoCompleteEnabled);
        this.setViewportView((Component)((Object)this.textArea));
        this.setFoldIndicatorEnabled(true);
        this.setLineNumbersEnabled(lineNumbers);
        this.getGutter().setBackground(UIConstants.COMBO_BOX_BACKGROUND);
    }

    public MirthRSyntaxTextArea getTextArea() {
        return this.textArea;
    }

    public void setContextType(ContextType contextType) {
        this.textArea.setContextType(contextType);
    }

    public String getText() {
        return this.textArea.getEOLFixedText();
    }

    public String getSelectedText() {
        return this.textArea.getEOLFixedSelectedText();
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public void setText(String text, boolean discardEdits) {
        this.textArea.setText(text, discardEdits);
    }

    public void setSelectedText(String text) {
        this.textArea.setSelectedText(text);
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    public void setSaveEnabled(boolean saveEnabled) {
        this.textArea.setSaveEnabled(saveEnabled);
    }

    public void setCaretPosition(int position) {
        this.textArea.setCaretPosition(position);
    }

    public void setSyntaxEditingStyle(String styleKey) {
        this.textArea.setSyntaxEditingStyle(styleKey);
    }

    public void updateDisplayOptions() {
        this.textArea.updateDisplayOptions();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.textArea != null) {
            this.textArea.setEnabled(enabled);
        }
    }

    public void setBackground(Color bg) {
        if (bg == null) {
            bg = UIConstants.BACKGROUND_COLOR;
        }
        super.setBackground(bg);
        if (this.textArea != null) {
            this.textArea.setBackground(bg);
        }
    }
}

