/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta.ac.js;

import com.mirth.connect.client.ui.components.rsta.ac.MirthFunctionCompletion;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ac.js.JavaScriptCellRenderer;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.Util;

public class MirthJavaScriptCellRenderer
extends JavaScriptCellRenderer {
    private static final String PREFIX = "<html><nobr>";
    private String typeColor = "#808080";
    private String paramColor = this.createParamColor();

    public void setTypeColor(Color color) {
        super.setTypeColor(color);
        if (color != null) {
            this.typeColor = Util.getHexString((Color)color);
        }
    }

    public void setParamColor(Color color) {
        super.setParamColor(color);
        if (color != null) {
            this.paramColor = Util.getHexString((Color)color);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.paramColor = this.createParamColor();
    }

    protected void prepareForFunctionCompletion(JList list, FunctionCompletion functionCompletion, int index, boolean selected, boolean hasFocus) {
        StringBuilder builder = new StringBuilder(PREFIX);
        if (functionCompletion instanceof MirthFunctionCompletion && ((MirthFunctionCompletion)functionCompletion).isDeprecated()) {
            builder.append("<strike>");
            builder.append(functionCompletion.getName());
            builder.append("</strike>");
        } else {
            builder.append(functionCompletion.getName());
        }
        char paramListStart = functionCompletion.getProvider().getParameterListStart();
        if (paramListStart != '\u0000') {
            builder.append(paramListStart);
        }
        int paramCount = functionCompletion.getParamCount();
        for (int i = 0; i < paramCount; ++i) {
            ParameterizedCompletion.Parameter param = functionCompletion.getParam(i);
            String type = param.getType();
            String name = param.getName();
            if (StringUtils.isNotBlank((CharSequence)type)) {
                if (selected) {
                    builder.append(type);
                } else {
                    builder.append("<font color='");
                    builder.append(this.paramColor);
                    builder.append("'>");
                    builder.append(type);
                    builder.append("</font>");
                }
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    builder.append(' ');
                }
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                builder.append(name);
            }
            if (i >= paramCount - 1) continue;
            builder.append(functionCompletion.getProvider().getParameterListSeparator());
        }
        char paramListEnd = functionCompletion.getProvider().getParameterListEnd();
        if (paramListEnd != '\u0000') {
            builder.append(paramListEnd);
        }
        if (this.getShowTypes() && StringUtils.isNotBlank((CharSequence)functionCompletion.getType())) {
            builder.append(" : ");
            if (selected) {
                builder.append(functionCompletion.getType());
            } else {
                builder.append("<font color='");
                builder.append(this.typeColor);
                builder.append("'>");
                builder.append(functionCompletion.getType());
                builder.append("</font>");
            }
        }
        this.setText(builder.toString());
    }

    private String createParamColor() {
        Color foreground = UIManager.getColor("Label.foreground");
        if (foreground == null) {
            foreground = new JLabel().getForeground();
        }
        Color hyperlinkForeground = Util.isLightForeground((Color)foreground) ? new Color(0xD8FFFF) : Color.BLUE;
        return Util.isLightForeground((Color)this.getForeground()) ? Util.getHexString((Color)hyperlinkForeground) : "#AA0077";
    }
}

