/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta.ac.js;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PartialHashMap<V>
extends HashMap<String, List<V>> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s+|-|(?=[A-Z0-9_][a-z])");
    private Map<String, String[]> splitMap = new HashMap<String, String[]>();

    @Override
    public void clear() {
        this.splitMap.clear();
        super.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.fixKey(key));
    }

    @Override
    public List<V> get(Object key) {
        return (List)super.get(this.fixKey(key));
    }

    public List<V> getPartial(Object key) {
        String fixedKey = this.fixKey(key);
        if (StringUtils.isBlank((CharSequence)fixedKey)) {
            ArrayList list = new ArrayList();
            for (List value : this.values()) {
                list.addAll(value);
            }
            return list;
        }
        ArrayList list = new ArrayList();
        block1: for (Map.Entry entry : this.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (((String)entry.getKey()).startsWith(fixedKey)) {
                list.addAll((Collection)entry.getValue());
                continue;
            }
            String[] array = this.splitMap.get(entryKey);
            if (array == null) continue;
            for (String element : array) {
                if (!element.startsWith(fixedKey)) continue;
                list.addAll((Collection)entry.getValue());
                continue block1;
            }
        }
        return list;
    }

    @Override
    public V put(String key, V value) {
        String fixedKey = this.fixKey(key);
        if (StringUtils.isNotBlank((CharSequence)fixedKey)) {
            List list;
            String[] splitArray;
            if (!this.splitMap.containsKey(fixedKey) && (splitArray = this.splitKey(key)).length > 0) {
                this.splitMap.put(fixedKey, splitArray);
            }
            if ((list = (List)super.get(fixedKey)) != null) {
                list.add(value);
            } else {
                super.put(fixedKey, new ArrayList<V>(Collections.singletonList(value)));
            }
            return null;
        }
        throw new RuntimeException("Key cannot be blank.");
    }

    @Override
    public List<V> put(String key, List<V> value) {
        String fixedKey = this.fixKey(key);
        if (StringUtils.isNotBlank((CharSequence)fixedKey)) {
            String[] splitArray;
            if (!this.splitMap.containsKey(fixedKey) && (splitArray = this.splitKey(key)).length > 0) {
                this.splitMap.put(fixedKey, splitArray);
            }
            return super.put(fixedKey, value);
        }
        throw new RuntimeException("Key cannot be blank.");
    }

    @Override
    public List<V> remove(Object key) {
        String fixedKey = this.fixKey(key);
        this.splitMap.remove(fixedKey);
        return (List)super.remove(fixedKey);
    }

    public void removeValue(Object key, Object value) {
        Object list = this.get(key);
        if (list != null) {
            list.remove(value);
            if (list.isEmpty()) {
                this.remove(key);
            }
        }
    }

    private String fixKey(Object key) {
        return (key != null ? String.valueOf(key) : "").toLowerCase().trim();
    }

    private String[] splitKey(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Scanner scanner = new Scanner(key);
        scanner.useDelimiter(SPLIT_PATTERN);
        while (scanner.hasNext()) {
            list.add(scanner.next().toLowerCase());
        }
        scanner.close();
        return list.toArray(new String[list.size()]);
    }
}

