/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.tag;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.tag.TagCompletion;
import com.mirth.connect.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class TagCompletionRenderer
extends DefaultListCellRenderer {
    private static String TAG_TYPE = "tag";
    private BufferedImage tagImage = ColorUtil.toBufferedImage((Image)UIConstants.ICON_TAG_GRAY.getImage());

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
        super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        ImageIcon icon = null;
        if (value instanceof TagCompletion) {
            TagCompletion tagCompletion = (TagCompletion)((Object)value);
            icon = tagCompletion.getIcon();
            if (tagCompletion.getType().equals(TAG_TYPE)) {
                Color color = tagCompletion.getColor();
                icon = new ImageIcon(ColorUtil.tint((BufferedImage)this.tagImage, (Color)color, (Color)Color.black));
            }
        }
        this.setIcon(icon);
        return this;
    }
}

