/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.dependencies;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ChannelDependenciesDialog;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.util.ChannelDependencyException;
import com.mirth.connect.util.ChannelDependencyGraph;
import com.mirth.connect.util.ChannelDependencyUtil;
import com.mirth.connect.util.DirectedAcyclicGraphNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class ChannelDependenciesPanel
extends JPanel {
    private ChannelDependenciesDialog parent;
    private Channel channel;
    private Set<ChannelDependency> dependencies;
    private Map<String, String> channelNameMap;
    private JLabel dependencyLabel;
    private MirthTreeTable dependencyTreeTable;
    private JScrollPane dependencyScrollPane;
    private JLabel dependencyExpandAllLabel;
    private JLabel dependencyCollapseAllLabel;
    private JButton dependencyAddButton;
    private JButton dependencyRemoveButton;
    private JLabel dependentLabel;
    private MirthTreeTable dependentTreeTable;
    private JScrollPane dependentScrollPane;
    private JLabel dependentExpandAllLabel;
    private JLabel dependentCollapseAllLabel;
    private JButton dependentAddButton;
    private JButton dependentRemoveButton;

    public ChannelDependenciesPanel(ChannelDependenciesDialog parent, Channel channel) {
        this.parent = parent;
        this.channel = channel;
        this.initComponents();
        this.initLayout();
        this.updateAddButton();
        this.channelNameMap = new HashMap<String, String>(PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelIdsAndNames());
        this.channelNameMap.put(channel.getId(), channel.getName());
        PlatformUI.MIRTH_FRAME.channelPanel.retrieveDependencies();
        this.dependencies = new HashSet<ChannelDependency>(PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelDependencies());
        this.updateTreeTable(true, this.dependencies);
        this.updateTreeTable(false, this.dependencies);
    }

    public boolean saveChanges() {
        if (!PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelDependencies().equals(this.dependencies)) {
            if (!PlatformUI.MIRTH_FRAME.alertOption(this, "You've made changes to deploy/start dependencies, which will be saved now. Are you sure you wish to continue?")) {
                return false;
            }
            try {
                PlatformUI.MIRTH_FRAME.mirthClient.setChannelDependencies(this.dependencies);
            }
            catch (ClientException e) {
                PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
                return false;
            }
        }
        return true;
    }

    private void updateTreeTable(boolean dependency, Set<ChannelDependency> dependencies) {
        try {
            ChannelDependencyGraph dependencyGraph = ChannelDependencyUtil.getDependencyGraph(dependencies);
            DefaultTreeTableModel model = (DefaultTreeTableModel)(dependency ? this.dependencyTreeTable.getTreeTableModel() : this.dependentTreeTable.getTreeTableModel());
            DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode();
            model.setRoot((TreeTableNode)root);
            DirectedAcyclicGraphNode node = dependencyGraph.getNode((Object)this.channel.getId());
            if (node != null) {
                if (dependency) {
                    ArrayList dependencyNodes = new ArrayList(node.getDirectDependencyNodes());
                    Collections.sort(dependencyNodes, new NodeComparator());
                    for (DirectedAcyclicGraphNode dependencyNode : dependencyNodes) {
                        this.addDependencyNode((MutableTreeTableNode)root, (DirectedAcyclicGraphNode<String>)dependencyNode);
                    }
                } else {
                    ArrayList dependentNodes = new ArrayList(node.getDirectDependentNodes());
                    Collections.sort(dependentNodes, new NodeComparator());
                    for (DirectedAcyclicGraphNode dependentNode : dependentNodes) {
                        this.addDependentNode((MutableTreeTableNode)root, (DirectedAcyclicGraphNode<String>)dependentNode);
                    }
                }
            }
        }
        catch (ChannelDependencyException channelDependencyException) {
            // empty catch block
        }
    }

    private void addDependencyNode(MutableTreeTableNode parent, DirectedAcyclicGraphNode<String> node) {
        String channelId = (String)node.getElement();
        String channelName = this.channelNameMap.get(channelId);
        if (StringUtils.isNotBlank((CharSequence)channelName)) {
            DefaultMutableTreeTableNode newTreeTableNode = new DefaultMutableTreeTableNode((Object)new ImmutablePair((Object)channelId, (Object)channelName));
            SortableTreeTableModel model = (SortableTreeTableModel)this.dependencyTreeTable.getTreeTableModel();
            model.insertNodeInto((MutableTreeTableNode)newTreeTableNode, parent);
            ArrayList dependencyNodes = new ArrayList(node.getDirectDependencyNodes());
            Collections.sort(dependencyNodes, new NodeComparator());
            for (DirectedAcyclicGraphNode dependencyNode : dependencyNodes) {
                this.addDependencyNode((MutableTreeTableNode)newTreeTableNode, (DirectedAcyclicGraphNode<String>)dependencyNode);
            }
        }
    }

    private void addDependentNode(MutableTreeTableNode parent, DirectedAcyclicGraphNode<String> node) {
        String channelId = (String)node.getElement();
        String channelName = this.channelNameMap.get(channelId);
        if (StringUtils.isNotBlank((CharSequence)channelName)) {
            DefaultMutableTreeTableNode newTreeTableNode = new DefaultMutableTreeTableNode((Object)new ImmutablePair((Object)channelId, (Object)channelName));
            SortableTreeTableModel model = (SortableTreeTableModel)this.dependentTreeTable.getTreeTableModel();
            model.insertNodeInto((MutableTreeTableNode)newTreeTableNode, parent);
            ArrayList dependentNodes = new ArrayList(node.getDirectDependentNodes());
            Collections.sort(dependentNodes, new NodeComparator());
            for (DirectedAcyclicGraphNode dependentNode : dependentNodes) {
                this.addDependentNode((MutableTreeTableNode)newTreeTableNode, (DirectedAcyclicGraphNode<String>)dependentNode);
            }
        }
    }

    private Map<String, String> getAllowedChannels(boolean dependency) {
        HashMap<String, String> allowedChannelsMap = new HashMap<String, String>();
        try {
            ChannelDependencyGraph dependencyGraph = ChannelDependencyUtil.getDependencyGraph(this.dependencies);
            DirectedAcyclicGraphNode node = dependencyGraph.getNode((Object)this.channel.getId());
            Map<String, String> channelIdsAndNames = PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelIdsAndNames();
            for (Map.Entry<String, String> entry : channelIdsAndNames.entrySet()) {
                String channelId = entry.getKey();
                String channelName = entry.getValue();
                if (StringUtils.equals((CharSequence)channelId, (CharSequence)this.channel.getId())) continue;
                boolean allowed = false;
                if (node != null) {
                    if (dependency) {
                        if (node.findDependentNode((Object)channelId) == null && !node.getDirectDependencyElements().contains(channelId)) {
                            allowed = true;
                        }
                    } else if (node.findDependencyNode((Object)channelId) == null && !node.getDirectDependentElements().contains(channelId)) {
                        allowed = true;
                    }
                } else {
                    allowed = true;
                }
                if (!allowed) continue;
                allowedChannelsMap.put(channelId, channelName);
            }
        }
        catch (ChannelDependencyException channelDependencyException) {
            // empty catch block
        }
        return allowedChannelsMap;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.dependencyLabel = new JLabel("This channel depends upon:");
        this.dependencyTreeTable = new MirthTreeTable();
        SortableTreeTableModel dependencyModel = new SortableTreeTableModel();
        DefaultMutableTreeTableNode dependencyRootNode = new DefaultMutableTreeTableNode();
        dependencyModel.setRoot((TreeTableNode)dependencyRootNode);
        this.dependencyTreeTable.setTreeTableModel((TreeTableModel)dependencyModel);
        this.dependencyTreeTable.setRootVisible(false);
        this.dependencyTreeTable.setDoubleBuffered(true);
        this.dependencyTreeTable.setDragEnabled(false);
        this.dependencyTreeTable.setRowSelectionAllowed(true);
        this.dependencyTreeTable.setSelectionMode(0);
        this.dependencyTreeTable.setRowHeight(20);
        this.dependencyTreeTable.setFocusable(true);
        this.dependencyTreeTable.setOpaque(true);
        this.dependencyTreeTable.setEditable(false);
        this.dependencyTreeTable.setSortable(true);
        this.dependencyTreeTable.putClientProperty("JTree.lineStyle", "Horizontal");
        this.dependencyTreeTable.setAutoCreateColumnsFromModel(false);
        this.dependencyTreeTable.setShowGrid(true, true);
        this.dependencyTreeTable.setTableHeader(null);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.dependencyTreeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.dependencyTreeTable.setTreeCellRenderer(new DependencyTreeCellRenderer(this.dependencyTreeTable));
        this.dependencyTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                if (ChannelDependenciesPanel.this.dependencyTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY())) < 0) {
                    ChannelDependenciesPanel.this.dependencyTreeTable.clearSelection();
                }
            }
        });
        this.dependencyTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    TreePath selectedPath;
                    boolean removeEnabled = false;
                    int[] rows = ChannelDependenciesPanel.this.dependencyTreeTable.getSelectedModelRows();
                    if (rows.length == 1 && (selectedPath = ChannelDependenciesPanel.this.dependencyTreeTable.getPathForRow(rows[0])) != null && selectedPath.getPathCount() == 2) {
                        removeEnabled = true;
                    }
                    ChannelDependenciesPanel.this.dependencyRemoveButton.setEnabled(removeEnabled);
                }
            }
        });
        this.dependencyScrollPane = new JScrollPane((Component)((Object)this.dependencyTreeTable));
        this.dependencyExpandAllLabel = new JLabel("<html><u>Expand All</u></html>");
        this.dependencyExpandAllLabel.setForeground(Color.BLUE);
        this.dependencyExpandAllLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.dependencyExpandAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelDependenciesPanel.this.dependencyTreeTable.expandAll();
            }
        });
        this.dependencyCollapseAllLabel = new JLabel("<html><u>Collapse All</u></html>");
        this.dependencyCollapseAllLabel.setForeground(Color.BLUE);
        this.dependencyCollapseAllLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.dependencyCollapseAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelDependenciesPanel.this.dependencyTreeTable.collapseAll();
            }
        });
        this.dependencyAddButton = new JButton("Add");
        this.dependencyAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDialog dialog;
                Map<String, String> allowedChannelsMap = ChannelDependenciesPanel.this.getAllowedChannels(true);
                if (MapUtils.isNotEmpty(allowedChannelsMap) && (dialog = new AddDialog(allowedChannelsMap, true)).wasSaved()) {
                    for (String dependencyId : dialog.getSelectedChannelIds()) {
                        ChannelDependenciesPanel.this.dependencies.add(new ChannelDependency(ChannelDependenciesPanel.this.channel.getId(), dependencyId));
                    }
                    ChannelDependenciesPanel.this.updateTreeTable(true, ChannelDependenciesPanel.this.dependencies);
                    ChannelDependenciesPanel.this.updateAddButton();
                }
            }
        });
        this.dependencyRemoveButton = new JButton("Remove");
        this.dependencyRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath selectedPath;
                int[] rows = ChannelDependenciesPanel.this.dependencyTreeTable.getSelectedModelRows();
                if (rows.length == 1 && (selectedPath = ChannelDependenciesPanel.this.dependencyTreeTable.getPathForRow(rows[0])) != null && selectedPath.getPathCount() == 2) {
                    Pair pair = (Pair)((MutableTreeTableNode)selectedPath.getLastPathComponent()).getUserObject();
                    Iterator<ChannelDependency> it = ChannelDependenciesPanel.this.dependencies.iterator();
                    while (it.hasNext()) {
                        ChannelDependency dependency = it.next();
                        if (!StringUtils.equals((CharSequence)ChannelDependenciesPanel.this.channel.getId(), (CharSequence)dependency.getDependentId()) || !StringUtils.equals((CharSequence)((CharSequence)pair.getLeft()), (CharSequence)dependency.getDependencyId())) continue;
                        it.remove();
                    }
                    ChannelDependenciesPanel.this.updateTreeTable(true, ChannelDependenciesPanel.this.dependencies);
                    ChannelDependenciesPanel.this.updateAddButton();
                }
            }
        });
        this.dependencyRemoveButton.setEnabled(false);
        this.dependentLabel = new JLabel("This channel is depended upon by:");
        this.dependentTreeTable = new MirthTreeTable();
        SortableTreeTableModel dependentModel = new SortableTreeTableModel();
        DefaultMutableTreeTableNode dependentRootNode = new DefaultMutableTreeTableNode();
        dependentModel.setRoot((TreeTableNode)dependentRootNode);
        this.dependentTreeTable.setTreeTableModel((TreeTableModel)dependentModel);
        this.dependentTreeTable.setRootVisible(false);
        this.dependentTreeTable.setDoubleBuffered(true);
        this.dependentTreeTable.setDragEnabled(false);
        this.dependentTreeTable.setRowSelectionAllowed(true);
        this.dependentTreeTable.setSelectionMode(0);
        this.dependentTreeTable.setRowHeight(20);
        this.dependentTreeTable.setFocusable(true);
        this.dependentTreeTable.setOpaque(true);
        this.dependentTreeTable.setEditable(false);
        this.dependentTreeTable.setSortable(true);
        this.dependentTreeTable.putClientProperty("JTree.lineStyle", "Horizontal");
        this.dependentTreeTable.setAutoCreateColumnsFromModel(false);
        this.dependentTreeTable.setShowGrid(true, true);
        this.dependentTreeTable.setTableHeader(null);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.dependentTreeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.dependentTreeTable.setTreeCellRenderer(new DependencyTreeCellRenderer(this.dependentTreeTable));
        this.dependentTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                if (ChannelDependenciesPanel.this.dependentTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY())) < 0) {
                    ChannelDependenciesPanel.this.dependentTreeTable.clearSelection();
                }
            }
        });
        this.dependentTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    TreePath selectedPath;
                    boolean removeEnabled = false;
                    int[] rows = ChannelDependenciesPanel.this.dependentTreeTable.getSelectedModelRows();
                    if (rows.length == 1 && (selectedPath = ChannelDependenciesPanel.this.dependentTreeTable.getPathForRow(rows[0])) != null && selectedPath.getPathCount() == 2) {
                        removeEnabled = true;
                    }
                    ChannelDependenciesPanel.this.dependentRemoveButton.setEnabled(removeEnabled);
                }
            }
        });
        this.dependentScrollPane = new JScrollPane((Component)((Object)this.dependentTreeTable));
        this.dependentExpandAllLabel = new JLabel("<html><u>Expand All</u></html>");
        this.dependentExpandAllLabel.setForeground(Color.BLUE);
        this.dependentExpandAllLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.dependentExpandAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelDependenciesPanel.this.dependentTreeTable.expandAll();
            }
        });
        this.dependentCollapseAllLabel = new JLabel("<html><u>Collapse All</u></html>");
        this.dependentCollapseAllLabel.setForeground(Color.BLUE);
        this.dependentCollapseAllLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.dependentCollapseAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelDependenciesPanel.this.dependentTreeTable.collapseAll();
            }
        });
        this.dependentAddButton = new JButton("Add");
        this.dependentAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDialog dialog;
                Map<String, String> allowedChannelsMap = ChannelDependenciesPanel.this.getAllowedChannels(false);
                if (MapUtils.isNotEmpty(allowedChannelsMap) && (dialog = new AddDialog(allowedChannelsMap, false)).wasSaved()) {
                    for (String dependentId : dialog.getSelectedChannelIds()) {
                        ChannelDependenciesPanel.this.dependencies.add(new ChannelDependency(dependentId, ChannelDependenciesPanel.this.channel.getId()));
                    }
                    ChannelDependenciesPanel.this.updateTreeTable(false, ChannelDependenciesPanel.this.dependencies);
                    ChannelDependenciesPanel.this.updateAddButton();
                }
            }
        });
        this.dependentRemoveButton = new JButton("Remove");
        this.dependentRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath selectedPath;
                int[] rows = ChannelDependenciesPanel.this.dependentTreeTable.getSelectedModelRows();
                if (rows.length == 1 && (selectedPath = ChannelDependenciesPanel.this.dependentTreeTable.getPathForRow(rows[0])) != null && selectedPath.getPathCount() == 2) {
                    Pair pair = (Pair)((MutableTreeTableNode)selectedPath.getLastPathComponent()).getUserObject();
                    Iterator<ChannelDependency> it = ChannelDependenciesPanel.this.dependencies.iterator();
                    while (it.hasNext()) {
                        ChannelDependency dependency = it.next();
                        if (!StringUtils.equals((CharSequence)((CharSequence)pair.getLeft()), (CharSequence)dependency.getDependentId()) || !StringUtils.equals((CharSequence)ChannelDependenciesPanel.this.channel.getId(), (CharSequence)dependency.getDependencyId())) continue;
                        it.remove();
                    }
                    ChannelDependenciesPanel.this.updateTreeTable(false, ChannelDependenciesPanel.this.dependencies);
                    ChannelDependenciesPanel.this.updateAddButton();
                }
            }
        });
        this.dependentRemoveButton.setEnabled(false);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.add(this.dependencyLabel);
        this.add((Component)this.dependencyExpandAllLabel, "right, split 3");
        this.add(new JLabel("|"));
        this.add(this.dependencyCollapseAllLabel);
        this.add((Component)this.dependencyScrollPane, "newline, grow, push, span 2");
        this.add((Component)this.dependencyAddButton, "top, flowy, split 2, w 60!");
        this.add((Component)this.dependencyRemoveButton, "w 60!");
        this.add((Component)this.dependentLabel, "newline");
        this.add((Component)this.dependentExpandAllLabel, "right, split 3");
        this.add(new JLabel("|"));
        this.add(this.dependentCollapseAllLabel);
        this.add((Component)this.dependentScrollPane, "newline, grow, push, span 2");
        this.add((Component)this.dependentAddButton, "top, flowy, split 2, w 60!");
        this.add((Component)this.dependentRemoveButton, "w 60!");
    }

    private void updateAddButton() {
        this.dependencyAddButton.setEnabled(MapUtils.isNotEmpty(this.getAllowedChannels(true)));
        this.dependentAddButton.setEnabled(MapUtils.isNotEmpty(this.getAllowedChannels(false)));
    }

    private class NodeComparator
    implements Comparator<DirectedAcyclicGraphNode<String>> {
        private NodeComparator() {
        }

        @Override
        public int compare(DirectedAcyclicGraphNode<String> o1, DirectedAcyclicGraphNode<String> o2) {
            String name1 = ChannelDependenciesPanel.this.channelNameMap.get(o1.getElement());
            String name2 = ChannelDependenciesPanel.this.channelNameMap.get(o2.getElement());
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareToIgnoreCase(name2);
        }
    }

    private class DependencyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private MirthTreeTable treeTable;

        public DependencyTreeCellRenderer(MirthTreeTable treeTable) {
            this.treeTable = treeTable;
            this.setIcon(UIConstants.ICON_CHANNEL);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.setBackground(this.treeTable.getSelectionBackground());
            } else {
                this.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            if (value != null) {
                MutableTreeTableNode node = (MutableTreeTableNode)value;
                if (node.getUserObject() != null) {
                    Pair pair = (Pair)node.getUserObject();
                    this.setText((String)pair.getRight());
                }
                this.setEnabled(node.getParent() == this.treeTable.getTreeTableModel().getRoot());
            }
            return this;
        }
    }

    private class AddDialog
    extends MirthDialog {
        private boolean saved;
        private JLabel label;
        private JLabel selectAllLabel;
        private JLabel deselectAllLabel;
        private MirthTable table;
        private JScrollPane scrollPane;
        private JSeparator separator;
        private JButton okButton;
        private JButton cancelButton;

        public boolean wasSaved() {
            return this.saved;
        }

        public AddDialog(Map<String, String> allowedChannelMap, boolean dependency) {
            super((Window)ChannelDependenciesPanel.this.parent, true);
            this.saved = false;
            this.initComponents(allowedChannelMap, dependency);
            this.initLayout();
            this.setPreferredSize(new Dimension(365, 230));
            this.setDefaultCloseOperation(2);
            this.setTitle("Add " + (dependency ? "Dependency" : "Dependent"));
            this.pack();
            this.setLocationRelativeTo(ChannelDependenciesPanel.this.parent);
            this.setVisible(true);
        }

        public Set<String> getSelectedChannelIds() {
            HashSet<String> selectedChannelIds = new HashSet<String>();
            for (int row = 0; row < this.table.getModel().getRowCount(); ++row) {
                if (!((Boolean)this.table.getModel().getValueAt(row, 0)).booleanValue()) continue;
                selectedChannelIds.add((String)this.table.getModel().getValueAt(row, 2));
            }
            return selectedChannelIds;
        }

        private void initComponents(Map<String, String> allowedChannelMap, final boolean dependency) {
            this.setBackground(UIConstants.BACKGROUND_COLOR);
            this.getContentPane().setBackground(this.getBackground());
            this.label = new JLabel("Select the " + (dependency ? "dependency" : "dependent") + " channel(s) to add.");
            this.selectAllLabel = new JLabel("<html><u>Select All</u></html>");
            this.selectAllLabel.setForeground(Color.BLUE);
            this.selectAllLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.selectAllLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    for (int row = 0; row < AddDialog.this.table.getModel().getRowCount(); ++row) {
                        AddDialog.this.table.getModel().setValueAt(true, row, 0);
                    }
                }
            });
            this.deselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
            this.deselectAllLabel.setForeground(Color.BLUE);
            this.deselectAllLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.deselectAllLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    for (int row = 0; row < AddDialog.this.table.getModel().getRowCount(); ++row) {
                        AddDialog.this.table.getModel().setValueAt(false, row, 0);
                    }
                }
            });
            Object[][] data = new Object[allowedChannelMap.size()][3];
            int i = 0;
            for (Map.Entry<String, String> entry : allowedChannelMap.entrySet()) {
                data[i][0] = false;
                data[i][1] = entry.getValue();
                data[i][2] = entry.getKey();
                ++i;
            }
            this.table = new MirthTable();
            this.table.setModel(new RefreshTableModel(data, new Object[]{"", "Name", "Id"}){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }
            });
            this.table.setDragEnabled(false);
            this.table.setRowSelectionAllowed(false);
            this.table.setRowHeight(20);
            this.table.setFocusable(false);
            this.table.setOpaque(true);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setEditable(true);
            this.table.setSortable(true);
            if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
                this.table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
            }
            this.table.getColumnModel().getColumn(0).setMinWidth(20);
            this.table.getColumnModel().getColumn(0).setMaxWidth(20);
            this.table.getColumnExt(2).setVisible(false);
            this.scrollPane = new JScrollPane((Component)((Object)this.table));
            this.separator = new JSeparator(0);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (CollectionUtils.isEmpty(AddDialog.this.getSelectedChannelIds())) {
                        PlatformUI.MIRTH_FRAME.alertError(AddDialog.this, "You must select at least one " + (dependency ? "dependency" : "dependent") + " channel.");
                        return;
                    }
                    AddDialog.this.saved = true;
                    AddDialog.this.dispose();
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddDialog.this.dispose();
                }
            });
        }

        private void initLayout() {
            this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill"));
            this.add(this.label);
            this.add((Component)this.selectAllLabel, "right, split 3");
            this.add(new JLabel("|"));
            this.add(this.deselectAllLabel);
            this.add((Component)this.scrollPane, "newline, grow, push, sx");
            this.add((Component)this.separator, "newline, growx, sx");
            this.add((Component)this.okButton, "newline, sx, split 2, right, w 50!");
            this.add((Component)this.cancelButton, "w 50!");
        }
    }
}

