/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.dependencies;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.util.ChannelDependencyException;
import com.mirth.connect.util.ChannelDependencyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.text.WordUtils;

public class ChannelDependenciesWarningDialog
extends MirthDialog {
    private int result = -1;
    private JLabel descriptionLabel;
    private JTextPane channelsPane;
    private JScrollPane descriptionScrollPane;
    private JCheckBox includeCheckBox;
    private JButton okButton;
    private JButton cancelButton;

    public ChannelDependenciesWarningDialog(Frame.ChannelTask task, Set<ChannelDependency> dependencies, Set<String> selectedChannelIds, Set<String> additionalChannelIds) throws ChannelDependencyException {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.initComponents(task, dependencies, selectedChannelIds, additionalChannelIds);
        this.initLayout();
        this.setPreferredSize(new Dimension(344, 207));
        this.setDefaultCloseOperation(2);
        this.setTitle("Select An Option");
        this.pack();
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.includeCheckBox.requestFocus();
        this.setVisible(true);
    }

    public int getResult() {
        return this.result;
    }

    public boolean isIncludeOtherChannels() {
        return this.includeCheckBox.isSelected();
    }

    private void initComponents(final Frame.ChannelTask task, Set<ChannelDependency> dependencies, final Set<String> selectedChannelIds, Set<String> additionalChannelIds) throws ChannelDependencyException {
        additionalChannelIds.removeAll(selectedChannelIds);
        final ChannelDependencyUtil.OrderedChannels orderedChannels = ChannelDependencyUtil.getOrderedChannels(dependencies, new HashSet(CollectionUtils.union(selectedChannelIds, additionalChannelIds)));
        final List orderedChannelIds = orderedChannels.getOrderedIds();
        if (task.isForwardOrder()) {
            Collections.reverse(orderedChannelIds);
        }
        this.descriptionLabel = new JLabel("<html>There are additional channels in the dependency chain.<br/><b>Bolded</b> channels will be " + task.getFuturePassive() + " in the following order:</html>");
        this.channelsPane = new JTextPane();
        this.channelsPane.setContentType("text/html");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        StyleSheet styleSheet = editorKit.getStyleSheet();
        styleSheet.addRule("div {font-family:\"Tahoma\";font-size:11;text-align:top}");
        this.channelsPane.setEditorKit(editorKit);
        this.channelsPane.setEditable(false);
        this.channelsPane.setBackground(this.getBackground());
        this.setTextPane(task, orderedChannels, orderedChannelIds, selectedChannelIds, false);
        this.descriptionScrollPane = new JScrollPane(this.channelsPane);
        this.includeCheckBox = new JCheckBox(WordUtils.capitalize((String)task.toString()) + " " + additionalChannelIds.size() + " additional channel" + (additionalChannelIds.size() == 1 ? "" : "s"));
        this.includeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelDependenciesWarningDialog.this.setTextPane(task, orderedChannels, orderedChannelIds, selectedChannelIds, ChannelDependenciesWarningDialog.this.includeCheckBox.isSelected());
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelDependenciesWarningDialog.this.result = 0;
                ChannelDependenciesWarningDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelDependenciesWarningDialog.this.result = 2;
                ChannelDependenciesWarningDialog.this.dispose();
            }
        });
    }

    private void setTextPane(Frame.ChannelTask task, ChannelDependencyUtil.OrderedChannels orderedChannels, List<Set<String>> orderedChannelIds, Set<String> selectedChannelIds, boolean boldAdditional) {
        HashMap<String, DashboardStatus> statusMap = null;
        if (task != Frame.ChannelTask.DEPLOY) {
            statusMap = new HashMap<String, DashboardStatus>();
            if (PlatformUI.MIRTH_FRAME.status != null) {
                for (DashboardStatus dashboardStatus : PlatformUI.MIRTH_FRAME.status) {
                    statusMap.put(dashboardStatus.getChannelId(), dashboardStatus);
                }
            }
        }
        StringBuilder builder = new StringBuilder("<html><div>");
        if (CollectionUtils.isNotEmpty((Collection)orderedChannels.getUnorderedIds())) {
            builder.append("&nbsp;Independent:&nbsp;");
            Iterator it = orderedChannels.getUnorderedIds().iterator();
            while (it.hasNext()) {
                String channelId = (String)it.next();
                String channelName = null;
                builder.append("<b>");
                if (task != Frame.ChannelTask.DEPLOY) {
                    DashboardStatus dashboardStatus = (DashboardStatus)statusMap.get(channelId);
                    if (dashboardStatus != null) {
                        channelName = dashboardStatus.getName();
                    }
                } else {
                    channelName = PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelIdsAndNames().get(channelId);
                }
                if (channelName != null) {
                    builder.append(channelName.replace(" ", "&nbsp;"));
                } else {
                    builder.append(channelId.replace(" ", "&nbsp;"));
                }
                builder.append("</b>");
                if (!it.hasNext()) continue;
                builder.append(",&nbsp;");
            }
            builder.append("<br/>");
        }
        for (int i = 0; i < orderedChannelIds.size(); ++i) {
            Set<String> set = orderedChannelIds.get(i);
            builder.append("&nbsp;").append(i + 1).append(".&nbsp;");
            Iterator<String> it = set.iterator();
            while (it.hasNext()) {
                String channelId = it.next();
                String channelName = null;
                if (boldAdditional || selectedChannelIds.contains(channelId)) {
                    builder.append("<b>");
                }
                if (task != Frame.ChannelTask.DEPLOY) {
                    DashboardStatus dashboardStatus = (DashboardStatus)statusMap.get(channelId);
                    if (dashboardStatus != null) {
                        channelName = dashboardStatus.getName();
                    }
                } else {
                    channelName = PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelIdsAndNames().get(channelId);
                }
                if (channelName != null) {
                    builder.append(channelName.replace(" ", "&nbsp;"));
                } else {
                    builder.append(channelId.replace(" ", "&nbsp;"));
                }
                if (boldAdditional || selectedChannelIds.contains(channelId)) {
                    builder.append("</b>");
                }
                if (!it.hasNext()) continue;
                builder.append(",&nbsp;");
            }
            if (i >= orderedChannelIds.size() - 1) continue;
            builder.append("<br/>");
        }
        builder.append("</div></html>");
        this.channelsPane.setText(builder.toString());
        this.channelsPane.setCaretPosition(0);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill"));
        this.add(this.descriptionLabel);
        this.add((Component)this.descriptionScrollPane, "newline, grow, push");
        this.add((Component)this.includeCheckBox, "newline");
        this.add((Component)this.okButton, "newline, center, gaptop 12, w 75!, split 2");
        this.add((Component)this.cancelButton, "w 75!");
    }
}

