/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.editors.FilterTransformerTreeTableNode;
import com.mirth.connect.client.ui.editors.IteratorPanel;
import com.mirth.connect.client.ui.editors.IteratorUtil;
import com.mirth.connect.client.ui.editors.IteratorWizardDialog;
import com.mirth.connect.client.ui.editors.TabbedTemplatePanel;
import com.mirth.connect.client.ui.util.VariableListUtil;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.FilterTransformer;
import com.mirth.connect.model.FilterTransformerElement;
import com.mirth.connect.model.IteratorElement;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.plugins.FilterTransformerTypePlugin;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.ScriptBuilderException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.action.ActionFactory;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public abstract class BaseEditorPane<T extends FilterTransformer<C>, C extends FilterTransformerElement>
extends JPanel
implements DropTargetListener {
    private static final int TASK_ADD = 0;
    private static final int TASK_DELETE = 1;
    private static final int TASK_ASSIGN_TO_ITERATOR = 2;
    private static final int TASK_REMOVE_FROM_ITERATOR = 3;
    private static final int TASK_IMPORT = 4;
    private static final int TASK_EXPORT = 5;
    private static final int TASK_VALIDATE = 6;
    private static final int TASK_VALIDATE_ELEMENT = 7;
    private static final int TASK_MOVE_UP = 8;
    private static final int TASK_MOVE_DOWN = 9;
    protected int numColumn;
    protected int nameColumn;
    protected int typeColumn;
    protected int enabledColumn;
    protected int columnCount = 4;
    private JXTaskPane viewTasks;
    private JXTaskPane editorTasks;
    private JPopupMenu editorPopupMenu;
    private Connector connector;
    private boolean response;
    protected T originalProperties;
    private AtomicBoolean updating = new AtomicBoolean(false);
    private DropTarget dropTarget;
    private Preferences userPreferences = Preferences.userNodeForPackage(Mirth.class);
    private ActionListener nameActionListener;
    private int previouslySelectedIndex = -1;
    private JSplitPane horizontalSplitPane;
    private JSplitPane verticalSplitPane;
    protected MirthTreeTable treeTable;
    private JScrollPane treeTableScrollPane;
    protected DefaultTreeTableModel treeTableModel;
    private JTabbedPane tabPane;
    private JPanel propertiesContainer;
    private JScrollPane propertiesScrollPane;
    private MirthRTextScrollPane generatedScriptTextArea;
    public TabbedTemplatePanel templatePanel;

    public BaseEditorPane() {
        this.initComponents();
        this.initLayout();
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
        this.updatePlugins();
    }

    protected abstract Class<?> getContainerClass();

    protected abstract String getContainerName();

    protected boolean allowNameEdit(int rowIndex, int columnIndex) {
        try {
            return this.getPlugins().get(this.treeTable.getValueAt(rowIndex, this.typeColumn)).isNameEditable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean allowEnableEdit(int rowIndex, int columnIndex) {
        TreePath path = this.treeTable.getPathForRow(rowIndex);
        FilterTransformerTreeTableNode traverseUp = path != null ? (FilterTransformerTreeTableNode)((Object)path.getLastPathComponent()) : null;
        traverseUp = traverseUp != null && !(traverseUp.getParent() instanceof DefaultMutableTreeTableNode) ? (FilterTransformerTreeTableNode)traverseUp.getParent() : null;
        boolean enabled = true;
        while (traverseUp != null && enabled) {
            enabled = traverseUp.getElement().isEnabled();
            traverseUp = traverseUp.getParent() instanceof DefaultMutableTreeTableNode ? null : (FilterTransformerTreeTableNode)traverseUp.getParent();
        }
        return enabled;
    }

    protected boolean allowOperatorEdit(int rowIndex, int columnIndex) {
        return false;
    }

    private boolean allowCellEdit(int rowIndex, int columnIndex) {
        if (columnIndex == this.nameColumn) {
            return this.allowNameEdit(rowIndex, columnIndex) || this.allowOperatorEdit(rowIndex, columnIndex);
        }
        if (columnIndex == this.enabledColumn) {
            return this.allowEnableEdit(rowIndex, columnIndex);
        }
        return columnIndex == this.typeColumn;
    }

    protected abstract void updateTable();

    protected abstract String getElementName();

    protected abstract boolean useOperatorColumn();

    protected abstract Object getOperator(C var1);

    protected abstract void setOperator(C var1, Object var2);

    protected abstract Map<String, FilterTransformerTypePlugin<T, C>> getPlugins();

    public void accept() {
        this.accept(true);
    }

    public void accept(boolean returning) {
        this.saveData();
        boolean saveEnabled = PlatformUI.MIRTH_FRAME.isSaveEnabled();
        T properties = this.getProperties();
        if (StringUtils.isNotBlank((CharSequence)this.validateAll())) {
            return;
        }
        this.doAccept(this.connector, properties, this.response);
        if (returning) {
            PlatformUI.MIRTH_FRAME.channelEditPanel.setDestinationVariableList();
            PlatformUI.MIRTH_FRAME.setCurrentContentPage(PlatformUI.MIRTH_FRAME.channelEditPanel);
            PlatformUI.MIRTH_FRAME.setFocus(PlatformUI.MIRTH_FRAME.channelEditTasks);
            PlatformUI.MIRTH_FRAME.setPanelName("Edit Channel - " + PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getName());
            if (this.isModified(properties)) {
                saveEnabled = true;
            }
            PlatformUI.MIRTH_FRAME.channelEditPanel.updateComponentShown();
            PlatformUI.MIRTH_FRAME.setSaveEnabled(saveEnabled);
        }
    }

    protected abstract void doAccept(Connector var1, T var2, boolean var3);

    public boolean isModified() {
        return this.isModified(this.getProperties());
    }

    protected boolean isModified(T properties) {
        return !Objects.equals(this.originalProperties, this.getProperties());
    }

    public abstract T getProperties();

    public void setProperties(Connector connector, T properties, boolean response) {
        this.setProperties(connector, properties, response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Connector connector, T properties, boolean response, boolean overwriteOriginal) {
        boolean saveEnabled = PlatformUI.MIRTH_FRAME.isSaveEnabled();
        PlatformUI.MIRTH_FRAME.setCurrentContentPage(this);
        this.setConnector(connector);
        this.response = response;
        properties = properties.clone();
        if (overwriteOriginal) {
            this.originalProperties = properties.clone();
        }
        this.updating.set(true);
        try {
            this.propertiesScrollPane.setViewportView(null);
            this.propertiesContainer.removeAll();
            this.tabPane.updateUI();
            this.previouslySelectedIndex = -1;
            if (connector.getMode() == Connector.Mode.SOURCE) {
                this.templatePanel.setSourceView();
            } else if (connector.getMode() == Connector.Mode.DESTINATION) {
                this.templatePanel.setDestinationView(response);
            }
            this.templatePanel.setDefaultComponent();
            this.doSetProperties(connector, properties, response, overwriteOriginal);
            PlatformUI.MIRTH_FRAME.setFocus(new JXTaskPane[]{this.viewTasks, this.editorTasks}, false, true);
            PlatformUI.MIRTH_FRAME.setSaveEnabled(saveEnabled);
            this.treeTable.expandAll();
            if (this.treeTable.getRowCount() > 0) {
                this.treeTable.setRowSelectionInterval(0, 0);
                this.loadData(0);
            }
            this.updateTemplateVariables();
            this.updateTaskPane();
            this.updateSequenceNumbers();
            this.updateTable();
            this.updateGeneratedCode();
        }
        finally {
            this.updating.set(false);
        }
        if (this.treeTable.getRowCount() > 0) {
            SwingUtilities.invokeLater(() -> this.treeTable.setRowSelectionInterval(0, 0));
        }
    }

    protected abstract void doSetProperties(Connector var1, T var2, boolean var3, boolean var4);

    public List<C> getElements() {
        ArrayList elements = new ArrayList();
        Enumeration en = this.treeTableModel.getRoot().children();
        while (en.hasMoreElements()) {
            elements.add(((FilterTransformerTreeTableNode)((Object)en.nextElement())).getElementWithChildren());
        }
        return elements;
    }

    public void setElements(List<C> elements) {
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode();
        int sequenceNumber = 0;
        for (FilterTransformerElement element : elements) {
            element.setSequenceNumber(String.valueOf(sequenceNumber++));
            root.add(this.createTreeTableNode(element));
        }
        this.treeTableModel.setRoot((TreeTableNode)root);
        this.treeTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot(this.treeTableModel.getRoot())));
    }

    protected abstract FilterTransformerTreeTableNode<T, C> createTreeTableNode(C var1);

    public String getInboundTemplate() {
        return this.templatePanel.getIncomingMessage();
    }

    public void setInboundTemplate(String inboundTemplate) {
        this.templatePanel.setIncomingMessage(inboundTemplate);
    }

    public String getOutboundTemplate() {
        return this.templatePanel.getOutgoingMessage();
    }

    public void setOutboundTemplate(String outboundTemplate) {
        this.templatePanel.setOutgoingMessage(outboundTemplate);
    }

    public String getInboundDataType() {
        return PlatformUI.MIRTH_FRAME.displayNameToDataType.get(this.templatePanel.getIncomingDataType());
    }

    public void setInboundDataType(String inboundDataType) {
        this.templatePanel.setIncomingDataType(PlatformUI.MIRTH_FRAME.dataTypeToDisplayName.get(inboundDataType));
    }

    public String getOutboundDataType() {
        return PlatformUI.MIRTH_FRAME.displayNameToDataType.get(this.templatePanel.getOutgoingDataType());
    }

    public void setOutboundDataType(String outboundDataType) {
        this.templatePanel.setOutgoingDataType(PlatformUI.MIRTH_FRAME.dataTypeToDisplayName.get(outboundDataType));
    }

    public DataTypeProperties getInboundDataTypeProperties() {
        return this.templatePanel.getIncomingDataProperties();
    }

    public void setInboundDataTypeProperties(DataTypeProperties properties) {
        this.templatePanel.setIncomingDataProperties(properties);
    }

    public DataTypeProperties getOutboundDataTypeProperties() {
        return this.templatePanel.getOutgoingDataProperties();
    }

    public void setOutboundDataTypeProperties(DataTypeProperties properties) {
        this.templatePanel.setOutgoingDataProperties(properties);
    }

    public void doAddNewElement() {
        this.addNewElement();
    }

    public abstract void addNewElement();

    public void addNewElement(String name, String variable, String mapping, String type) {
        this.addNewElement(name, variable, mapping, type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewElement(String name, String variable, String mapping, String type, boolean showIteratorWizard) {
        this.updating.set(true);
        try {
            TreePath path;
            int selectedRow = this.treeTable.getSelectedRow();
            this.saveData(selectedRow);
            FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(type);
            if (plugin == null) {
                PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Could not find plugin of type: " + type);
                return;
            }
            Object parent = (MutableTreeTableNode)this.treeTableModel.getRoot();
            if (this.isValidViewRow(selectedRow) && (path = this.treeTable.getPathForRow(selectedRow)) != null && !((FilterTransformerTreeTableNode)((Object)(parent = (MutableTreeTableNode)path.getLastPathComponent()))).isIteratorNode()) {
                parent = (MutableTreeTableNode)parent.getParent();
            }
            if (parent instanceof FilterTransformerTreeTableNode) {
                variable = IteratorUtil.replaceIteratorVariables(JavaScriptSharedUtil.removeNumberLiterals((String)variable), (TreeTableNode)parent);
                mapping = IteratorUtil.replaceIteratorVariables(JavaScriptSharedUtil.removeNumberLiterals((String)mapping), (TreeTableNode)parent);
            }
            Pair<String, String> info = plugin.getIteratorInfo(variable, mapping);
            String target = (String)info.getLeft();
            String outbound = (String)info.getRight();
            if (showIteratorWizard && !JavaScriptSharedUtil.getExpressionParts((String)target, (boolean)false).isEmpty() && this.userPreferences.getBoolean("filterTransformerShowIteratorDialog", true)) {
                String text = "Would you like to create a new or choose an existing Iterator for this " + this.getContainerName().toLowerCase() + " " + this.getElementName().toLowerCase() + "?";
                JCheckBox checkBox = new JCheckBox("Do not show this dialog again (may be re-enabled in the Administrator settings)");
                Object[] params = new Object[]{text, checkBox};
                int result = JOptionPane.showConfirmDialog((Component)((Object)PlatformUI.MIRTH_FRAME), params, "Select An Option", 1, 3);
                if (checkBox.isSelected()) {
                    this.userPreferences.putBoolean("filterTransformerShowIteratorDialog", false);
                }
                if (result == 0) {
                    IteratorWizardDialog dialog = new IteratorWizardDialog(target, null, (TreeTableNode)parent, this.treeTableModel, outbound);
                    if (!dialog.wasAccepted()) {
                        return;
                    }
                    if (dialog.isCreateNew()) {
                        FilterTransformerTypePlugin<T, C> iteratorPlugin = this.getPlugins().get("Iterator");
                        IteratorElement iteratorElement = (IteratorElement)iteratorPlugin.getDefaults();
                        dialog.fillIteratorProperties(iteratorElement.getProperties());
                        ((IteratorPanel)iteratorPlugin.getPanel()).setName(iteratorElement);
                        variable = IteratorUtil.replaceIteratorVariables(JavaScriptSharedUtil.removeNumberLiterals((String)variable), iteratorElement);
                        mapping = IteratorUtil.replaceIteratorVariables(JavaScriptSharedUtil.removeNumberLiterals((String)mapping), iteratorElement);
                        parent = this.insertNode((MutableTreeTableNode)parent, (C)((FilterTransformerElement)iteratorElement));
                        this.replaceIteratorVariables((FilterTransformerTreeTableNode)((Object)parent));
                    } else {
                        parent = dialog.getSelectedParent();
                        variable = IteratorUtil.replaceIteratorVariables(JavaScriptSharedUtil.removeNumberLiterals((String)variable), (TreeTableNode)parent);
                        mapping = IteratorUtil.replaceIteratorVariables(JavaScriptSharedUtil.removeNumberLiterals((String)mapping), (TreeTableNode)parent);
                    }
                } else if (result != 1) {
                    return;
                }
            }
            C element = plugin.newObject(variable, mapping);
            element.setName(name);
            element.setEnabled(true);
            FilterTransformerTreeTableNode<T, C> node = this.insertNode((MutableTreeTableNode)parent, element);
            this.replaceIteratorVariables(node);
            TreePath path2 = new TreePath(this.treeTableModel.getPathToRoot(node));
            this.treeTable.expandPath(path2);
            this.treeTable.getTreeSelectionModel().setSelectionPath(path2);
            this.treeTable.scrollPathToVisible(path2);
            this.loadData(this.treeTable.getRowForPath(path2));
            this.updateTaskPane();
            this.updateTable();
            this.updateGeneratedCode();
            this.updateSequenceNumbers();
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
        }
        finally {
            this.updating.set(false);
        }
    }

    public String replaceIteratorVariables(String expression) {
        return IteratorUtil.replaceIteratorVariables(expression, this.treeTable);
    }

    private FilterTransformerTreeTableNode<T, C> insertNode(MutableTreeTableNode parent, C element) {
        return this.insertNode(parent, element, parent.getChildCount());
    }

    private FilterTransformerTreeTableNode<T, C> insertNode(MutableTreeTableNode parent, C element, int index) {
        FilterTransformerTreeTableNode<T, C> node = this.createTreeTableNode(element);
        this.treeTableModel.insertNodeInto(node, parent, index);
        return node;
    }

    public void doDeleteElement() {
        this.stopTableEditing();
        int selectedRow = this.treeTable.getSelectedRow();
        if (this.isValidViewRow(selectedRow)) {
            this.saveData(selectedRow);
            FilterTransformerTreeTableNode<T, C> node = this.getNodeAtRow(selectedRow);
            if (node.getChildCount() > 0 && !PlatformUI.MIRTH_FRAME.alertOkCancel((Component)((Object)PlatformUI.MIRTH_FRAME), "All child " + this.getElementName().toLowerCase() + "s will be removed along with the Iterator. Are you sure you wish to continue?")) {
                return;
            }
            this.updating.set(true);
            try {
                this.treeTableModel.removeNodeFromParent(node);
            }
            finally {
                this.updating.set(false);
            }
            if (this.isValidViewRow(selectedRow)) {
                this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
            } else if (this.isValidViewRow(selectedRow - 1)) {
                this.treeTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            } else {
                this.propertiesScrollPane.setViewportView(null);
                this.propertiesContainer.removeAll();
                this.updateTabPane();
            }
            this.updateTaskPane();
            this.updateGeneratedCode();
            this.updateTemplateVariables();
            this.updateSequenceNumbers();
            this.updateTable();
        }
    }

    private boolean hasIteratorNodes(MutableTreeTableNode node, FilterTransformerTreeTableNode<T, C> excluded) {
        if (!Objects.equals(node, excluded)) {
            if (node instanceof FilterTransformerTreeTableNode && ((FilterTransformerTreeTableNode)node).isIteratorNode()) {
                return true;
            }
            Enumeration en = node.children();
            while (en.hasMoreElements()) {
                if (!this.hasIteratorNodes((MutableTreeTableNode)en.nextElement(), excluded)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAssignToIterator() {
        this.updating.set(true);
        try {
            int selectedRow = this.treeTable.getSelectedRow();
            if (!this.isValidViewRow(selectedRow)) {
                return;
            }
            this.saveData(selectedRow);
            TreePath path = this.treeTable.getPathForRow(selectedRow);
            if (path == null) {
                return;
            }
            FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)((Object)path.getLastPathComponent());
            Object parent = (MutableTreeTableNode)node.getParent();
            int childIndex = parent.getIndex((TreeNode)((Object)node));
            String type = node.getElement().getType();
            FilterTransformerTypePlugin plugin = this.getPlugins().get(type);
            if (plugin == null) {
                PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Could not find plugin of type: " + type);
                return;
            }
            this.removeIteratorVariables(node);
            Pair<String, String> iteratorInfo = plugin.getIteratorInfo(node.getElement());
            String target = JavaScriptSharedUtil.removeNumberLiterals((String)((String)iteratorInfo.getLeft()));
            String outbound = JavaScriptSharedUtil.removeNumberLiterals((String)((String)iteratorInfo.getRight()));
            FilterTransformerTypePlugin<T, C> iteratorPlugin = this.getPlugins().get("Iterator");
            if (JavaScriptSharedUtil.getExpressionParts((String)target, (boolean)false).isEmpty() && !this.hasIteratorNodes((MutableTreeTableNode)this.treeTableModel.getRoot(), node)) {
                IteratorElement iteratorElement = (IteratorElement)iteratorPlugin.getDefaults();
                iteratorElement.getProperties().setIndexVariable(IteratorUtil.getValidIndexVariable((TreeTableNode)parent, (TreeTableNode)node));
                this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)node);
                parent = this.insertNode((MutableTreeTableNode)parent, (C)((FilterTransformerElement)iteratorElement), childIndex);
                iteratorElement = (IteratorElement)((FilterTransformerTreeTableNode)((Object)parent)).getElement();
                this.replaceIteratorVariables((FilterTransformerTreeTableNode)((Object)parent));
                ((IteratorPanel)iteratorPlugin.getPanel()).setName(iteratorElement);
            } else {
                IteratorWizardDialog dialog = new IteratorWizardDialog(target, node, (TreeTableNode)parent, this.treeTableModel, outbound);
                if (!dialog.wasAccepted()) {
                    return;
                }
                this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)node);
                if (dialog.isCreateNew()) {
                    IteratorElement iteratorElement = (IteratorElement)iteratorPlugin.getDefaults();
                    dialog.fillIteratorProperties(iteratorElement.getProperties());
                    parent = this.insertNode((MutableTreeTableNode)parent, (C)((FilterTransformerElement)iteratorElement), childIndex);
                    iteratorElement = (IteratorElement)((FilterTransformerTreeTableNode)((Object)parent)).getElement();
                    this.replaceIteratorVariables((FilterTransformerTreeTableNode)((Object)parent));
                    ((IteratorPanel)iteratorPlugin.getPanel()).setName(iteratorElement);
                } else {
                    target = IteratorUtil.removeIteratorVariables(target, (TreeTableNode)parent);
                    outbound = IteratorUtil.removeIteratorVariables(outbound, (TreeTableNode)parent);
                    parent = dialog.getSelectedParent();
                }
            }
            target = IteratorUtil.replaceIteratorVariables(target, (TreeTableNode)parent);
            outbound = IteratorUtil.replaceIteratorVariables(outbound, (TreeTableNode)parent);
            Object element = node.getElementWithChildren();
            plugin.setIteratorInfo(element, target, outbound);
            node = this.insertNode((MutableTreeTableNode)parent, element);
            this.replaceIteratorVariables(node);
            TreePath newPath = new TreePath(this.treeTableModel.getPathToRoot(node));
            this.treeTable.expandPath(newPath);
            this.treeTable.getTreeSelectionModel().setSelectionPath(newPath);
            this.treeTable.scrollPathToVisible(newPath);
            this.loadData(this.treeTable.getRowForPath(newPath));
            this.updateTaskPane();
            this.updateTable();
            this.updateGeneratedCode();
            this.updateSequenceNumbers();
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
        }
        finally {
            this.updating.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveFromIterator() {
        this.updating.set(true);
        try {
            int selectedRow = this.treeTable.getSelectedRow();
            if (!this.isValidViewRow(selectedRow)) {
                return;
            }
            this.saveData(selectedRow);
            TreePath path = this.treeTable.getPathForRow(selectedRow);
            if (path == null) {
                return;
            }
            FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)((Object)path.getLastPathComponent());
            MutableTreeTableNode parent = (MutableTreeTableNode)node.getParent();
            if (!(node.getParent() instanceof FilterTransformerTreeTableNode)) {
                return;
            }
            this.removeIteratorVariables(node);
            this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)node);
            node = this.insertNode((MutableTreeTableNode)parent.getParent(), node.getElementWithChildren());
            this.replaceIteratorVariables(node);
            TreePath newPath = new TreePath(this.treeTableModel.getPathToRoot(node));
            this.treeTable.expandPath(newPath);
            this.treeTable.getTreeSelectionModel().setSelectionPath(newPath);
            this.treeTable.scrollPathToVisible(newPath);
            this.loadData(this.treeTable.getRowForPath(newPath));
            this.updateTaskPane();
            this.updateTable();
            this.updateGeneratedCode();
            this.updateSequenceNumbers();
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
        }
        finally {
            this.updating.set(false);
        }
    }

    private void replaceIteratorVariables(FilterTransformerTreeTableNode<T, C> node) {
        if (node.getParent() instanceof FilterTransformerTreeTableNode) {
            FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(node.getElement().getType());
            if (plugin == null) {
                PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Could not find plugin of type: " + node.getElement().getType());
                return;
            }
            plugin.replaceIteratorVariables(node.getElement(), (FilterTransformerTreeTableNode)node.getParent());
        }
        Enumeration en = node.children();
        while (en.hasMoreElements()) {
            this.replaceIteratorVariables((FilterTransformerTreeTableNode)((Object)en.nextElement()));
        }
    }

    private void removeIteratorVariables(FilterTransformerTreeTableNode<T, C> node) {
        Enumeration en = node.children();
        while (en.hasMoreElements()) {
            this.removeIteratorVariables((FilterTransformerTreeTableNode)((Object)en.nextElement()));
        }
        if (node.getParent() instanceof FilterTransformerTreeTableNode) {
            FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(node.getElement().getType());
            if (plugin == null) {
                PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Could not find plugin of type: " + node.getElement().getType());
                return;
            }
            plugin.removeIteratorVariables(node.getElement(), (FilterTransformerTreeTableNode)node.getParent());
        }
    }

    public void doImport() {
        String content = PlatformUI.MIRTH_FRAME.browseForFileString("XML");
        if (content != null) {
            this.importFilterTransformer(content);
        }
    }

    private void importFilterTransformer(String content) {
        boolean append;
        String containerName = this.getContainerName().toLowerCase();
        String elementName = this.getElementName().toLowerCase();
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        FilterTransformer properties = null;
        try {
            properties = (FilterTransformer)serializer.deserialize(content, this.getContainerClass());
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertError(this, "Invalid " + containerName + " file.");
            return;
        }
        boolean bl = append = this.treeTableModel.getRoot().getChildCount() > 0 && PlatformUI.MIRTH_FRAME.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "Would you like to append the " + elementName + "s from the imported " + containerName + " into the existing " + containerName + "?");
        if (append) {
            T combinedProperties = this.getProperties();
            combinedProperties.getElements().addAll(properties.getElements());
            this.setProperties(this.connector, combinedProperties, this.response, false);
        } else {
            this.setProperties(this.connector, properties, this.response, false);
        }
    }

    public void doExport() {
        this.saveData();
        PlatformUI.MIRTH_FRAME.exportFile(ObjectXMLSerializer.getInstance().serialize(this.getProperties()), null, "XML", this.getContainerName());
    }

    public void doValidate() {
        this.saveData();
        if (StringUtils.isBlank((CharSequence)this.validateAll())) {
            PlatformUI.MIRTH_FRAME.alertInformation(this, "Validation successful.");
        }
    }

    private String validateAll() {
        int selectedRow = this.treeTable.getSelectedRow();
        String selectedSequenceNumber = null;
        if (this.isValidViewRow(selectedRow)) {
            this.saveData(selectedRow);
            selectedSequenceNumber = ((FilterTransformerTreeTableNode)((Object)this.treeTable.getPathForRow(selectedRow).getLastPathComponent())).getElement().getSequenceNumber();
        }
        String containerName = this.getContainerName().toLowerCase();
        String elementName = this.getElementName().toLowerCase();
        T properties = this.getProperties();
        StringBuilder builder = new StringBuilder();
        for (FilterTransformerElement element : properties.getElements()) {
            this.validateElementRecursive(element, builder, selectedSequenceNumber);
        }
        String errors = builder.toString();
        if (StringUtils.isBlank((CharSequence)errors)) {
            try {
                StringBuilder script = new StringBuilder();
                for (FilterTransformerElement element : properties.getElements()) {
                    script.append(element.getScript(false)).append('\n');
                }
                errors = JavaScriptSharedUtil.validateScript((String)script.toString());
            }
            catch (Exception e) {
                errors = "Exception occurred during validation.";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errors)) {
            PlatformUI.MIRTH_FRAME.alertCustomError((Component)((Object)PlatformUI.MIRTH_FRAME), errors, "Error validating " + containerName + " " + elementName + "s.");
        }
        return errors;
    }

    private void validateElementRecursive(C element, StringBuilder builder, String selectedSequenceNumber) {
        this.validateElementRecursive(element, builder, selectedSequenceNumber, new LinkedList<String>());
    }

    private void validateElementRecursive(C element, StringBuilder builder, String selectedSequenceNumber, Deque<String> indexVariables) {
        String validationMessage = this.validateElement(element, StringUtils.equals((CharSequence)element.getSequenceNumber(), (CharSequence)selectedSequenceNumber), false);
        if (StringUtils.isNotBlank((CharSequence)validationMessage)) {
            builder.append("Error in connector \"").append(this.connector.getName()).append("\" at ").append(this.response ? "response " : "").append(this.getContainerName().toLowerCase()).append(' ').append(this.getElementName().toLowerCase()).append(' ').append(element.getSequenceNumber()).append(" (\"").append(element.getName()).append("\"):\n").append(validationMessage).append("\n\n");
        }
        if (element instanceof IteratorElement) {
            IteratorElement iterator = (IteratorElement)element;
            String indexVariable = iterator.getProperties().getIndexVariable();
            if (StringUtils.isNotBlank((CharSequence)indexVariable) && indexVariables.contains(indexVariable)) {
                builder.append("Error in connector \"").append(this.connector.getName()).append("\" at ").append(this.response ? "response " : "").append(this.getContainerName().toLowerCase()).append(' ').append(this.getElementName().toLowerCase()).append(' ').append(element.getSequenceNumber()).append(" (\"").append(element.getName()).append("\"):\nDuplicate Iterator index variable ").append(indexVariable).append(" found.\n\n");
            }
            indexVariables.push(indexVariable);
            for (FilterTransformerElement child : iterator.getProperties().getChildren()) {
                this.validateElementRecursive(child, builder, selectedSequenceNumber, indexVariables);
            }
            indexVariables.pop();
        }
    }

    public void doValidateElement() {
        int selectedRow = this.treeTable.getSelectedRow();
        if (this.isValidViewRow(selectedRow)) {
            this.saveData(selectedRow);
            String type = (String)this.treeTable.getValueAt(selectedRow, this.typeColumn);
            try {
                FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(type);
                String validationMessage = this.validateElement(plugin.getProperties());
                if (StringUtils.isBlank((CharSequence)validationMessage)) {
                    PlatformUI.MIRTH_FRAME.alertInformation(this, "Validation successful.");
                } else {
                    PlatformUI.MIRTH_FRAME.alertInformation(this, validationMessage);
                }
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
            }
        }
    }

    public String validateElement(C element) {
        return this.validateElement(element, true, true);
    }

    public String validateElement(C element, boolean highlight, boolean checkSyntax) {
        try {
            FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(element.getType());
            String validationMessage = plugin.checkProperties(element, highlight);
            if (checkSyntax && StringUtils.isBlank((CharSequence)validationMessage)) {
                validationMessage = JavaScriptSharedUtil.validateScript((String)element.getScript(false));
            }
            return validationMessage;
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
            return "Exception occurred during validation.";
        }
    }

    public void doMoveElementUp() {
        this.moveElement(true);
    }

    public void doMoveElementDown() {
        this.moveElement(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveElement(boolean up) {
        int selectedRow = this.treeTable.getSelectedRow();
        if (this.isValidViewRow(selectedRow)) {
            this.saveData(selectedRow);
            MutableTreeTableNode targetParent = null;
            int targetIndex = -1;
            FilterTransformerTreeTableNode<T, C> node = this.getNodeAtRow(selectedRow);
            MutableTreeTableNode parent = (MutableTreeTableNode)node.getParent();
            int index = parent.getIndex(node);
            if (up && index > 0 || !up && index + 1 < parent.getChildCount()) {
                targetParent = parent;
                targetIndex = index + (up ? -1 : 1);
            } else if (parent.getParent() != null && PlatformUI.MIRTH_FRAME.alertOkCancel((Component)((Object)PlatformUI.MIRTH_FRAME), "This will move the " + this.getElementName().toLowerCase() + " out of its parent Iterator. Are you sure you wish to continue?")) {
                targetParent = (MutableTreeTableNode)parent.getParent();
                targetIndex = targetParent.getIndex((TreeNode)parent) + (up ? 0 : 1);
            }
            if (targetParent != null) {
                this.updating.set(true);
                try {
                    this.removeIteratorVariables(node);
                    this.treeTableModel.removeNodeFromParent(node);
                    this.treeTableModel.insertNodeInto(node, targetParent, targetIndex);
                    this.replaceIteratorVariables(node);
                    selectedRow = this.treeTable.getRowForPath(new TreePath(this.treeTableModel.getPathToRoot(node)));
                    this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
                    this.loadData(selectedRow);
                    this.updateSequenceNumbers();
                    this.updateTaskPane();
                    this.updateTable();
                    this.updateTemplateVariables(selectedRow);
                }
                finally {
                    this.updating.set(false);
                }
            }
        }
    }

    public void resizePanes() {
        this.verticalSplitPane.setDividerLocation((int)((double)(PlatformUI.MIRTH_FRAME.currentContentPage.getHeight() / 2) - (double)PlatformUI.MIRTH_FRAME.currentContentPage.getHeight() / 3.5));
        this.horizontalSplitPane.setDividerLocation((int)((double)(PlatformUI.MIRTH_FRAME.currentContentPage.getWidth() / 2) + (double)PlatformUI.MIRTH_FRAME.currentContentPage.getWidth() / 6.7));
        this.templatePanel.resizePanes();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setPreferredSize(new Dimension(0, 0));
        this.horizontalSplitPane = new JSplitPane(1);
        this.horizontalSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.horizontalSplitPane.setOneTouchExpandable(true);
        this.horizontalSplitPane.setContinuousLayout(true);
        this.verticalSplitPane = new JSplitPane(0);
        this.verticalSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.verticalSplitPane.setOneTouchExpandable(true);
        this.verticalSplitPane.setContinuousLayout(true);
        int columnIndex = 0;
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("Enabled");
        this.enabledColumn = columnIndex++;
        columnNames.add("#");
        this.numColumn = columnIndex++;
        columnNames.add("Name");
        this.nameColumn = columnIndex++;
        columnNames.add("Type");
        this.typeColumn = columnIndex++;
        final LeftCellRenderer numCellRenderer = new LeftCellRenderer();
        final NameEditor nameCellEditor = new NameEditor();
        final CheckBoxRenderer checkboxCellRenderer = new CheckBoxRenderer();
        final CheckBoxEditor checkboxCellEditor = new CheckBoxEditor();
        this.treeTable = new MirthTreeTable(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == BaseEditorPane.this.numColumn) {
                    return numCellRenderer;
                }
                if (column == BaseEditorPane.this.enabledColumn) {
                    return checkboxCellRenderer;
                }
                return super.getCellRenderer(row, column);
            }

            public TableCellEditor getCellEditor(int row, int column) {
                if (this.isHierarchical(column)) {
                    return nameCellEditor;
                }
                if (column == BaseEditorPane.this.enabledColumn) {
                    return checkboxCellEditor;
                }
                return super.getCellEditor(row, column);
            }
        };
        this.treeTableModel = new SortableTreeTableModel(){

            public int getHierarchicalColumn() {
                return BaseEditorPane.this.nameColumn;
            }

            public boolean isCellEditable(Object node, int column) {
                int row = BaseEditorPane.this.treeTable.getRowForPath(new TreePath(this.getPathToRoot((TreeTableNode)node)));
                return BaseEditorPane.this.allowCellEdit(row, column);
            }
        };
        this.treeTableModel.setColumnIdentifiers(columnNames);
        this.treeTable.setBorder(BorderFactory.createEmptyBorder());
        this.treeTable.setTreeTableModel((TreeTableModel)this.treeTableModel);
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.setDoubleBuffered(true);
        this.treeTable.setFocusable(true);
        this.treeTable.setEditable(true);
        this.treeTable.setAutoCreateColumnsFromModel(false);
        this.treeTable.setShowGrid(true, true);
        this.treeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.treeTable.setCustomEditorControls(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.getTreeSelectionModel().setSelectionMode(1);
        this.treeTable.setRowHeight(20);
        this.treeTable.packTable(10);
        this.treeTable.setSortable(false);
        this.treeTable.setOpaque(true);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setDragEnabled(false);
        this.treeTable.getTableHeader().setReorderingAllowed(false);
        this.treeTable.putClientProperty("JTree.lineStyle", "Horizontal");
        final NameRenderer nameRenderer = new NameRenderer();
        this.treeTable.setTreeCellRenderer(nameRenderer);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.treeTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.treeTable.getColumnExt(this.numColumn).setMaxWidth(200);
        this.treeTable.getColumnExt(this.numColumn).setPreferredWidth(36);
        this.treeTable.getColumnExt(this.numColumn).setCellRenderer((TableCellRenderer)new LeftCellRenderer());
        this.treeTable.getColumnExt(this.typeColumn).setMaxWidth(200);
        this.treeTable.getColumnExt(this.typeColumn).setMinWidth(155);
        this.treeTable.getColumnExt(this.typeColumn).setPreferredWidth(155);
        this.treeTable.getColumnExt(this.enabledColumn).setMaxWidth(200);
        this.treeTable.getColumnExt(this.enabledColumn).setMinWidth(20);
        this.treeTable.getColumnExt(this.enabledColumn).setPreferredWidth(65);
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BaseEditorPane.this.tableListSelectionChanged(evt);
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BaseEditorPane.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BaseEditorPane.this.checkSelectionAndPopupMenu(evt);
            }
        });
        this.treeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 127) {
                    BaseEditorPane.this.doDeleteElement();
                }
            }
        });
        this.treeTable.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (!BaseEditorPane.this.updating.getAndSet(true)) {
                    SwingUtilities.invokeLater(() -> BaseEditorPane.this.updating.set(false));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                int selectedRow = BaseEditorPane.this.treeTable.getSelectedRow();
                if (BaseEditorPane.this.isValidViewRow(selectedRow) && !BaseEditorPane.this.updating.getAndSet(true)) {
                    FilterTransformerTreeTableNode selectedNode = BaseEditorPane.this.getNodeAtRow(selectedRow);
                    try {
                        BaseEditorPane.this.saveData(selectedRow);
                    }
                    finally {
                        SwingUtilities.invokeLater(() -> {
                            int newSelectedRow = BaseEditorPane.this.treeTable.getSelectedRow();
                            if (BaseEditorPane.this.isValidViewRow(newSelectedRow) && selectedNode != BaseEditorPane.this.getNodeAtRow(newSelectedRow)) {
                                BaseEditorPane.this.loadData(newSelectedRow);
                                BaseEditorPane.this.updateTaskPane();
                                BaseEditorPane.this.updateTable();
                                BaseEditorPane.this.updateGeneratedCode();
                            }
                            BaseEditorPane.this.updating.set(false);
                        });
                    }
                }
            }
        });
        if (this.useOperatorColumn()) {
            this.treeTable.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent evt) {
                    TreePath path = BaseEditorPane.this.treeTable.getPathForLocation(evt.getX(), evt.getY());
                    if (path != null && ((OperatorNamePair)((Object)BaseEditorPane.this.treeTableModel.getValueAt(path.getLastPathComponent(), BaseEditorPane.this.nameColumn))).getOperator() != null) {
                        Rectangle pathBounds;
                        Point point = evt.getPoint();
                        Rectangle cellRect = BaseEditorPane.this.treeTable.getCellRect(BaseEditorPane.this.treeTable.getRowForPath(path), BaseEditorPane.this.nameColumn, true);
                        if (cellRect != null) {
                            point.translate(-cellRect.x, -cellRect.y);
                        }
                        if ((pathBounds = ((JTree)((Object)BaseEditorPane.this.treeTable.getCellRenderer(0, BaseEditorPane.this.treeTable.getHierarchicalColumn()))).getPathBounds(path)) != null) {
                            point.translate(-pathBounds.x, 0);
                        }
                        Point loc = nameRenderer.getOperatorButton().getLocation();
                        if (point.x >= loc.x && point.x < loc.x + UIConstants.ICON_AND.getIconWidth() && point.y >= loc.y && point.y < loc.y + UIConstants.ICON_AND.getIconHeight()) {
                            BaseEditorPane.this.treeTable.setCursor(Cursor.getPredefinedCursor(12));
                            return;
                        }
                    }
                    if (BaseEditorPane.this.treeTable.getCursor().getType() != 0) {
                        BaseEditorPane.this.treeTable.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }
        this.treeTableScrollPane = new JScrollPane((Component)((Object)this.treeTable));
        this.treeTableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabPane = new JTabbedPane();
        this.tabPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (BaseEditorPane.this.tabPane.getSelectedIndex() == 1) {
                    BaseEditorPane.this.updateGeneratedCode();
                }
            }
        });
        this.propertiesContainer = new JPanel();
        this.propertiesContainer.setBorder(BorderFactory.createEmptyBorder());
        this.tabPane.addTab(this.getElementName(), this.propertiesContainer);
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.generatedScriptTextArea = new MirthRTextScrollPane(null, true, "text/javascript", false);
        this.generatedScriptTextArea.setBackground(new Color(204, 204, 204));
        this.generatedScriptTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.generatedScriptTextArea.getTextArea().setEditable(false);
        this.generatedScriptTextArea.getTextArea().setDropTarget(null);
        this.tabPane.addTab("Generated Script", (Component)((Object)this.generatedScriptTextArea));
        this.templatePanel = new TabbedTemplatePanel(this);
        this.templatePanel.setBorder(BorderFactory.createEmptyBorder());
        this.nameActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedRow;
                if (!BaseEditorPane.this.updating.get() && (selectedRow = BaseEditorPane.this.treeTable.getSelectedRow()) >= 0) {
                    FilterTransformerTreeTableNode node = BaseEditorPane.this.getNodeAtRow(selectedRow);
                    OperatorNamePair pair = (OperatorNamePair)((Object)BaseEditorPane.this.treeTableModel.getValueAt(node, BaseEditorPane.this.nameColumn));
                    BaseEditorPane.this.treeTableModel.setValueAt((Object)new OperatorNamePair(pair.getOperator(), evt.getActionCommand()), node, BaseEditorPane.this.nameColumn);
                }
            }
        };
        this.viewTasks = new JXTaskPane();
        this.viewTasks.setTitle("BridgeLink Views");
        this.viewTasks.setFocusable(false);
        this.viewTasks.add((Action)this.initActionCallback("accept", "Return back to channel.", ActionFactory.createBoundAction((String)"accept", (String)"Back to Channel", (String)"B"), new ImageIcon(Frame.class.getResource("images/resultset_previous.png"))));
        PlatformUI.MIRTH_FRAME.setNonFocusable(this.viewTasks);
        this.viewTasks.setVisible(false);
        PlatformUI.MIRTH_FRAME.taskPaneContainer.add((Component)this.viewTasks, PlatformUI.MIRTH_FRAME.taskPaneContainer.getComponentCount() - 1);
        String containerName = this.getContainerName().toLowerCase();
        String containerNameCap = WordUtils.capitalize((String)containerName);
        String elementName = this.getElementName().toLowerCase();
        String elementNameCap = WordUtils.capitalize((String)elementName);
        this.editorTasks = new JXTaskPane();
        this.editorTasks.setTitle(containerNameCap + " Tasks");
        this.editorTasks.setFocusable(false);
        this.editorPopupMenu = new JPopupMenu();
        this.editorTasks.add((Action)this.initActionCallback("doAddNewElement", "Add a new " + containerName + " " + elementName + ".", ActionFactory.createBoundAction((String)"doAddNewElement", (String)("Add New " + elementNameCap), (String)"N"), new ImageIcon(Frame.class.getResource("images/add.png"))));
        JMenuItem addNewElementItem = new JMenuItem("Add New " + elementNameCap);
        addNewElementItem.setIcon(new ImageIcon(Frame.class.getResource("images/add.png")));
        addNewElementItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doAddNewElement();
            }
        });
        this.editorPopupMenu.add(addNewElementItem);
        this.editorTasks.add((Action)this.initActionCallback("doDeleteElement", "Delete the currently selected " + containerName + " " + elementName + ".", ActionFactory.createBoundAction((String)"doDeleteElement", (String)("Delete " + elementNameCap), (String)"X"), new ImageIcon(Frame.class.getResource("images/delete.png"))));
        JMenuItem doDeleteElementItem = new JMenuItem("Delete " + elementNameCap);
        doDeleteElementItem.setIcon(new ImageIcon(Frame.class.getResource("images/delete.png")));
        doDeleteElementItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doDeleteElement();
            }
        });
        this.editorPopupMenu.add(doDeleteElementItem);
        this.editorTasks.add((Action)this.initActionCallback("doAssignToIterator", "Add the selected " + elementName + " to a new or existing Iterator.", ActionFactory.createBoundAction((String)"doAssignToIterator", (String)"Assign To Iterator", null), new ImageIcon(Frame.class.getResource("images/add.png"))));
        JMenuItem assignToIteratorItem = new JMenuItem("Assign To Iterator");
        assignToIteratorItem.setIcon(new ImageIcon(Frame.class.getResource("images/add.png")));
        assignToIteratorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doAssignToIterator();
            }
        });
        this.editorPopupMenu.add(assignToIteratorItem);
        this.editorTasks.add((Action)this.initActionCallback("doRemoveFromIterator", "Remove the selected " + elementName + " from its current Iterator.", ActionFactory.createBoundAction((String)"doRemoveFromIterator", (String)"Remove From Iterator", null), new ImageIcon(Frame.class.getResource("images/delete.png"))));
        JMenuItem removeFromIteratorItem = new JMenuItem("Remove From Iterator");
        removeFromIteratorItem.setIcon(new ImageIcon(Frame.class.getResource("images/delete.png")));
        removeFromIteratorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doRemoveFromIterator();
            }
        });
        this.editorPopupMenu.add(removeFromIteratorItem);
        this.editorTasks.add((Action)this.initActionCallback("doImport", "Import a " + containerName + " from an XML file.", ActionFactory.createBoundAction((String)"doImport", (String)("Import " + containerNameCap), (String)"I"), new ImageIcon(Frame.class.getResource("images/report_go.png"))));
        JMenuItem doImportItem = new JMenuItem("Import " + containerNameCap);
        doImportItem.setIcon(new ImageIcon(Frame.class.getResource("images/report_go.png")));
        doImportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doImport();
            }
        });
        this.editorPopupMenu.add(doImportItem);
        this.editorTasks.add((Action)this.initActionCallback("doExport", "Export the " + containerName + " to an XML file.", ActionFactory.createBoundAction((String)"doExport", (String)("Export " + containerNameCap), (String)"E"), new ImageIcon(Frame.class.getResource("images/report_disk.png"))));
        JMenuItem doExportItem = new JMenuItem("Export " + containerNameCap);
        doExportItem.setIcon(new ImageIcon(Frame.class.getResource("images/report_disk.png")));
        doExportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doExport();
            }
        });
        this.editorPopupMenu.add(doExportItem);
        this.editorTasks.add((Action)this.initActionCallback("doValidate", "Validate the entire " + containerName + " and all " + elementName + "s.", ActionFactory.createBoundAction((String)"doValidate", (String)("Validate " + containerNameCap), (String)"V"), new ImageIcon(Frame.class.getResource("images/accept.png"))));
        JMenuItem doValidateItem = new JMenuItem("Validate " + containerNameCap);
        doValidateItem.setIcon(new ImageIcon(Frame.class.getResource("images/accept.png")));
        doValidateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doValidateElement();
            }
        });
        this.editorPopupMenu.add(doValidateItem);
        this.editorTasks.add((Action)this.initActionCallback("doValidateElement", "Validate the current " + elementName + ".", ActionFactory.createBoundAction((String)"doValidateElement", (String)("Validate " + elementNameCap), (String)"V"), new ImageIcon(Frame.class.getResource("images/accept.png"))));
        JMenuItem doValidateElementItem = new JMenuItem("Validate " + elementNameCap);
        doValidateElementItem.setIcon(new ImageIcon(Frame.class.getResource("images/accept.png")));
        doValidateElementItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doValidateElement();
            }
        });
        this.editorPopupMenu.add(doValidateElementItem);
        this.editorTasks.add((Action)this.initActionCallback("doMoveElementUp", "Move the currently selected " + elementName + " up.", ActionFactory.createBoundAction((String)"doMoveElementUp", (String)("Move " + elementNameCap + " Up"), (String)"P"), new ImageIcon(Frame.class.getResource("images/arrow_up.png"))));
        JMenuItem doMoveElementUpItem = new JMenuItem("Move " + elementNameCap + " Up");
        doMoveElementUpItem.setIcon(new ImageIcon(Frame.class.getResource("images/arrow_up.png")));
        doMoveElementUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doMoveElementUp();
            }
        });
        this.editorPopupMenu.add(doMoveElementUpItem);
        this.editorTasks.add((Action)this.initActionCallback("doMoveElementDown", "Move the currently selected " + elementName + " down.", ActionFactory.createBoundAction((String)"doMoveElementDown", (String)("Move " + elementNameCap + " Down"), (String)"D"), new ImageIcon(Frame.class.getResource("images/arrow_down.png"))));
        JMenuItem doMoveElementDownItem = new JMenuItem("Move " + elementNameCap + " Down");
        doMoveElementDownItem.setIcon(new ImageIcon(Frame.class.getResource("images/arrow_down.png")));
        doMoveElementDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.doMoveElementDown();
            }
        });
        this.editorPopupMenu.add(doMoveElementDownItem);
        PlatformUI.MIRTH_FRAME.setNonFocusable(this.editorTasks);
        this.editorTasks.setVisible(false);
        PlatformUI.MIRTH_FRAME.taskPaneContainer.add((Component)this.editorTasks, PlatformUI.MIRTH_FRAME.taskPaneContainer.getComponentCount() - 1);
        this.dropTarget = new DropTarget(this, this);
        this.treeTable.setDropTarget(this.dropTarget);
        this.treeTableScrollPane.setDropTarget(this.dropTarget);
        this.updatePlugins();
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.propertiesContainer.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.verticalSplitPane.setTopComponent(this.treeTableScrollPane);
        this.verticalSplitPane.setBottomComponent(this.tabPane);
        this.horizontalSplitPane.setLeftComponent(this.verticalSplitPane);
        this.horizontalSplitPane.setRightComponent(this.templatePanel);
        this.add((Component)this.horizontalSplitPane, "grow");
    }

    private void updatePlugins() {
        ArrayList<String> types = new ArrayList<String>();
        for (String pluginPointName : this.getPlugins().keySet()) {
            types.add(pluginPointName);
        }
        Object[] typeArray = types.toArray(new String[types.size()]);
        MirthComboBoxTableCellEditor typeEditor = new MirthComboBoxTableCellEditor((JTable)((Object)this.treeTable), typeArray, 2, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseEditorPane.this.typeComboBoxActionPerformed(evt);
            }
        });
        this.treeTable.getColumnExt(this.typeColumn).setCellRenderer((TableCellRenderer)new MirthComboBoxTableCellRenderer(typeArray));
        this.treeTable.getColumnExt(this.typeColumn).setCellEditor((TableCellEditor)typeEditor);
        this.treeTable.getColumnExt(this.enabledColumn).setCellRenderer((TableCellRenderer)new CheckBoxRenderer());
        this.treeTable.getColumnExt(this.enabledColumn).setCellEditor((TableCellEditor)new CheckBoxEditor());
        for (FilterTransformerTypePlugin<T, C> plugin : this.getPlugins().values()) {
            plugin.getPanel().setNameActionListener(this.nameActionListener);
        }
    }

    private void checkSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.treeTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.treeTable.setRowSelectionInterval(row, row);
            }
            this.editorPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tableListSelectionChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting() && !this.updating.getAndSet(true)) {
            try {
                int selectedRow = this.treeTable.getSelectedRow();
                int previousRow = this.previouslySelectedIndex;
                this.previouslySelectedIndex = selectedRow;
                if (previousRow != selectedRow) {
                    this.saveData(previousRow);
                }
                this.loadData(selectedRow);
                this.updateTaskPane();
                this.updateTable();
                this.updateGeneratedCode();
            }
            finally {
                this.updating.set(false);
            }
        }
    }

    private void loadData(int viewRow) {
        if (this.isValidViewRow(viewRow)) {
            this.previouslySelectedIndex = viewRow;
            FilterTransformerTreeTableNode<T, C> node = this.getNodeAtRow(viewRow);
            C element = node.getElement();
            String type = element.getType();
            try {
                FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(type);
                plugin.setProperties(this.connector.getMode(), this.response, element);
                this.propertiesContainer.removeAll();
                if (plugin.includesScrollPane()) {
                    this.propertiesScrollPane.setViewportView(null);
                    this.propertiesContainer.add(plugin.getPanel(), "grow");
                } else {
                    this.propertiesScrollPane.setViewportView(plugin.getPanel());
                    this.propertiesContainer.add((Component)this.propertiesScrollPane, "grow");
                }
                this.tabPane.updateUI();
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
            }
        } else {
            this.previouslySelectedIndex = -1;
            this.propertiesScrollPane.setViewportView(null);
            this.propertiesContainer.removeAll();
        }
        this.updateTemplateVariables(viewRow);
    }

    private void updateTemplateVariables() {
        this.updateTemplateVariables(0);
    }

    private void updateTemplateVariables(int viewRow) {
        if (this.connector.getMode() == Connector.Mode.SOURCE) {
            LinkedHashSet<String> concatenatedRules = new LinkedHashSet<String>();
            LinkedHashSet<String> concatenatedSteps = new LinkedHashSet<String>();
            this.getRuleVariables(this.connector, concatenatedRules, true);
            this.getStepVariables(this.connector, concatenatedSteps, true, viewRow);
            this.templatePanel.updateVariables(concatenatedRules, concatenatedSteps);
        } else {
            this.templatePanel.updateVariables(this.getRuleVariables(), this.getStepVariables(viewRow));
            this.templatePanel.populateConnectors(PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getDestinationConnectors());
        }
    }

    protected abstract void getRuleVariables(Connector var1, Set<String> var2, boolean var3);

    protected abstract void getStepVariables(Connector var1, Set<String> var2, boolean var3, int var4);

    private Set<String> getRuleVariables() {
        Channel channel = PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel;
        LinkedHashSet<String> concatenatedRules = new LinkedHashSet<String>();
        VariableListUtil.getRuleVariables(concatenatedRules, channel.getSourceConnector().getFilter(), false);
        List destinationConnectors = channel.getDestinationConnectors();
        Iterator it = destinationConnectors.iterator();
        boolean seenCurrent = false;
        while (it.hasNext()) {
            Connector destination = (Connector)it.next();
            if (this.connector == destination) {
                this.getRuleVariables(this.connector, concatenatedRules, true);
                seenCurrent = true;
                continue;
            }
            if (seenCurrent) continue;
            VariableListUtil.getRuleVariables(concatenatedRules, destination.getFilter(), false);
            concatenatedRules.add(destination.getName());
        }
        return concatenatedRules;
    }

    private Set<String> getStepVariables(int viewRow) {
        Channel channel = PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel;
        LinkedHashSet<String> concatenatedSteps = new LinkedHashSet<String>();
        VariableListUtil.getStepVariables(concatenatedSteps, channel.getSourceConnector().getTransformer(), false);
        List destinationConnectors = channel.getDestinationConnectors();
        Iterator it = destinationConnectors.iterator();
        boolean seenCurrent = false;
        while (it.hasNext()) {
            Connector destination = (Connector)it.next();
            if (this.connector == destination) {
                if (this.response) {
                    VariableListUtil.getStepVariables(concatenatedSteps, this.connector.getTransformer(), true);
                }
                this.getStepVariables(this.connector, concatenatedSteps, true, viewRow);
                seenCurrent = true;
                continue;
            }
            if (seenCurrent) continue;
            VariableListUtil.getStepVariables(concatenatedSteps, destination.getTransformer(), false);
            VariableListUtil.getStepVariables(concatenatedSteps, destination.getResponseTransformer(), false);
            concatenatedSteps.add(destination.getName());
        }
        return concatenatedSteps;
    }

    private void saveData() {
        this.saveData(this.treeTable.getSelectedRow());
    }

    private void saveData(int viewRow) {
        this.stopTableEditing();
        if (this.isValidViewRow(viewRow)) {
            FilterTransformerTreeTableNode<T, C> node = this.getNodeAtRow(viewRow);
            String type = node.getElement().getType();
            try {
                C element = this.getPlugins().get(type).getProperties();
                element.setSequenceNumber(node.getElement().getSequenceNumber());
                if (this.useOperatorColumn()) {
                    this.setOperator(element, this.getOperator(node.getElement()));
                }
                element.setName(node.getElement().getName());
                element.setEnabled(node.getElement().isEnabled());
                node.setElement(element);
                this.treeTableModel.setValueAt((Object)element.getSequenceNumber(), node, this.numColumn);
                if (this.useOperatorColumn()) {
                    this.treeTableModel.setValueAt((Object)new OperatorNamePair((Rule.Operator)this.getOperator(element), element.getName()), node, this.nameColumn);
                } else {
                    this.treeTableModel.setValueAt((Object)new OperatorNamePair(element.getName()), node, this.nameColumn);
                }
                this.treeTableModel.setValueAt((Object)element.isEnabled(), node, this.enabledColumn);
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable(this, e);
            }
        }
    }

    private void stopTableEditing() {
        FilterTransformerTypePlugin<T, C> plugin;
        FilterTransformerTreeTableNode<T, C> node;
        int viewRow;
        if (this.treeTable.isEditing()) {
            this.treeTable.getCellEditor(this.treeTable.getEditingRow(), this.treeTable.getEditingColumn()).stopCellEditing();
        }
        if (this.isValidViewRow(viewRow = this.treeTable.getSelectedRow()) && (node = this.getNodeAtRow(viewRow)) != null && (plugin = this.getPlugins().get(node.getElement().getType())) != null) {
            plugin.getPanel().stopEditing();
        }
    }

    private boolean isValidViewRow(int viewRow) {
        return viewRow >= 0 && viewRow < this.treeTable.getRowCount();
    }

    private FilterTransformerTreeTableNode<T, C> getNodeAtRow(int viewRow) {
        return (FilterTransformerTreeTableNode)((Object)this.treeTable.getPathForRow(viewRow).getLastPathComponent());
    }

    private BoundAction initActionCallback(String callbackMethod, String toolTip, BoundAction boundAction, ImageIcon icon) {
        if (icon != null) {
            boundAction.putValue("SmallIcon", (Object)icon);
        }
        boundAction.putValue("ShortDescription", (Object)toolTip);
        boundAction.registerCallback((Object)this, callbackMethod);
        return boundAction;
    }

    private void updateTaskPane() {
        int rowCount = this.treeTable.getRowCount();
        int selectedRow = this.treeTable.getSelectedRow();
        if (rowCount <= 0) {
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 1, -1, false);
        } else if (rowCount == 1) {
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 0, -1, true);
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 3, 3, false);
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 8, -1, false);
        } else {
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 0, -1, true);
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 3, 3, false);
            TreePath path = this.treeTable.getPathForRow(selectedRow);
            if (path != null) {
                TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
                TreeTableNode parent = node.getParent();
                if (parent.getParent() == null) {
                    int childIndex = parent.getIndex((TreeNode)node);
                    if (childIndex == 0) {
                        PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 8, 8, false);
                    }
                    if (childIndex == parent.getChildCount() - 1) {
                        PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 9, 9, false);
                    }
                } else {
                    PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 3, 3, true);
                }
            } else {
                PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 8, -1, false);
            }
        }
        PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 4, 5, true);
        PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 6, 6, true);
        PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 7, 7, selectedRow >= 0);
        if (selectedRow < 0) {
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 1, 3, false);
            PlatformUI.MIRTH_FRAME.setVisibleTasks(this.editorTasks, this.editorPopupMenu, 8, -1, false);
        }
    }

    private void updateGeneratedCode() {
        int selectedRow = this.treeTable.getSelectedRow();
        if (this.isValidViewRow(selectedRow)) {
            this.saveData(selectedRow);
            TreePath path = this.treeTable.getPathForRow(selectedRow);
            FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)((Object)path.getLastPathComponent());
            Object element = node.getElementWithChildren();
            try {
                this.generatedScriptTextArea.setText(JavaScriptSharedUtil.prettyPrint((String)element.getScript(false)));
            }
            catch (ScriptBuilderException e) {
                e.printStackTrace();
                this.generatedScriptTextArea.setText("");
            }
        } else {
            this.generatedScriptTextArea.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void typeComboBoxActionPerformed(ActionEvent evt) {
        int selectedRow = this.treeTable.getSelectedRow();
        if (selectedRow >= 0 && !this.updating.getAndSet(true)) {
            try {
                FilterTransformerTreeTableNode<T, C> node = this.getNodeAtRow(selectedRow);
                String selectedType = ((JComboBox)evt.getSource()).getSelectedItem().toString();
                String previousType = (String)this.treeTableModel.getValueAt(node, this.typeColumn);
                if (!StringUtils.equalsIgnoreCase((CharSequence)selectedType, (CharSequence)previousType)) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)previousType, (CharSequence)"Iterator") && node.getChildCount() > 0) {
                        PlatformUI.MIRTH_FRAME.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), "Please remove all children before changing an Iterator to a different type.");
                        return;
                    }
                    FilterTransformerTypePlugin<T, C> plugin = this.getPlugins().get(previousType);
                    C selectedElement = plugin.getProperties();
                    String containerName = this.getContainerName().toLowerCase();
                    String elementName = this.getElementName().toLowerCase();
                    if (!EqualsBuilder.reflectionEquals(selectedElement, plugin.getDefaults(), (String[])new String[]{"name", "sequenceNumber"}) && !PlatformUI.MIRTH_FRAME.alertOption((Component)((Object)PlatformUI.MIRTH_FRAME), "Are you sure you would like to change this " + containerName + " " + elementName + " and lose all of the current data?")) {
                        ((JComboBox)evt.getSource()).getModel().setSelectedItem(previousType);
                        return;
                    }
                    plugin = this.getPlugins().get(selectedType);
                    C newElement = plugin.getDefaults();
                    node.setElement(newElement);
                    this.treeTableModel.setValueAt((Object)new OperatorNamePair(newElement.getName()), node, this.nameColumn);
                    plugin.setProperties(this.connector.getMode(), this.response, newElement);
                    this.propertiesContainer.removeAll();
                    if (plugin.includesScrollPane()) {
                        this.propertiesScrollPane.setViewportView(null);
                        this.propertiesContainer.add(plugin.getPanel(), "grow");
                    } else {
                        this.propertiesScrollPane.setViewportView(plugin.getPanel());
                        this.propertiesContainer.add((Component)this.propertiesScrollPane, "grow");
                    }
                    this.tabPane.updateUI();
                    this.updateTaskPane();
                    this.updateSequenceNumbers();
                    this.updateTable();
                    this.updateGeneratedCode();
                }
            }
            catch (Exception e) {
                PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e);
            }
            finally {
                this.updating.set(false);
            }
        }
    }

    private void updateSequenceNumbers() {
        this.updateSequenceNumbers(this.treeTableModel.getRoot(), "");
    }

    private void updateSequenceNumbers(TreeTableNode node, String prefix) {
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            prefix = (String)prefix + "-";
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeTableNode child = node.getChildAt(i);
            String num = (String)prefix + i;
            this.treeTableModel.setValueAt((Object)num, (Object)child, this.numColumn);
            this.updateSequenceNumbers(child, num);
        }
    }

    private void updateTabPane() {
        int selectedIndex = this.tabPane.getSelectedIndex();
        this.tabPane.setSelectedIndex(selectedIndex == 0 ? 1 : 0);
        this.tabPane.setSelectedIndex(selectedIndex);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                if (iterator.hasNext() && fileList.size() == 1) {
                    String fileName = ((File)iterator.next()).getName();
                    if (!fileName.substring(fileName.lastIndexOf(".")).equalsIgnoreCase(".xml")) {
                        dtde.rejectDrag();
                    }
                } else {
                    dtde.rejectDrag();
                }
            } else if (!this.handleDragEnter(dtde, tr)) {
                dtde.rejectDrag();
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
        }
    }

    protected abstract boolean handleDragEnter(DropTargetDragEvent var1, Transferable var2) throws UnsupportedFlavorException, IOException;

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                if (fileList.size() == 1) {
                    File file = (File)iterator.next();
                    this.importFilterTransformer(PlatformUI.MIRTH_FRAME.readFileToString(file));
                }
            } else {
                this.handleDrop(dtde, tr);
            }
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    protected abstract void handleDrop(DropTargetDropEvent var1, Transferable var2) throws UnsupportedFlavorException, IOException;

    private class LeftCellRenderer
    extends DefaultTableCellRenderer {
        public LeftCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (StringUtils.isNotBlank((CharSequence)((String)value))) {
                value = " " + String.valueOf(value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class NameEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JPanel panel;
        private JLabel bulletLabel;
        private OperatorButton operatorButton;
        private JLabel nameLabel;
        private JTextField nameField;
        private boolean textFieldClicked = false;
        private int offset = 0;

        public NameEditor() {
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 0")){

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    int newOffset = NameEditor.this.offset - this.getInsets().left;
                    super.setBounds(x + newOffset, y, width - newOffset, height);
                }
            };
            this.panel.setBorder(BorderFactory.createEmptyBorder());
            this.bulletLabel = new JLabel();
            this.panel.add((Component)this.bulletLabel, "aligny top, gaptop 2");
            if (BaseEditorPane.this.useOperatorColumn()) {
                this.operatorButton = new OperatorButton();
                this.operatorButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ImageIcon icon = NameEditor.this.operatorButton.getIcon() == UIConstants.ICON_AND ? UIConstants.ICON_OR : UIConstants.ICON_AND;
                        NameEditor.this.operatorButton.setIcon(icon);
                    }
                });
                this.panel.add((Component)this.operatorButton, "h 17!, w 21!, aligny top, gaptop 1, gapafter 4");
            }
            this.nameLabel = new JLabel();
            this.nameLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (BaseEditorPane.this.treeTable.isEditing() && BaseEditorPane.this.treeTable.getSelectedRow() >= 0 && evt.getClickCount() >= 2 && BaseEditorPane.this.allowNameEdit(BaseEditorPane.this.treeTable.getSelectedRow(), BaseEditorPane.this.nameColumn)) {
                        NameEditor.this.textFieldClicked = true;
                        NameEditor.this.nameLabel.setVisible(false);
                        NameEditor.this.nameField.setVisible(true);
                    }
                }
            });
            this.panel.add((Component)this.nameLabel, "growx, pushx");
            this.nameField = new JTextField();
            this.panel.add((Component)this.nameField, "growx, pushx");
        }

        @Override
        public Object getCellEditorValue() {
            if (BaseEditorPane.this.useOperatorColumn()) {
                Rule.Operator operator = this.operatorButton.getIcon() != null ? (this.operatorButton.getIcon() == UIConstants.ICON_AND ? Rule.Operator.AND : Rule.Operator.OR) : null;
                return new OperatorNamePair(operator, this.nameField.getText());
            }
            return new OperatorNamePair(this.nameField.getText());
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            this.textFieldClicked = false;
            if (evt instanceof MouseEvent) {
                MouseEvent mouseEvt = (MouseEvent)evt;
                Point point = mouseEvt.getPoint();
                TreePath path = BaseEditorPane.this.treeTable.getPathForLocation(mouseEvt.getX(), mouseEvt.getY());
                if (path != null) {
                    if (BaseEditorPane.this.useOperatorColumn() && ((OperatorNamePair)((Object)BaseEditorPane.this.treeTableModel.getValueAt(path.getLastPathComponent(), BaseEditorPane.this.nameColumn))).getOperator() != null) {
                        Rectangle pathBounds;
                        Rectangle cellRect = BaseEditorPane.this.treeTable.getCellRect(BaseEditorPane.this.treeTable.getRowForPath(path), BaseEditorPane.this.nameColumn, true);
                        if (cellRect != null) {
                            point.translate(-cellRect.x, -cellRect.y);
                        }
                        if ((pathBounds = ((JTree)((Object)BaseEditorPane.this.treeTable.getCellRenderer(0, BaseEditorPane.this.treeTable.getHierarchicalColumn()))).getPathBounds(path)) != null) {
                            point.translate(-pathBounds.x, 0);
                        }
                        Point loc = this.operatorButton.getLocation();
                        if (loc.x == 0) {
                            loc.translate(UIConstants.ICON_BULLET_GREEN.getIconWidth(), 0);
                        }
                        if (point.x >= loc.x && point.x < loc.x + UIConstants.ICON_AND.getIconWidth() && point.y >= loc.y && point.y < loc.y + UIConstants.ICON_AND.getIconHeight()) {
                            return true;
                        }
                    }
                    if (mouseEvt.getClickCount() >= 2) {
                        Point namePoint = this.nameLabel.getLocation();
                        if (namePoint.x == 0) {
                            namePoint.translate(UIConstants.ICON_BULLET_GREEN.getIconWidth(), 0);
                        }
                        if (point.x >= namePoint.x) {
                            this.textFieldClicked = true;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (row >= 0) {
                TreePath path = BaseEditorPane.this.treeTable.getPathForRow(row);
                FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)((Object)path.getLastPathComponent());
                if (node.getElement() instanceof IteratorElement) {
                    this.bulletLabel.setIcon(UIConstants.ICON_BULLET_YELLOW);
                } else {
                    this.bulletLabel.setIcon(UIConstants.ICON_BULLET_GREEN);
                }
                this.nameLabel.setText(node.getElement().getName());
                this.nameField.setText(node.getElement().getName());
                this.panel.setBackground(BaseEditorPane.this.treeTable.getSelectionBackground());
                this.nameLabel.setBackground(this.panel.getBackground());
                boolean allowNameEdit = this.textFieldClicked && BaseEditorPane.this.allowNameEdit(row, column);
                this.nameLabel.setVisible(!allowNameEdit);
                this.nameField.setVisible(allowNameEdit);
                if (BaseEditorPane.this.useOperatorColumn()) {
                    if (BaseEditorPane.this.allowOperatorEdit(row, column)) {
                        Rule.Operator operator = (Rule.Operator)BaseEditorPane.this.getOperator(node.getElement());
                        this.operatorButton.setIcon(operator != null ? (operator == Rule.Operator.AND ? UIConstants.ICON_AND : UIConstants.ICON_OR) : null);
                        this.operatorButton.setEnabled(true);
                    } else {
                        this.operatorButton.setIcon(null);
                        this.operatorButton.setEnabled(false);
                    }
                    this.operatorButton.setBackground(this.panel.getBackground());
                    this.operatorButton.setCursor(Cursor.getPredefinedCursor(12));
                }
                Rectangle cellRect = BaseEditorPane.this.treeTable.getCellRect(row, column, true);
                Rectangle pathBounds = ((JTree)((Object)BaseEditorPane.this.treeTable.getCellRenderer(0, BaseEditorPane.this.treeTable.getHierarchicalColumn()))).getPathBounds(path);
                this.offset = cellRect.x + pathBounds.x - BaseEditorPane.this.treeTable.getColumn(BaseEditorPane.this.enabledColumn).getWidth() - BaseEditorPane.this.treeTable.getColumn(BaseEditorPane.this.numColumn).getWidth();
            }
            return this.panel;
        }
    }

    private class CheckBoxRenderer
    extends JPanel
    implements TableCellRenderer {
        private MirthCheckBox checkBox;

        public CheckBoxRenderer() {
            super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = new MirthCheckBox();
            this.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true) && row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            }
            this.checkBox.setBackground(this.getBackground());
            if (value != null) {
                this.checkBox.setSelected((Boolean)value);
            }
            this.checkBox.setEnabled(BaseEditorPane.this.allowEnableEdit(row, column));
            return this;
        }
    }

    private class CheckBoxEditor
    extends DefaultCellEditor {
        private JPanel panel;
        private JCheckBox checkBox;

        public CheckBoxEditor() {
            super(new MirthCheckBox());
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.checkBox = (JCheckBox)this.editorComponent;
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.panel.setBackground(table.getSelectionBackground());
            component.setBackground(this.panel.getBackground());
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            MouseEvent mouseEvt;
            return !(evt instanceof MouseEvent) || BaseEditorPane.this.allowEnableEdit(BaseEditorPane.this.treeTable.rowAtPoint((mouseEvt = (MouseEvent)evt).getPoint()), BaseEditorPane.this.treeTable.columnAtPoint(mouseEvt.getPoint()));
        }
    }

    private class NameRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JLabel bulletLabel;
        private OperatorButton operatorButton;
        private JLabel nameLabel;

        public NameRenderer() {
            this.setOpaque(false);
            this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 0"));
            this.bulletLabel = new JLabel();
            this.add(this.bulletLabel);
            if (BaseEditorPane.this.useOperatorColumn()) {
                this.operatorButton = new OperatorButton();
                this.add((Component)this.operatorButton, "h 17!, w 21!, aligny top, gaptop 1, gapafter 4");
            }
            this.nameLabel = new JLabel();
            this.add((Component)this.nameLabel, "growx, pushx");
        }

        public OperatorButton getOperatorButton() {
            return this.operatorButton;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width + Toolkit.getDefaultToolkit().getScreenSize().width, size.height);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (row >= 0 && value instanceof FilterTransformerTreeTableNode) {
                FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)((Object)value);
                if (node.getElement() instanceof IteratorElement) {
                    this.bulletLabel.setIcon(UIConstants.ICON_BULLET_YELLOW);
                } else {
                    this.bulletLabel.setIcon(UIConstants.ICON_BULLET_GREEN);
                }
                this.nameLabel.setText(node.getElement().getName());
                if (selected) {
                    this.setBackground(BaseEditorPane.this.treeTable.getSelectionBackground());
                } else if (row % 2 == 0) {
                    this.setBackground(UIConstants.HIGHLIGHTER_COLOR);
                } else {
                    this.setBackground(BaseEditorPane.this.treeTable.getBackground());
                }
                this.nameLabel.setBackground(this.getBackground());
                if (BaseEditorPane.this.useOperatorColumn()) {
                    Rule.Operator operator = (Rule.Operator)BaseEditorPane.this.getOperator(node.getElement());
                    this.operatorButton.setIcon(operator != null ? (operator == Rule.Operator.AND ? UIConstants.ICON_AND : UIConstants.ICON_OR) : null);
                    this.operatorButton.setBackground(this.getBackground());
                }
            }
            return this;
        }
    }

    protected static class OperatorNamePair
    extends MutablePair<Rule.Operator, String> {
        public OperatorNamePair(String name) {
            this(null, name);
        }

        public OperatorNamePair(Rule.Operator operator, String name) {
            super((Object)operator, (Object)name);
        }

        public Rule.Operator getOperator() {
            return (Rule.Operator)this.getLeft();
        }

        public String getName() {
            return (String)this.getRight();
        }
    }

    private class OperatorButton
    extends JButton {
        public OperatorButton() {
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setMaximumSize(new Dimension(21, 17));
            this.setMinimumSize(new Dimension(21, 17));
            this.setPreferredSize(new Dimension(21, 17));
        }
    }
}

