/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.ByteAbbreviationList;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameModeProperties;
import com.mirth.connect.util.TcpUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class BasicModeSettingsDialog
extends MirthDialog
implements DocumentListener {
    private boolean saved;
    private String startOfMessageAbbreviation;
    private String endOfMessageAbbreviation;
    private ActionListener actionListener;
    private ByteAbbreviationList byteAbbreviationList1;
    private JButton cancelButton;
    private JLabel endOfMessageBytes0XLabel;
    private JLabel endOfMessageBytesAbbrevLabel;
    private MirthTextField endOfMessageBytesField;
    private JLabel endOfMessageBytesLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JButton okButton;
    private JLabel startOfMessageBytes0XLabel;
    private JLabel startOfMessageBytesAbbrevLabel;
    private MirthTextField startOfMessageBytesField;
    private JLabel startOfMessageBytesLabel;
    private ButtonGroup useMLLPv2ButtonGroup;

    public BasicModeSettingsDialog(ActionListener actionListener) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.initComponents();
        this.actionListener = actionListener;
        this.startOfMessageBytesField.setDocument(new MirthFieldConstraints(0, true, false, false));
        this.endOfMessageBytesField.setDocument(new MirthFieldConstraints(0, true, false, false));
        this.startOfMessageBytesField.getDocument().addDocumentListener(this);
        this.endOfMessageBytesField.getDocument().addDocumentListener(this);
        this.startOfMessageAbbreviation = "";
        this.endOfMessageAbbreviation = "";
        this.changeAbbreviation();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Dimension dlgSize = this.getPreferredSize();
            Dimension frmSize = this.getParent().getSize();
            Point loc = this.getParent().getLocation();
            if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
                this.setLocationRelativeTo(null);
            } else {
                this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            }
            this.saved = false;
            this.resetInvalidProperties();
        }
        super.setVisible(b);
    }

    public TransmissionModeProperties getProperties() {
        FrameModeProperties props = new FrameModeProperties();
        props.setStartOfMessageBytes(this.startOfMessageBytesField.getText());
        props.setEndOfMessageBytes(this.endOfMessageBytesField.getText());
        return props;
    }

    public void setProperties(TransmissionModeProperties properties) {
        FrameModeProperties props = (FrameModeProperties)properties;
        this.startOfMessageBytesField.setText(props.getStartOfMessageBytes());
        this.endOfMessageBytesField.setText(props.getEndOfMessageBytes());
        this.startOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.startOfMessageBytesField.getText());
        this.endOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.endOfMessageBytesField.getText());
    }

    public String checkProperties() {
        this.resetInvalidProperties();
        Object errors = "";
        if (!TcpUtil.isValidHexString((String)this.startOfMessageBytesField.getText())) {
            errors = (String)errors + "Invalid start of message bytes.\r\n";
            this.startOfMessageBytesField.setBackground(UIConstants.INVALID_COLOR);
        }
        if (!TcpUtil.isValidHexString((String)this.endOfMessageBytesField.getText())) {
            errors = (String)errors + "Invalid end of message bytes.\r\n";
            this.endOfMessageBytesField.setBackground(UIConstants.INVALID_COLOR);
        }
        return errors;
    }

    public void resetInvalidProperties() {
        this.startOfMessageBytesField.setBackground(null);
        this.endOfMessageBytesField.setBackground(null);
    }

    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.changeAbbreviation(evt);
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.changeAbbreviation(evt);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.changeAbbreviation(evt);
    }

    private void changeAbbreviation(DocumentEvent evt) {
        String text = "";
        try {
            text = evt.getDocument().getText(0, evt.getDocument().getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (evt.getDocument().equals(this.startOfMessageBytesField.getDocument())) {
            this.startOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)text);
            this.actionListener.actionPerformed(new ActionEvent(this.startOfMessageBytesField, 1001, "changeStartBytes"));
        } else if (evt.getDocument().equals(this.endOfMessageBytesField.getDocument())) {
            this.endOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)text);
            this.actionListener.actionPerformed(new ActionEvent(this.endOfMessageBytesField, 1001, "changeEndBytes"));
        }
        this.changeAbbreviation();
    }

    private void changeAbbreviation() {
        this.startOfMessageBytesAbbrevLabel.setText(this.startOfMessageAbbreviation);
        this.endOfMessageBytesAbbrevLabel.setText(this.endOfMessageAbbreviation);
        this.pack();
    }

    private void initComponents() {
        this.useMLLPv2ButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.startOfMessageBytesAbbrevLabel = new JLabel();
        this.startOfMessageBytesLabel = new JLabel();
        this.endOfMessageBytesLabel = new JLabel();
        this.startOfMessageBytesField = new MirthTextField();
        this.startOfMessageBytes0XLabel = new JLabel();
        this.endOfMessageBytesAbbrevLabel = new JLabel();
        this.endOfMessageBytesField = new MirthTextField();
        this.endOfMessageBytes0XLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.byteAbbreviationList1 = new ByteAbbreviationList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Transmission Mode Settings");
        this.setModal(true);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Basic Settings"));
        this.jPanel2.setMinimumSize(new Dimension(323, 0));
        this.startOfMessageBytesAbbrevLabel.setText("<VT>");
        this.startOfMessageBytesAbbrevLabel.setToolTipText("<html>The bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytesLabel.setText("Start of Message Bytes:");
        this.startOfMessageBytesLabel.setToolTipText("<html>The bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesLabel.setText("End of Message Bytes:");
        this.endOfMessageBytesLabel.setToolTipText("<html>The bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytesField.setToolTipText("<html>The bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.startOfMessageBytesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicModeSettingsDialog.this.startOfMessageBytesFieldActionPerformed(evt);
            }
        });
        this.startOfMessageBytes0XLabel.setText("0x");
        this.startOfMessageBytes0XLabel.setToolTipText("<html>The bytes before the beginning of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesAbbrevLabel.setText("<FS><CR>");
        this.endOfMessageBytesAbbrevLabel.setToolTipText("<html>The bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesField.setToolTipText("<html>The bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        this.endOfMessageBytesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicModeSettingsDialog.this.endOfMessageBytesFieldActionPerformed(evt);
            }
        });
        this.endOfMessageBytes0XLabel.setText("0x");
        this.endOfMessageBytes0XLabel.setToolTipText("<html>The bytes after the end of the actual message.<br/>Only valid hexidecimal characters (0-9, A-F) are allowed.</html>");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startOfMessageBytesLabel, GroupLayout.Alignment.TRAILING).addComponent(this.endOfMessageBytesLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.startOfMessageBytes0XLabel).addGap(3, 3, 3).addComponent(this.startOfMessageBytesField, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startOfMessageBytesAbbrevLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.endOfMessageBytes0XLabel).addGap(3, 3, 3).addComponent(this.endOfMessageBytesField, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endOfMessageBytesAbbrevLabel, -1, 74, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startOfMessageBytesLabel).addComponent(this.startOfMessageBytes0XLabel).addComponent(this.startOfMessageBytesField, -2, -1, -2).addComponent(this.startOfMessageBytesAbbrevLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endOfMessageBytesLabel).addComponent(this.endOfMessageBytes0XLabel).addComponent(this.endOfMessageBytesField, -2, -1, -2).addComponent(this.endOfMessageBytesAbbrevLabel)).addContainerGap(117, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicModeSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicModeSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byteAbbreviationList1, -2, 125, -2))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.byteAbbreviationList1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void startOfMessageBytesFieldActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String errors = this.checkProperties();
        if (!errors.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Error validating transmission mode settings.\r\n\r\n" + errors, "Validation Error", 0);
        } else {
            this.saved = true;
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            this.dispose();
        }
    }

    private void endOfMessageBytesFieldActionPerformed(ActionEvent evt) {
    }
}

