/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.FilterTransformerElement;
import com.mirth.connect.model.IteratorElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public abstract class IteratorPanel<C extends FilterTransformerElement>
extends EditorPanel<C> {
    private ActionListener nameActionListener;
    private JLabel targetLabel;
    private JTextField targetField;
    private JLabel indexVariableLabel;
    private JTextField indexVariableField;
    private JLabel prefixSubstitutionsLabel;
    private MirthTable prefixSubstitutionsTable;
    private JScrollPane prefixSubstitutionsScrollPane;
    private JButton prefixSubstitutionsNewButton;
    private JButton prefixSubstitutionsDeleteButton;

    public IteratorPanel() {
        this.baseInitComponents();
        this.initToolTips();
        this.initLayout();
    }

    protected abstract IteratorElement<C> newIteratorElement();

    protected abstract String getName(String var1);

    public abstract void setName(IteratorElement<C> var1);

    protected abstract void initComponents();

    protected abstract void addMiddleComponents();

    @Override
    public C getProperties() {
        IteratorElement<C> props = this.newIteratorElement();
        props.getProperties().setTarget(this.targetField.getText());
        props.getProperties().setIndexVariable(this.indexVariableField.getText());
        ArrayList<String> prefixSubstitutions = new ArrayList<String>();
        for (int i = 0; i < this.prefixSubstitutionsTable.getModel().getRowCount(); ++i) {
            String prefix = (String)this.prefixSubstitutionsTable.getModel().getValueAt(i, 0);
            if (!StringUtils.isNotBlank((CharSequence)prefix)) continue;
            prefixSubstitutions.add(prefix);
        }
        props.getProperties().setPrefixSubstitutions(prefixSubstitutions);
        return (C)((FilterTransformerElement)props);
    }

    @Override
    public void setProperties(C properties) {
        IteratorElement props = (IteratorElement)properties;
        this.targetField.setText(props.getProperties().getTarget());
        this.indexVariableField.setText(props.getProperties().getIndexVariable());
        Object[][] data = new Object[props.getProperties().getPrefixSubstitutions().size()][1];
        int i = 0;
        for (String prefix : props.getProperties().getPrefixSubstitutions()) {
            data[i][0] = prefix;
            ++i;
        }
        ((RefreshTableModel)this.prefixSubstitutionsTable.getModel()).refreshDataVector(data);
        this.deselectRows();
    }

    @Override
    public String checkProperties(C properties, boolean highlight) {
        IteratorElement props = (IteratorElement)properties;
        Object errors = "";
        if (StringUtils.isBlank((CharSequence)props.getProperties().getTarget())) {
            errors = (String)errors + "The iteration target expression cannot be blank.\n";
            if (highlight) {
                this.targetField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getProperties().getIndexVariable())) {
            errors = (String)errors + "The iteration index variable cannot be blank.\n";
            if (highlight) {
                this.indexVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    @Override
    public void resetInvalidProperties() {
        this.targetField.setBackground(null);
        this.indexVariableField.setBackground(null);
    }

    @Override
    public void setNameActionListener(ActionListener actionListener) {
        this.nameActionListener = actionListener;
    }

    @Override
    public void stopEditing() {
        if (this.prefixSubstitutionsTable.isEditing()) {
            this.prefixSubstitutionsTable.getCellEditor(this.prefixSubstitutionsTable.getEditingRow(), this.prefixSubstitutionsTable.getEditingColumn()).stopCellEditing();
        }
    }

    protected void updateName() {
        this.updateName(this.targetField.getText());
    }

    protected void updateName(String target) {
        String name = this.getName((String)StringUtils.defaultIfBlank((CharSequence)target, (CharSequence)"..."));
        if (this.nameActionListener != null) {
            this.nameActionListener.actionPerformed(new ActionEvent(this, 1001, name));
        }
    }

    private void baseInitComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.targetLabel = new JLabel("Iterate On:");
        this.targetField = new JTextField();
        this.targetField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            private void documentChanged(DocumentEvent evt) {
                try {
                    IteratorPanel.this.updateName(evt.getDocument().getText(0, evt.getDocument().getLength()));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.indexVariableLabel = new JLabel("Index Variable:");
        this.indexVariableField = new JTextField();
        this.prefixSubstitutionsLabel = new JLabel("Drag-and-Drop Substitutions:");
        this.prefixSubstitutionsTable = new MirthTable();
        this.prefixSubstitutionsTable.setModel(new RefreshTableModel(new String[]{"Substitution Prefix"}, 0));
        this.prefixSubstitutionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (IteratorPanel.this.getSelectedRow() != -1) {
                    IteratorPanel.this.prefixSubstitutionsDeleteButton.setEnabled(true);
                } else {
                    IteratorPanel.this.prefixSubstitutionsDeleteButton.setEnabled(false);
                }
            }
        });
        this.prefixSubstitutionsTable.setSelectionMode(0);
        this.prefixSubstitutionsTable.setRowSelectionAllowed(true);
        this.prefixSubstitutionsTable.setRowHeight(20);
        this.prefixSubstitutionsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.prefixSubstitutionsTable.setDragEnabled(false);
        this.prefixSubstitutionsTable.setOpaque(true);
        this.prefixSubstitutionsTable.setSortable(false);
        this.prefixSubstitutionsTable.setEditable(true);
        this.prefixSubstitutionsTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.prefixSubstitutionsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.prefixSubstitutionsScrollPane = new JScrollPane((Component)((Object)this.prefixSubstitutionsTable));
        this.prefixSubstitutionsScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IteratorPanel.this.deselectRows();
            }
        });
        this.prefixSubstitutionsNewButton = new JButton("New");
        this.prefixSubstitutionsNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((DefaultTableModel)IteratorPanel.this.prefixSubstitutionsTable.getModel()).addRow(new Object[]{""});
                IteratorPanel.this.prefixSubstitutionsTable.setRowSelectionInterval(IteratorPanel.this.prefixSubstitutionsTable.getRowCount() - 1, IteratorPanel.this.prefixSubstitutionsTable.getRowCount() - 1);
            }
        });
        this.prefixSubstitutionsDeleteButton = new JButton("Delete");
        this.prefixSubstitutionsDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedRow = IteratorPanel.this.getSelectedRow();
                if (selectedRow != -1 && !IteratorPanel.this.prefixSubstitutionsTable.isEditing()) {
                    ((RefreshTableModel)IteratorPanel.this.prefixSubstitutionsTable.getModel()).removeRow(IteratorPanel.this.prefixSubstitutionsTable.convertRowIndexToModel(selectedRow));
                    if (IteratorPanel.this.prefixSubstitutionsTable.getRowCount() > 0) {
                        if (selectedRow < IteratorPanel.this.prefixSubstitutionsTable.getRowCount()) {
                            IteratorPanel.this.prefixSubstitutionsTable.setRowSelectionInterval(selectedRow, selectedRow);
                        } else {
                            IteratorPanel.this.prefixSubstitutionsTable.setRowSelectionInterval(IteratorPanel.this.prefixSubstitutionsTable.getRowCount() - 1, IteratorPanel.this.prefixSubstitutionsTable.getRowCount() - 1);
                        }
                    }
                }
            }
        });
        this.prefixSubstitutionsDeleteButton.setEnabled(false);
        this.initComponents();
    }

    private void initToolTips() {
        this.targetField.setToolTipText("<html>Specify the element to iterate on.<br/>This may be a list of E4X XML nodes,<br/>or a Java / JavaScript array.</html>");
        this.indexVariableField.setToolTipText("Set the index variable to use for each iteration.");
        this.prefixSubstitutionsTable.setToolTipText("<html>When drag-and-dropping values into the<br/>children underneath this iterator, the<br/>index variable (e.g. \"[i]\") will be<br/>injected after any of these prefixes.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, gap 6"));
        this.add((Component)this.targetLabel, "right, gapafter 6");
        this.add((Component)this.targetField, "growx, sx");
        this.add((Component)this.indexVariableLabel, "newline, right, gapafter 6");
        this.add((Component)this.indexVariableField, "sx, growx");
        this.addMiddleComponents();
        this.add((Component)this.prefixSubstitutionsLabel, "newline, top, right, gapafter 6");
        this.add((Component)this.prefixSubstitutionsScrollPane, "grow, push, sy");
        this.add((Component)this.prefixSubstitutionsNewButton, "top, flowy, split 2, sgx");
        this.add((Component)this.prefixSubstitutionsDeleteButton, "top, sgx");
    }

    private void deselectRows() {
        this.prefixSubstitutionsTable.clearSelection();
        this.prefixSubstitutionsDeleteButton.setEnabled(false);
    }

    private int getSelectedRow() {
        if (this.prefixSubstitutionsTable.isEditing()) {
            return this.prefixSubstitutionsTable.getEditingRow();
        }
        return this.prefixSubstitutionsTable.getSelectedRow();
    }
}

