/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.editors.FilterTransformerTreeTableNode;
import com.mirth.connect.model.FilterTransformer;
import com.mirth.connect.model.FilterTransformerElement;
import com.mirth.connect.model.IteratorElement;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class IteratorUtil {
    public static <T extends FilterTransformer<C>, C extends FilterTransformerElement> String replaceOrRemoveIteratorVariables(String expression, TreeTableNode parent, boolean replace) {
        if (replace) {
            return IteratorUtil.replaceIteratorVariables(expression, parent);
        }
        return IteratorUtil.removeIteratorVariables(expression, parent);
    }

    public static String replaceIteratorVariables(String expression, MirthTreeTable treeTable) {
        TreePath path;
        int selectedRow;
        if (StringUtils.isNotBlank((CharSequence)expression) && (selectedRow = treeTable.getSelectedRow()) >= 0 && (path = treeTable.getPathForRow(selectedRow)) != null) {
            return IteratorUtil.replaceIteratorVariables(expression, ((TreeTableNode)path.getLastPathComponent()).getParent());
        }
        return expression;
    }

    public static <T extends FilterTransformer<C>, C extends FilterTransformerElement> String replaceIteratorVariables(String expression, TreeTableNode parent) {
        if (StringUtils.isNotBlank((CharSequence)expression) && parent instanceof FilterTransformerTreeTableNode) {
            FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)parent;
            String replaced = IteratorUtil.replaceIteratorVariables(expression, node.getParent());
            if (node.getElement() instanceof IteratorElement) {
                replaced = IteratorUtil.replaceIteratorVariables(replaced, (IteratorElement)node.getElement());
            }
            return replaced;
        }
        return expression;
    }

    public static <C extends FilterTransformerElement> String replaceIteratorVariables(String expression, IteratorElement<C> element) {
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            for (String prefix : element.getProperties().getPrefixSubstitutions()) {
                String indexVariable = "[" + element.getProperties().getIndexVariable() + "]";
                if (!StringUtils.startsWith((CharSequence)expression, (CharSequence)prefix) || StringUtils.startsWith((CharSequence)expression, (CharSequence)(prefix + indexVariable))) continue;
                Object suffix = "msg" + StringUtils.removeStart((String)expression, (String)prefix);
                suffix = JavaScriptSharedUtil.removeNumberLiterals((String)suffix);
                suffix = StringUtils.removeStart((String)suffix, (String)"msg");
                expression = prefix + indexVariable + (String)suffix;
            }
        }
        return expression;
    }

    public static <T extends FilterTransformer<C>, C extends FilterTransformerElement> String removeIteratorVariables(String expression, TreeTableNode parent) {
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            while (parent != null && parent instanceof FilterTransformerTreeTableNode) {
                FilterTransformerTreeTableNode parentIterator = (FilterTransformerTreeTableNode)parent;
                if (parentIterator.isIteratorNode()) {
                    IteratorElement iterator = (IteratorElement)parentIterator.getElement();
                    String indexVariable = "[" + iterator.getProperties().getIndexVariable() + "]";
                    for (String prefix : iterator.getProperties().getPrefixSubstitutions()) {
                        if (!StringUtils.startsWith((CharSequence)expression, (CharSequence)(prefix + indexVariable))) continue;
                        expression = prefix + StringUtils.removeStart((String)expression, (String)(prefix + indexVariable));
                    }
                }
                parent = parent.getParent();
            }
        }
        return expression;
    }

    public static List<String> getAncestorIndexVariables(TreeTableNode parent) {
        ArrayList<String> list = new ArrayList<String>();
        IteratorUtil.getAncestorIndexVariables(parent, list);
        return list;
    }

    private static <T extends FilterTransformer<C>, C extends FilterTransformerElement> void getAncestorIndexVariables(TreeTableNode parent, List<String> list) {
        if (parent != null && parent instanceof FilterTransformerTreeTableNode) {
            FilterTransformerTreeTableNode node = (FilterTransformerTreeTableNode)parent;
            IteratorUtil.getAncestorIndexVariables(node.getParent(), list);
            if (node.getElement() instanceof IteratorElement) {
                list.add(((IteratorElement)node.getElement()).getProperties().getIndexVariable());
            }
        }
    }

    public static List<String> getDescendantIndexVariables(TreeTableNode node) {
        ArrayList<String> list = new ArrayList<String>();
        IteratorUtil.getDescendantIndexVariables(node, list);
        return list;
    }

    private static <T extends FilterTransformer<C>, C extends FilterTransformerElement> void getDescendantIndexVariables(TreeTableNode parent, List<String> list) {
        FilterTransformerTreeTableNode node;
        if (parent != null && parent instanceof FilterTransformerTreeTableNode && (node = (FilterTransformerTreeTableNode)parent).getElement() instanceof IteratorElement) {
            list.add(((IteratorElement)node.getElement()).getProperties().getIndexVariable());
            Enumeration en = node.children();
            while (en.hasMoreElements()) {
                IteratorUtil.getDescendantIndexVariables((TreeTableNode)en.nextElement(), list);
            }
        }
    }

    public static String getValidIndexVariable(TreeTableNode parent, TreeTableNode node) {
        return IteratorUtil.getValidIndexVariable(IteratorUtil.getAncestorIndexVariables(parent), IteratorUtil.getDescendantIndexVariables(node));
    }

    public static String getValidIndexVariable(List<String> ancestorIndexVariables, List<String> descendantIndexVariables) {
        String indexVariable = "i";
        while (ancestorIndexVariables.contains(indexVariable) || descendantIndexVariables.contains(indexVariable)) {
            char ch = indexVariable.charAt(0);
            int len = indexVariable.length();
            if ((ch = (char)(ch + '\u0001')) > 'z') {
                ch = 'i';
                ++len;
            }
            indexVariable = StringUtils.repeat((char)ch, (int)len);
        }
        return indexVariable;
    }
}

