/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.editors.EditorConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class LineNumber
extends JComponent {
    private static final int HEIGHT = 2146483647;
    private static final int WIDTH = 999;
    private static final int MARGIN = 5;
    private int lineHeight;
    private int fontLineHeight;
    private int currentRowWidth;
    private FontMetrics fontMetrics;

    public LineNumber(JComponent component) {
        this.setBackground(EditorConstants.PANEL_BACKGROUND);
        this.setForeground(EditorConstants.LINENUMBER_FOREGROUND);
        this.setFont(EditorConstants.DEFAULT_FONT);
        this.setPreferredSize(999);
    }

    public void setPreferredSize(int row) {
        int width = this.fontMetrics.stringWidth(String.valueOf(row));
        if (this.currentRowWidth < width) {
            this.currentRowWidth = width;
            this.setPreferredSize(new Dimension(10 + width, 2146483647));
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.fontLineHeight = this.fontMetrics.getHeight();
    }

    public int getLineHeight() {
        if (this.lineHeight == 0) {
            return this.fontLineHeight;
        }
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        if (lineHeight > 0) {
            this.lineHeight = lineHeight;
        }
    }

    public int getStartOffset() {
        return 4;
    }

    @Override
    public void paintComponent(Graphics g) {
        int lineHeight = this.getLineHeight();
        int startOffset = this.getStartOffset();
        Rectangle drawHere = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setColor(this.getForeground());
        int startLineNumber = drawHere.y / lineHeight + 1;
        int endLineNumber = startLineNumber + (drawHere.height - 17) / lineHeight;
        int start = drawHere.y / lineHeight * lineHeight + lineHeight - startOffset + 1;
        for (int i = startLineNumber; i <= endLineNumber; ++i) {
            String lineNumber = String.valueOf(i);
            int width = this.fontMetrics.stringWidth(lineNumber);
            g.drawString(lineNumber, 5 + this.currentRowWidth - width, start);
            start += lineHeight;
        }
        this.setPreferredSize(endLineNumber);
    }
}

