/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.TreePanel;
import com.mirth.connect.client.ui.editors.BaseEditorPane;
import java.awt.Color;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;

public class MessageTreePanel
extends JPanel {
    public static final String MAPPER_PREFIX = "msg";
    public static final String MAPPER_SUFFIX = ".toString()";
    public static final String MESSAGE_BUILDER_PREFIX = "tmp";
    public static final String MESSAGE_BUILDER_SUFFIX = "";
    private BaseEditorPane<?, ?> editorPane;
    private JSplitPane split;
    private TreePanel treePanelInbound;
    private TreePanel treePanelOutbound;
    private JScrollPane treeScrollPaneInbound;
    private JScrollPane treeScrollPaneOutbound;

    public MessageTreePanel(BaseEditorPane<?, ?> editorPane) {
        this.editorPane = editorPane;
        this.initComponents();
        ((TitledBorder)this.treePanelInbound.getBorder()).setTitle("Inbound Message Template Tree");
        ((TitledBorder)this.treePanelOutbound.getBorder()).setTitle("Outbound Message Template Tree");
        this.treePanelInbound.setPrefix(MAPPER_PREFIX);
        this.treePanelInbound.setSuffix(MAPPER_SUFFIX);
        this.treePanelInbound.setupPopupMenu();
        this.treePanelOutbound.setPrefix(MESSAGE_BUILDER_PREFIX);
        this.treePanelOutbound.setSuffix(MESSAGE_BUILDER_SUFFIX);
        this.treePanelOutbound.setupPopupMenu();
        try {
            this.split.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        MessageTreePanel.this.split.setDividerLocation(0.5);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.split.setOneTouchExpandable(true);
    }

    public void hideOutbound() {
        this.split.setBottomComponent(null);
        this.split.setDividerSize(0);
        this.split.setOneTouchExpandable(false);
    }

    public void showOutbound() {
        this.split.setBottomComponent(this.treePanelOutbound);
        this.split.setDividerSize(6);
        this.split.setDividerLocation(0.5);
        this.split.setResizeWeight(0.5);
        this.split.setOneTouchExpandable(true);
    }

    public TreePanel getInboundTreePanel() {
        return this.treePanelInbound;
    }

    public TreePanel getOutboundTreePanel() {
        return this.treePanelOutbound;
    }

    public void clearInboundTree() {
        this.treePanelInbound.clearMessage();
    }

    public void clearOutboundTree() {
        this.treePanelOutbound.clearMessage();
    }

    public void resizePanes() {
        this.split.setResizeWeight(0.5);
        this.split.setDividerLocation(0.5);
    }

    private void initComponents() {
        this.split = new JSplitPane();
        this.treeScrollPaneOutbound = new JScrollPane();
        this.treePanelOutbound = new TreePanel(this.editorPane);
        this.treeScrollPaneInbound = new JScrollPane();
        this.treePanelInbound = new TreePanel(this.editorPane);
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.split.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.split.setOrientation(0);
        this.treeScrollPaneOutbound.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.treeScrollPaneOutbound.setVerticalScrollBarPolicy(21);
        this.treeScrollPaneOutbound.setViewportView(this.treePanelOutbound);
        this.split.setRightComponent(this.treeScrollPaneOutbound);
        this.treeScrollPaneInbound.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.treeScrollPaneInbound.setVerticalScrollBarPolicy(21);
        this.treeScrollPaneInbound.setViewportView(this.treePanelInbound);
        this.split.setLeftComponent(this.treeScrollPaneInbound);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.split, GroupLayout.Alignment.TRAILING, -1, 253, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.split, GroupLayout.Alignment.TRAILING, -1, 451, Short.MAX_VALUE));
    }
}

