/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors.transformer;

import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.MapperDropData;
import com.mirth.connect.client.ui.MessageBuilderDropData;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TreeTransferable;
import com.mirth.connect.client.ui.components.MirthTree;
import com.mirth.connect.client.ui.editors.BaseEditorPane;
import com.mirth.connect.client.ui.editors.TransformerTreeTableNode;
import com.mirth.connect.client.ui.util.VariableListUtil;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.IteratorStep;
import com.mirth.connect.model.Step;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.plugins.FilterTransformerTypePlugin;
import com.mirth.connect.plugins.IteratorStepPlugin;
import com.mirth.connect.plugins.TransformerStepPlugin;
import com.mirth.connect.util.StringUtil;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class TransformerPane
extends BaseEditorPane<Transformer, Step> {
    public static final String MAPPER = "Mapper";
    public static final String MESSAGE_BUILDER = "Message Builder";
    private Map<String, FilterTransformerTypePlugin<Transformer, Step>> sourcePlugins;
    private Map<String, FilterTransformerTypePlugin<Transformer, Step>> destinationPlugins;
    private IteratorStepPlugin iteratorPlugin;

    @Override
    protected Class<?> getContainerClass() {
        return Transformer.class;
    }

    @Override
    protected String getContainerName() {
        return "Transformer";
    }

    @Override
    protected String getElementName() {
        return "Step";
    }

    @Override
    protected void updateTable() {
    }

    @Override
    protected boolean useOperatorColumn() {
        return false;
    }

    @Override
    protected Object getOperator(Step element) {
        return null;
    }

    @Override
    protected void setOperator(Step element, Object value) {
    }

    @Override
    protected Map<String, FilterTransformerTypePlugin<Transformer, Step>> getPlugins() {
        if (this.sourcePlugins == null || this.destinationPlugins == null) {
            this.sourcePlugins = new TreeMap<String, FilterTransformerTypePlugin<Transformer, Step>>();
            this.destinationPlugins = new TreeMap<String, FilterTransformerTypePlugin<Transformer, Step>>();
            for (Map.Entry<String, TransformerStepPlugin> entry : LoadedExtensions.getInstance().getTransformerStepPlugins().entrySet()) {
                this.sourcePlugins.put(entry.getKey(), entry.getValue());
                if (entry.getValue().onlySourceConnector()) continue;
                this.destinationPlugins.put(entry.getKey(), entry.getValue());
            }
            if (this.iteratorPlugin == null) {
                this.iteratorPlugin = new IteratorStepPlugin("Iterator");
            }
            this.sourcePlugins.put(this.iteratorPlugin.getPluginPointName(), this.iteratorPlugin);
            this.destinationPlugins.put(this.iteratorPlugin.getPluginPointName(), this.iteratorPlugin);
        }
        if (this.getConnector() != null && this.getConnector().getMetaDataId() == 0) {
            return this.sourcePlugins;
        }
        return this.destinationPlugins;
    }

    protected TransformerTreeTableNode createTreeTableNode(Step element) {
        TransformerTreeTableNode node = new TransformerTreeTableNode(this, element);
        if (element instanceof IteratorStep) {
            for (Step child : ((IteratorStep)element).getProperties().getChildren()) {
                node.add((MutableTreeTableNode)this.createTreeTableNode(child));
            }
        }
        return node;
    }

    @Override
    protected void doAccept(Connector connector, Transformer properties, boolean response) {
        if (response) {
            connector.setResponseTransformer(properties);
        } else {
            connector.setTransformer(properties);
            if (connector.getMetaDataId() == 0) {
                String sourceDataType = properties.getOutboundDataType();
                for (Connector destinationConnector : PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getDestinationConnectors()) {
                    String destinationDataType = destinationConnector.getTransformer().getInboundDataType();
                    if (StringUtils.equals((CharSequence)sourceDataType, (CharSequence)destinationDataType)) continue;
                    destinationConnector.getTransformer().setInboundDataType(sourceDataType);
                    destinationConnector.getTransformer().setInboundProperties(LoadedExtensions.getInstance().getDataTypePlugins().get(sourceDataType).getDefaultProperties());
                }
            }
        }
    }

    @Override
    public Transformer getProperties() {
        Transformer props = new Transformer();
        props.setElements(this.getElements());
        props.setInboundTemplate(this.getInboundTemplate());
        props.setOutboundTemplate(this.getOutboundTemplate());
        props.setInboundDataType(this.getInboundDataType());
        props.setOutboundDataType(this.getOutboundDataType());
        props.setInboundProperties(this.getInboundDataTypeProperties());
        props.setOutboundProperties(this.getOutboundDataTypeProperties());
        return props;
    }

    @Override
    public void doSetProperties(Connector connector, Transformer properties, boolean response, boolean overwriteOriginal) {
        this.setElements(properties.getElements());
        this.setInboundDataType(properties.getInboundDataType());
        this.setOutboundDataType(properties.getOutboundDataType());
        this.setInboundDataTypeProperties(properties.getInboundProperties());
        this.setOutboundDataTypeProperties(properties.getOutboundProperties());
        this.setInboundTemplate(properties.getInboundTemplate());
        this.setOutboundTemplate(properties.getOutboundTemplate());
        this.templatePanel.setTransformerView();
        if (connector.getMetaDataId() == 0) {
            PlatformUI.MIRTH_FRAME.channelEditPanel.updateAttachmentHandler(properties.getInboundDataType());
        }
    }

    @Override
    public void addNewElement() {
        this.addNewElement("", "", "", MAPPER);
    }

    @Override
    protected void getRuleVariables(Connector connector, Set<String> concatenatedRules, boolean includeLocalVars) {
        VariableListUtil.getRuleVariables(concatenatedRules, connector.getFilter(), includeLocalVars);
    }

    @Override
    protected void getStepVariables(Connector connector, Set<String> concatenatedSteps, boolean includeLocalVars, int viewRow) {
        VariableListUtil.getStepVariables(concatenatedSteps, this.getProperties(), includeLocalVars, viewRow);
    }

    @Override
    protected boolean handleDragEnter(DropTargetDragEvent dtde, Transferable tr) throws UnsupportedFlavorException, IOException {
        if (tr.isDataFlavorSupported(TreeTransferable.MAPPER_DATA_FLAVOR) || tr.isDataFlavorSupported(TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR)) {
            dtde.acceptDrag(3);
            return true;
        }
        return false;
    }

    @Override
    protected void handleDrop(DropTargetDropEvent dtde, Transferable tr) throws UnsupportedFlavorException, IOException {
        if (tr.isDataFlavorSupported(TreeTransferable.MAPPER_DATA_FLAVOR) || tr.isDataFlavorSupported(TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR)) {
            dtde.acceptDrop(3);
            Object mapperTransferData = tr.getTransferData(TreeTransferable.MAPPER_DATA_FLAVOR);
            Object messageBuilderTransferData = tr.getTransferData(TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR);
            if (mapperTransferData != null && !PlatformUI.MIRTH_FRAME.isAcceleratorKeyPressed()) {
                Object transferData = tr.getTransferData(TreeTransferable.MAPPER_DATA_FLAVOR);
                MapperDropData data = (MapperDropData)transferData;
                this.addNewElement(data.getVariable(), data.getVariable(), data.getMapping(), MAPPER, true);
            } else if (mapperTransferData != null && PlatformUI.MIRTH_FRAME.isAcceleratorKeyPressed()) {
                Object transferData = tr.getTransferData(TreeTransferable.MAPPER_DATA_FLAVOR);
                MapperDropData data2 = (MapperDropData)transferData;
                MessageBuilderDropData data = new MessageBuilderDropData(data2.getNode(), MirthTree.constructPath(data2.getNode().getParent(), "msg", "").toString(), "");
                this.addNewElement(MirthTree.constructMessageBuilderStepName(null, data.getNode()), data.getMessageSegment(), data.getMapping(), MESSAGE_BUILDER, true);
            } else if (messageBuilderTransferData != null) {
                Object transferData = tr.getTransferData(TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR);
                MessageBuilderDropData data = (MessageBuilderDropData)transferData;
                this.addNewElement(MirthTree.constructMessageBuilderStepName(null, data.getNode()), data.getMessageSegment(), data.getMapping(), MESSAGE_BUILDER, true);
            }
        }
    }

    @Override
    protected boolean isModified(Transformer properties) {
        if (this.originalProperties == properties) {
            return false;
        }
        if (this.originalProperties == null || properties == null) {
            return true;
        }
        return !StringUtil.equalsIgnoreNull((String)((Transformer)this.originalProperties).getInboundDataType(), (String)properties.getInboundDataType()) || !StringUtil.equalsIgnoreNull((String)((Transformer)this.originalProperties).getOutboundDataType(), (String)properties.getOutboundDataType()) || !StringUtil.equalsIgnoreNull((String)((Transformer)this.originalProperties).getInboundTemplate(), (String)properties.getInboundTemplate()) || !StringUtil.equalsIgnoreNull((String)((Transformer)this.originalProperties).getOutboundTemplate(), (String)properties.getOutboundTemplate()) || !Objects.equals(((Transformer)this.originalProperties).getInboundProperties(), properties.getInboundProperties()) || !Objects.equals(((Transformer)this.originalProperties).getOutboundProperties(), properties.getOutboundProperties()) || !Objects.equals(((Transformer)this.originalProperties).getElements(), properties.getElements());
    }
}

