/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.extensionmanager;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.extensionmanager.ExtensionInfoDialog;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginMetaData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class ExtensionManagerPanel
extends JPanel {
    private final String PLUGIN_STATUS_COLUMN_NAME = "Status";
    private final String PLUGIN_NAME_COLUMN_NAME = "Name";
    private final String PLUGIN_AUTHOR_COLUMN_NAME = "Author";
    private final String PLUGIN_URL_COLUMN_NAME = "URL";
    private final String PLUGIN_VERSION_COLUMN_NAME = "Version";
    private final int PLUGIN_STATUS_COLUMN_NUMBER = 0;
    private final int PLUGIN_NAME_COLUMN_NUMBER = 1;
    private final int NUMBER_OF_COLUMNS = 5;
    private int lastConnectorRow = -1;
    private int lastPluginRow = -1;
    private final String ENABLED_STATUS = "Enabled";
    private Map<String, PluginMetaData> pluginData = null;
    private Map<String, ConnectorMetaData> connectorData = null;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private JButton browseButton;
    private JTextField fileText;
    private JButton installButton;
    private JPanel installExtensionPanel;
    private JLabel jLabel1;
    private JPanel loadedConnectorsPanel;
    private JScrollPane loadedConnectorsScrollPane;
    private MirthTable loadedConnectorsTable;
    private JPanel loadedPluginsPanel;
    private JScrollPane loadedPluginsScrollPane;
    private MirthTable loadedPluginsTable;
    private JLabel restartRequiredLabel;
    private JPanel restartRequiredPanel;

    public ExtensionManagerPanel() {
        this.initComponents();
        this.setRestartRequired(false);
        this.makeLoadedConnectorsTable();
        this.makeLoadedPluginsTable();
    }

    public MetaData getSelectedExtension() {
        int selectedRow;
        if (this.loadedConnectorsTable.getSelectedRowCount() > 0) {
            int selectedRow2 = this.loadedConnectorsTable.getSelectedRow();
            if (selectedRow2 != -1) {
                String extensionName = (String)this.loadedConnectorsTable.getModel().getValueAt(this.loadedConnectorsTable.convertRowIndexToModel(selectedRow2), 1);
                return (MetaData)this.connectorData.get(extensionName);
            }
        } else if (this.loadedPluginsTable.getSelectedRowCount() > 0 && (selectedRow = this.loadedPluginsTable.getSelectedRow()) != -1) {
            String extensionName = (String)this.loadedPluginsTable.getModel().getValueAt(this.loadedPluginsTable.convertRowIndexToModel(selectedRow), 1);
            return (MetaData)this.pluginData.get(extensionName);
        }
        return null;
    }

    public void setSelectedExtensionEnabled(boolean enabled) {
        int selectedRow;
        CellData enabledCellData = new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled");
        CellData disabledCellData = new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
        if (this.loadedConnectorsTable.getSelectedRowCount() > 0) {
            int selectedRow2 = this.loadedConnectorsTable.getSelectedRow();
            if (selectedRow2 != -1) {
                if (enabled) {
                    this.loadedConnectorsTable.getModel().setValueAt(enabledCellData, this.loadedConnectorsTable.convertRowIndexToModel(selectedRow2), 0);
                } else {
                    this.loadedConnectorsTable.getModel().setValueAt(disabledCellData, this.loadedConnectorsTable.convertRowIndexToModel(selectedRow2), 0);
                }
            }
        } else if (this.loadedPluginsTable.getSelectedRowCount() > 0 && (selectedRow = this.loadedPluginsTable.getSelectedRow()) != -1) {
            if (enabled) {
                this.loadedPluginsTable.getModel().setValueAt(enabledCellData, this.loadedPluginsTable.convertRowIndexToModel(selectedRow), 0);
            } else {
                this.loadedPluginsTable.getModel().setValueAt(disabledCellData, this.loadedPluginsTable.convertRowIndexToModel(selectedRow), 0);
            }
        }
        if (enabled) {
            this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, 1, false);
            this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 2, 2, true);
        } else {
            this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, 1, true);
            this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 2, 2, false);
        }
    }

    public void showExtensionProperties() {
        MetaData metaData = this.getSelectedExtension();
        if (metaData != null) {
            String type = "";
            if (metaData instanceof ConnectorMetaData) {
                type = "Connector";
            } else if (metaData instanceof PluginMetaData) {
                type = "Plugin";
            }
            String name = metaData.getName();
            String version = metaData.getPluginVersion();
            String author = metaData.getAuthor();
            String url = metaData.getUrl();
            String description = metaData.getDescription();
            new ExtensionInfoDialog(name, type, "Installed", author, version, url, description);
        }
    }

    public void makeLoadedConnectorsTable() {
        this.updateLoadedConnectorsTable();
        this.loadedConnectorsTable.setSelectionMode(0);
        this.loadedConnectorsTable.setDragEnabled(false);
        this.loadedConnectorsTable.setRowSelectionAllowed(true);
        this.loadedConnectorsTable.setRowHeight(20);
        this.loadedConnectorsTable.setOpaque(true);
        this.loadedConnectorsTable.getTableHeader().setReorderingAllowed(true);
        this.loadedConnectorsTable.setSortable(true);
        this.loadedConnectorsTable.getColumnExt("Version").setMaxWidth(150);
        this.loadedConnectorsTable.getColumnExt("Version").setPreferredWidth(100);
        this.loadedConnectorsTable.getColumnExt("Version").setMinWidth(75);
        this.loadedConnectorsTable.getColumnExt("Status").setMaxWidth(200);
        this.loadedConnectorsTable.getColumnExt("Status").setMinWidth(75);
        this.loadedConnectorsTable.getColumnExt("Status").setCellRenderer((TableCellRenderer)new ImageCellRenderer());
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.loadedConnectorsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.loadedConnectorsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ExtensionManagerPanel.this.ConnectorListSelected(evt);
            }
        });
        this.loadedConnectorsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ExtensionManagerPanel.this.checkConnectorSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ExtensionManagerPanel.this.checkConnectorSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ExtensionManagerPanel.this.showExtensionProperties();
                }
            }
        });
        this.loadedConnectorsTable.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ExtensionManagerPanel.this.loadedConnectorsScrollPane.getMouseWheelListeners()[0].mouseWheelMoved(e);
            }
        });
        this.loadedConnectorsScrollPane.setViewportView((Component)((Object)this.loadedConnectorsTable));
    }

    public void setConnectorData(Map<String, ConnectorMetaData> connectorData) {
        this.connectorData = connectorData;
        this.updateLoadedConnectorsTable();
    }

    public void updateLoadedConnectorsTable() {
        Object[][] tableData = null;
        int tableSize = 0;
        if (this.connectorData != null) {
            tableSize = this.connectorData.size();
            tableData = new Object[tableSize][5];
            int i = 0;
            for (ConnectorMetaData metaData : this.connectorData.values()) {
                boolean enabled = false;
                try {
                    enabled = this.parent.mirthClient.isExtensionEnabled(metaData.getName());
                }
                catch (ClientException clientException) {
                    // empty catch block
                }
                tableData[i][0] = enabled ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled") : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
                tableData[i][1] = metaData.getName();
                tableData[i][2] = metaData.getAuthor();
                tableData[i][3] = metaData.getUrl();
                tableData[i][4] = metaData.getPluginVersion();
                ++i;
            }
        }
        if (this.connectorData != null && this.loadedConnectorsTable != null) {
            this.lastConnectorRow = this.loadedConnectorsTable.getSelectedRow();
            RefreshTableModel model = (RefreshTableModel)this.loadedConnectorsTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.loadedConnectorsTable = new MirthTable();
            this.loadedConnectorsTable.setModel(new RefreshTableModel(tableData, new String[]{"Status", "Name", "Author", "URL", "Version"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false, false, false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (this.lastConnectorRow >= 0 && this.lastConnectorRow < this.loadedConnectorsTable.getRowCount()) {
            this.loadedConnectorsTable.setRowSelectionInterval(this.lastConnectorRow, this.lastConnectorRow);
        } else {
            this.lastConnectorRow = -1;
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.loadedConnectorsTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    private void ConnectorListSelected(ListSelectionEvent evt) {
        int row = this.loadedConnectorsTable.getSelectedRow();
        if (row >= 0 && row < this.loadedConnectorsTable.getRowCount()) {
            this.loadedPluginsTable.clearSelection();
            this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, -1, true);
            int columnNumber = this.loadedConnectorsTable.getColumnViewIndex("Status");
            if (((CellData)this.loadedConnectorsTable.getValueAt(row, columnNumber)).getText().equals("Enabled")) {
                this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, 1, false);
            } else {
                this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 2, 2, false);
            }
        }
    }

    private void checkConnectorSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.loadedConnectorsTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectConnectorRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.loadedConnectorsTable.setRowSelectionInterval(row, row);
            }
            this.parent.extensionsPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void deselectConnectorRows() {
        this.loadedConnectorsTable.clearSelection();
        this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, -1, false);
    }

    public void makeLoadedPluginsTable() {
        this.updateLoadedPluginsTable();
        this.loadedPluginsTable.setSelectionMode(0);
        this.loadedPluginsTable.setDragEnabled(false);
        this.loadedPluginsTable.setRowSelectionAllowed(true);
        this.loadedPluginsTable.setRowHeight(20);
        this.loadedPluginsTable.setOpaque(true);
        this.loadedPluginsTable.getTableHeader().setReorderingAllowed(true);
        this.loadedPluginsTable.setSortable(true);
        this.loadedPluginsTable.getColumnExt("Version").setMaxWidth(150);
        this.loadedPluginsTable.getColumnExt("Version").setPreferredWidth(100);
        this.loadedPluginsTable.getColumnExt("Version").setMinWidth(75);
        this.loadedPluginsTable.getColumnExt("Status").setMaxWidth(200);
        this.loadedPluginsTable.getColumnExt("Status").setMinWidth(75);
        this.loadedPluginsTable.getColumnExt("Status").setCellRenderer((TableCellRenderer)new ImageCellRenderer());
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.loadedPluginsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.loadedPluginsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ExtensionManagerPanel.this.PluginListSelected(evt);
            }
        });
        this.loadedPluginsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ExtensionManagerPanel.this.checkPluginSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ExtensionManagerPanel.this.checkPluginSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ExtensionManagerPanel.this.showExtensionProperties();
                }
            }
        });
        this.loadedPluginsTable.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ExtensionManagerPanel.this.loadedPluginsScrollPane.getMouseWheelListeners()[0].mouseWheelMoved(e);
            }
        });
        this.loadedPluginsScrollPane.setViewportView((Component)((Object)this.loadedPluginsTable));
    }

    public void setPluginData(Map<String, PluginMetaData> pluginData) {
        this.pluginData = pluginData;
        this.updateLoadedPluginsTable();
    }

    public void updateLoadedPluginsTable() {
        Object[][] tableData = null;
        int tableSize = 0;
        if (this.pluginData != null) {
            tableSize = this.pluginData.size();
            tableData = new Object[tableSize][5];
            int i = 0;
            for (PluginMetaData metaData : this.pluginData.values()) {
                boolean enabled = false;
                try {
                    enabled = this.parent.mirthClient.isExtensionEnabled(metaData.getName());
                }
                catch (ClientException clientException) {
                    // empty catch block
                }
                tableData[i][0] = enabled ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled") : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
                tableData[i][1] = metaData.getName();
                tableData[i][2] = metaData.getAuthor();
                tableData[i][3] = metaData.getUrl();
                tableData[i][4] = metaData.getPluginVersion();
                ++i;
            }
        }
        if (this.pluginData != null && this.loadedPluginsTable != null) {
            this.lastPluginRow = this.loadedPluginsTable.getSelectedRow();
            RefreshTableModel model = (RefreshTableModel)this.loadedPluginsTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.loadedPluginsTable = new MirthTable();
            this.loadedPluginsTable.setModel(new RefreshTableModel(tableData, new String[]{"Status", "Name", "Author", "URL", "Version"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false, false, false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (this.lastPluginRow >= 0 && this.lastPluginRow < this.loadedPluginsTable.getRowCount()) {
            this.loadedPluginsTable.setRowSelectionInterval(this.lastPluginRow, this.lastPluginRow);
        } else {
            this.lastPluginRow = -1;
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.loadedPluginsTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    private void PluginListSelected(ListSelectionEvent evt) {
        int row = this.loadedPluginsTable.getSelectedRow();
        if (row >= 0 && row < this.loadedPluginsTable.getRowCount()) {
            this.loadedConnectorsTable.clearSelection();
            this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, -1, true);
            int columnNumber = this.loadedPluginsTable.getColumnViewIndex("Status");
            if (((CellData)this.loadedPluginsTable.getValueAt(row, columnNumber)).getText().equals("Enabled")) {
                this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, 1, false);
            } else {
                this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 2, 2, false);
            }
        }
    }

    private void checkPluginSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.loadedPluginsTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectPluginRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.loadedPluginsTable.setRowSelectionInterval(row, row);
            }
            this.parent.extensionsPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void deselectPluginRows() {
        this.loadedPluginsTable.clearSelection();
        this.parent.setVisibleTasks(this.parent.extensionsTasks, this.parent.extensionsPopupMenu, 1, -1, false);
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequiredPanel.setVisible(restartRequired);
    }

    private void initComponents() {
        this.loadedPluginsPanel = new JPanel();
        this.loadedPluginsScrollPane = new JScrollPane();
        this.loadedPluginsTable = null;
        this.installExtensionPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.fileText = new JTextField();
        this.browseButton = new JButton();
        this.installButton = new JButton();
        this.loadedConnectorsPanel = new JPanel();
        this.loadedConnectorsScrollPane = new JScrollPane();
        this.loadedConnectorsTable = null;
        this.restartRequiredPanel = new JPanel();
        this.restartRequiredLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.loadedPluginsPanel.setBackground(new Color(255, 255, 255));
        this.loadedPluginsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Installed Plugins", 0, 0, new Font("Tahoma", 1, 11)));
        this.loadedPluginsScrollPane.setViewportView((Component)((Object)this.loadedPluginsTable));
        GroupLayout loadedPluginsPanelLayout = new GroupLayout(this.loadedPluginsPanel);
        this.loadedPluginsPanel.setLayout(loadedPluginsPanelLayout);
        loadedPluginsPanelLayout.setHorizontalGroup(loadedPluginsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadedPluginsScrollPane, -1, 563, Short.MAX_VALUE));
        loadedPluginsPanelLayout.setVerticalGroup(loadedPluginsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadedPluginsScrollPane, GroupLayout.Alignment.TRAILING, -1, 76, Short.MAX_VALUE));
        this.installExtensionPanel.setBackground(new Color(255, 255, 255));
        this.installExtensionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "Install Extension from File System", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel1.setText("File:");
        this.browseButton.setText("Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtensionManagerPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.installButton.setText("Install");
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtensionManagerPanel.this.installButtonActionPerformed(evt);
            }
        });
        GroupLayout installExtensionPanelLayout = new GroupLayout(this.installExtensionPanel);
        this.installExtensionPanel.setLayout(installExtensionPanelLayout);
        installExtensionPanelLayout.setHorizontalGroup(installExtensionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(installExtensionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileText, -1, 375, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installButton)));
        installExtensionPanelLayout.setVerticalGroup(installExtensionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(installExtensionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.installButton).addComponent(this.browseButton).addComponent(this.fileText, -2, -1, -2)));
        this.loadedConnectorsPanel.setBackground(new Color(255, 255, 255));
        this.loadedConnectorsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Installed Connectors", 0, 0, new Font("Tahoma", 1, 11)));
        this.loadedConnectorsScrollPane.setViewportView((Component)((Object)this.loadedConnectorsTable));
        GroupLayout loadedConnectorsPanelLayout = new GroupLayout(this.loadedConnectorsPanel);
        this.loadedConnectorsPanel.setLayout(loadedConnectorsPanelLayout);
        loadedConnectorsPanelLayout.setHorizontalGroup(loadedConnectorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadedConnectorsScrollPane, -1, 563, Short.MAX_VALUE));
        loadedConnectorsPanelLayout.setVerticalGroup(loadedConnectorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadedConnectorsScrollPane, GroupLayout.Alignment.TRAILING, -1, 76, Short.MAX_VALUE));
        this.restartRequiredPanel.setBackground(new Color(255, 255, 204));
        this.restartRequiredLabel.setForeground(new Color(204, 0, 0));
        this.restartRequiredLabel.setHorizontalAlignment(0);
        this.restartRequiredLabel.setText("The BridgeLink Server and Administrator must be restarted before your changes will take effect.");
        GroupLayout restartRequiredPanelLayout = new GroupLayout(this.restartRequiredPanel);
        this.restartRequiredPanel.setLayout(restartRequiredPanelLayout);
        restartRequiredPanelLayout.setHorizontalGroup(restartRequiredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(restartRequiredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.restartRequiredLabel, -1, 551, Short.MAX_VALUE).addContainerGap()));
        restartRequiredPanelLayout.setVerticalGroup(restartRequiredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.restartRequiredLabel));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.restartRequiredPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.loadedConnectorsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.installExtensionPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.loadedPluginsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.loadedConnectorsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadedPluginsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restartRequiredPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installExtensionPanel, -2, -1, -2).addContainerGap()));
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        final String workingId = this.parent.startWorking("Installing Extension...");
        this.installButton.setEnabled(false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private boolean retVal = false;

            @Override
            public Void doInBackground() {
                this.retVal = ExtensionManagerPanel.this.parent.installExtension(new File(ExtensionManagerPanel.this.fileText.getText()));
                return null;
            }

            @Override
            public void done() {
                ExtensionManagerPanel.this.parent.stopWorking(workingId);
                ExtensionManagerPanel.this.installButton.setEnabled(true);
                if (this.retVal) {
                    ExtensionManagerPanel.this.setRestartRequired(true);
                    ExtensionManagerPanel.this.fileText.setText("");
                }
            }
        };
        worker.execute();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File pluginFile = PlatformUI.MIRTH_FRAME.browseForFile("ZIP");
        if (pluginFile != null) {
            this.fileText.setText(pluginFile.getAbsolutePath());
        }
    }
}

