/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTimePicker;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesAdvanced;
import com.mirth.connect.donkey.model.channel.PollingType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.text.DateFormatter;
import net.miginfocom.swing.MigLayout;

public class AdvancedPollingSettingsDialog
extends MirthDialog {
    private String scheduleType;
    private PollConnectorPropertiesAdvanced advancedProperties;
    private boolean channelContext = true;
    private JLabel activeDaysLabel;
    private JRadioButton weeklyRadioButton;
    private JRadioButton monthlyRadioButton;
    private ButtonGroup activeDaysButtonGroup;
    private JLabel sundayLabel;
    private JLabel mondayLabel;
    private JLabel tuesdayLabel;
    private JLabel wednesdayLabel;
    private JLabel thursdayLabel;
    private JLabel fridayLabel;
    private JLabel saturdayLabel;
    private JCheckBox sundayCheckbox;
    private JCheckBox mondayCheckbox;
    private JCheckBox tuesdayCheckbox;
    private JCheckBox wednesdayCheckbox;
    private JCheckBox thursdayCheckbox;
    private JCheckBox fridayCheckbox;
    private JCheckBox saturdayCheckbox;
    private MirthTimePicker monthlyDayPicker;
    private JLabel activeTimeLabel;
    private JRadioButton allDayRadioButton;
    private JRadioButton rangeRadioButton;
    private ButtonGroup activeTimeButtonGroup;
    private MirthTimePicker beginningRangePicker;
    private JLabel hyphenLabel;
    private MirthTimePicker endingRangePicker;
    private JButton okButton;
    private JButton cancelButton;

    public AdvancedPollingSettingsDialog(String scheduleType, PollConnectorPropertiesAdvanced advancedProperties, boolean channelContext) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.scheduleType = scheduleType;
        this.advancedProperties = advancedProperties;
        this.channelContext = channelContext;
        this.setTitle("Settings");
        DisplayUtil.setResizable(this, false);
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 8"));
        this.initComponents();
        this.initLayout();
        this.setProperties();
        this.pack();
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.setVisible(true);
    }

    public void enableComponents() {
        this.activeTimeLabel.setEnabled(this.scheduleType.equals(PollingType.INTERVAL.getDisplayName()));
        this.allDayRadioButton.setEnabled(this.scheduleType.equals(PollingType.INTERVAL.getDisplayName()));
        this.rangeRadioButton.setEnabled(this.scheduleType.equals(PollingType.INTERVAL.getDisplayName()));
        this.beginningRangePicker.setEnabled(this.scheduleType.equals(PollingType.INTERVAL.getDisplayName()));
        this.endingRangePicker.setEnabled(this.scheduleType.equals(PollingType.INTERVAL.getDisplayName()));
    }

    public void setProperties() {
        this.resetComponents();
        if (this.advancedProperties.isWeekly() && this.weeklyRadioButton.isEnabled()) {
            this.weeklyRadioButton.setSelected(true);
            boolean[] days = this.advancedProperties.getInactiveDays();
            this.sundayCheckbox.setSelected(!days[1]);
            this.mondayCheckbox.setSelected(!days[2]);
            this.tuesdayCheckbox.setSelected(!days[3]);
            this.wednesdayCheckbox.setSelected(!days[4]);
            this.thursdayCheckbox.setSelected(!days[5]);
            this.fridayCheckbox.setSelected(!days[6]);
            this.saturdayCheckbox.setSelected(!days[7]);
        } else {
            this.monthlyRadioButton.setSelected(true);
            this.monthlyDayPicker.setDate(String.valueOf(this.advancedProperties.getDayOfMonth()));
            this.activeDaysRadioButtonClicked();
        }
        if (this.advancedProperties.isAllDay() || this.scheduleType.equals(PollingType.TIME)) {
            this.allDayRadioButton.setSelected(true);
        } else {
            this.rangeRadioButton.setSelected(true);
            this.beginningRangePicker.setEnabled(true);
            this.endingRangePicker.setEnabled(true);
            SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aa");
            Calendar timeCalendar = Calendar.getInstance();
            timeCalendar.set(11, this.advancedProperties.getStartingHour());
            timeCalendar.set(12, this.advancedProperties.getStartingMinute());
            this.beginningRangePicker.setDate(dateFormat.format(timeCalendar.getTime()));
            timeCalendar.set(11, this.advancedProperties.getEndingHour());
            timeCalendar.set(12, this.advancedProperties.getEndingMinute());
            this.endingRangePicker.setDate(dateFormat.format(timeCalendar.getTime()));
        }
        this.enableComponents();
        this.activeDaysRadioButtonClicked();
        this.activeTimeRadioButtonClicked();
    }

    private void resetComponents() {
        this.weeklyRadioButton.setSelected(true);
        this.monthlyRadioButton.setSelected(false);
        this.allDayRadioButton.setSelected(true);
        this.rangeRadioButton.setSelected(false);
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aa");
        Calendar timeCalendar = Calendar.getInstance();
        timeCalendar.set(11, 8);
        timeCalendar.set(12, 0);
        this.beginningRangePicker.setDate(dateFormat.format(timeCalendar.getTime()));
        timeCalendar.set(11, 17);
        this.endingRangePicker.setDate(dateFormat.format(timeCalendar.getTime()));
        this.monthlyDayPicker.setDate("01");
    }

    public PollConnectorPropertiesAdvanced getProperties() {
        return this.advancedProperties;
    }

    public void clearProperties() {
        this.advancedProperties = new PollConnectorPropertiesAdvanced();
    }

    public void setType(String type) {
        this.scheduleType = type;
    }

    private void initComponents() {
        String weekly = "<html>Select Weekly to poll on the specified days of the week.<br>Select Monthly to poll on the specified day of the month.</html>";
        String active = "<html>If \"All Day\" is selected, polling may occur at any time during the day.<br>If \"Range\" is selected, polling will only occur during the specified range.</html>";
        if (!this.channelContext) {
            weekly = "<html>Select Weekly to prune on the specified days of the week.<br>Select Monthly to prune on the specified day of the month.</html>";
            active = "<html>If \"All Day\" is selected, pruning may occur at any time during the day.<br>If \"Range\" is selected, pruning will only occur during the specified range.</html>";
        }
        this.activeDaysLabel = new JLabel("Active Days:");
        this.weeklyRadioButton = new JRadioButton("Weekly");
        this.weeklyRadioButton.setToolTipText(weekly);
        this.weeklyRadioButton.setBackground(UIConstants.BACKGROUND_COLOR);
        this.weeklyRadioButton.setFocusable(false);
        this.weeklyRadioButton.setSelected(true);
        this.weeklyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdvancedPollingSettingsDialog.this.activeDaysRadioButtonClicked();
            }
        });
        this.monthlyRadioButton = new JRadioButton("Monthly");
        this.monthlyRadioButton.setToolTipText(weekly);
        this.monthlyRadioButton.setBackground(UIConstants.BACKGROUND_COLOR);
        this.monthlyRadioButton.setFocusable(false);
        this.monthlyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdvancedPollingSettingsDialog.this.activeDaysRadioButtonClicked();
            }
        });
        this.activeDaysButtonGroup = new ButtonGroup();
        this.activeDaysButtonGroup.add(this.weeklyRadioButton);
        this.activeDaysButtonGroup.add(this.monthlyRadioButton);
        this.sundayLabel = new JLabel("S");
        this.mondayLabel = new JLabel("M");
        this.tuesdayLabel = new JLabel("T");
        this.wednesdayLabel = new JLabel("W");
        this.thursdayLabel = new JLabel("Th");
        this.fridayLabel = new JLabel("F");
        this.saturdayLabel = new JLabel("S");
        this.sundayCheckbox = this.initCheckbox();
        this.mondayCheckbox = this.initCheckbox();
        this.tuesdayCheckbox = this.initCheckbox();
        this.wednesdayCheckbox = this.initCheckbox();
        this.thursdayCheckbox = this.initCheckbox();
        this.fridayCheckbox = this.initCheckbox();
        this.saturdayCheckbox = this.initCheckbox();
        this.monthlyDayPicker = new MirthTimePicker("dd", 2);
        this.monthlyDayPicker.setSaveEnabled(false);
        this.activeTimeLabel = new JLabel("Active Time:");
        this.allDayRadioButton = new JRadioButton("All Day");
        this.allDayRadioButton.setToolTipText(active);
        this.allDayRadioButton.setBackground(UIConstants.BACKGROUND_COLOR);
        this.allDayRadioButton.setFocusable(false);
        this.allDayRadioButton.setSelected(true);
        this.allDayRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdvancedPollingSettingsDialog.this.activeTimeRadioButtonClicked();
            }
        });
        this.rangeRadioButton = new JRadioButton("Range");
        this.rangeRadioButton.setToolTipText(active);
        this.rangeRadioButton.setBackground(UIConstants.BACKGROUND_COLOR);
        this.rangeRadioButton.setFocusable(false);
        this.rangeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdvancedPollingSettingsDialog.this.activeTimeRadioButtonClicked();
            }
        });
        this.activeTimeButtonGroup = new ButtonGroup();
        this.activeTimeButtonGroup.add(this.allDayRadioButton);
        this.activeTimeButtonGroup.add(this.rangeRadioButton);
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aa");
        Calendar timeCalendar = Calendar.getInstance();
        timeCalendar.set(11, 8);
        timeCalendar.set(12, 0);
        this.beginningRangePicker = new MirthTimePicker();
        this.beginningRangePicker.setSaveEnabled(false);
        this.beginningRangePicker.setDate(dateFormat.format(timeCalendar.getTime()));
        this.hyphenLabel = new JLabel("-");
        timeCalendar.set(11, 17);
        this.endingRangePicker = new MirthTimePicker();
        this.endingRangePicker.setSaveEnabled(false);
        this.endingRangePicker.setDate(dateFormat.format(timeCalendar.getTime()));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdvancedPollingSettingsDialog.this.okButtonActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdvancedPollingSettingsDialog.this.dispose();
            }
        });
    }

    private JCheckBox initCheckbox() {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setBackground(UIConstants.BACKGROUND_COLOR);
        checkBox.setFocusable(false);
        checkBox.setSelected(true);
        return checkBox;
    }

    private void activeDaysRadioButtonClicked() {
        boolean isWeeklySchedule = this.weeklyRadioButton.isSelected();
        this.sundayLabel.setEnabled(isWeeklySchedule);
        this.mondayLabel.setEnabled(isWeeklySchedule);
        this.tuesdayLabel.setEnabled(isWeeklySchedule);
        this.wednesdayLabel.setEnabled(isWeeklySchedule);
        this.thursdayLabel.setEnabled(isWeeklySchedule);
        this.fridayLabel.setEnabled(isWeeklySchedule);
        this.saturdayLabel.setEnabled(isWeeklySchedule);
        this.sundayCheckbox.setEnabled(isWeeklySchedule);
        this.mondayCheckbox.setEnabled(isWeeklySchedule);
        this.tuesdayCheckbox.setEnabled(isWeeklySchedule);
        this.wednesdayCheckbox.setEnabled(isWeeklySchedule);
        this.thursdayCheckbox.setEnabled(isWeeklySchedule);
        this.fridayCheckbox.setEnabled(isWeeklySchedule);
        this.saturdayCheckbox.setEnabled(isWeeklySchedule);
        this.monthlyDayPicker.setEnabled(!isWeeklySchedule);
    }

    private void activeTimeRadioButtonClicked() {
        boolean range = this.rangeRadioButton.isSelected();
        this.beginningRangePicker.setEnabled(range);
        this.hyphenLabel.setEnabled(range);
        this.endingRangePicker.setEnabled(range);
    }

    public boolean equals(PollConnectorPropertiesAdvanced advancedProperties) {
        boolean equals = true;
        for (int index = 0; index < advancedProperties.getInactiveDays().length; ++index) {
            if (advancedProperties.getInactiveDays()[index] == advancedProperties.getInactiveDays()[index]) continue;
            equals = false;
            break;
        }
        if (equals) {
            equals = advancedProperties.isWeekly() == advancedProperties.isWeekly();
            equals = advancedProperties.getDayOfMonth() != advancedProperties.getDayOfMonth() ? false : equals;
            equals = advancedProperties.isAllDay() != advancedProperties.isAllDay() ? false : equals;
            equals = advancedProperties.getStartingHour() != advancedProperties.getStartingHour() ? false : equals;
            equals = advancedProperties.getStartingMinute() != advancedProperties.getStartingMinute() ? false : equals;
            equals = advancedProperties.getEndingHour() != advancedProperties.getEndingHour() ? false : equals;
            equals = advancedProperties.getEndingMinute() != advancedProperties.getEndingMinute() ? false : equals;
        }
        return equals;
    }

    private void okButtonActionPerformed() {
        if (this.weeklyRadioButton.isSelected()) {
            boolean[] activeDays = new boolean[8];
            activeDays[1] = !this.sundayCheckbox.isSelected();
            activeDays[2] = !this.mondayCheckbox.isSelected();
            activeDays[3] = !this.tuesdayCheckbox.isSelected();
            activeDays[4] = !this.wednesdayCheckbox.isSelected();
            activeDays[5] = !this.thursdayCheckbox.isSelected();
            activeDays[6] = !this.fridayCheckbox.isSelected();
            activeDays[7] = !this.saturdayCheckbox.isSelected();
            HashSet<Boolean> selectedDays = new HashSet<Boolean>();
            for (int index = 1; index < activeDays.length; ++index) {
                selectedDays.add(activeDays[index]);
            }
            if (!selectedDays.contains(false)) {
                PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "You must select at least one day.");
                return;
            }
            this.advancedProperties.setWeekly(true);
            this.advancedProperties.setActiveDays(activeDays);
        } else if (this.monthlyRadioButton.isSelected()) {
            this.advancedProperties.setWeekly(false);
            this.advancedProperties.setDayOfMonth(Integer.parseInt(this.monthlyDayPicker.getDate()));
        }
        if (this.allDayRadioButton.isSelected()) {
            this.advancedProperties.setAllDay(true);
        } else if (this.rangeRadioButton.isSelected()) {
            this.advancedProperties.setAllDay(false);
            try {
                SimpleDateFormat timeDateFormat = new SimpleDateFormat("hh:mm aa");
                DateFormatter timeFormatter = new DateFormatter(timeDateFormat);
                Date timeDate = (Date)timeFormatter.stringToValue(this.beginningRangePicker.getDate());
                Calendar timeCalendar = Calendar.getInstance();
                timeCalendar.setTime(timeDate);
                int startingHour = timeCalendar.get(11);
                int startingMinute = timeCalendar.get(12);
                timeDate = (Date)timeFormatter.stringToValue(this.endingRangePicker.getDate());
                timeCalendar = Calendar.getInstance();
                timeCalendar.setTime(timeDate);
                int endingHour = timeCalendar.get(11);
                int endingMinute = timeCalendar.get(12);
                if (startingHour == endingHour && startingMinute == endingMinute) {
                    PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Start and End times must be different.");
                    return;
                }
                this.advancedProperties.setStartingHour(startingHour);
                this.advancedProperties.setStartingMinute(startingMinute);
                this.advancedProperties.setEndingHour(endingHour);
                this.advancedProperties.setEndingMinute(endingMinute);
            }
            catch (ParseException e) {
                PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), e.getMessage());
            }
        }
        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        this.dispose();
    }

    private void initLayout() {
        JPanel advancedSettingsPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 8 12 12 12, gap 6 6", "[right]12[left][left]"));
        advancedSettingsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        advancedSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "Advanced Settings", 0, 0, new Font("Tahoma", 1, 11)));
        advancedSettingsPanel.add(new JLabel(" "));
        advancedSettingsPanel.add(new JLabel(" "));
        advancedSettingsPanel.add((Component)this.sundayLabel, "split, gapleft 3");
        advancedSettingsPanel.add((Component)this.mondayLabel, "gapleft 11");
        advancedSettingsPanel.add((Component)this.tuesdayLabel, "gapleft 11");
        advancedSettingsPanel.add((Component)this.wednesdayLabel, "gapleft 10");
        advancedSettingsPanel.add((Component)this.thursdayLabel, "gapleft 6");
        advancedSettingsPanel.add((Component)this.fridayLabel, "gapleft 11");
        advancedSettingsPanel.add((Component)this.saturdayLabel, "gapleft 11, wrap");
        advancedSettingsPanel.add(this.activeDaysLabel);
        advancedSettingsPanel.add(this.weeklyRadioButton);
        advancedSettingsPanel.add((Component)this.sundayCheckbox, "split");
        advancedSettingsPanel.add(this.mondayCheckbox);
        advancedSettingsPanel.add(this.tuesdayCheckbox);
        advancedSettingsPanel.add(this.wednesdayCheckbox);
        advancedSettingsPanel.add(this.thursdayCheckbox);
        advancedSettingsPanel.add(this.fridayCheckbox);
        advancedSettingsPanel.add((Component)this.saturdayCheckbox, "wrap");
        advancedSettingsPanel.add(new JLabel(" "));
        advancedSettingsPanel.add(this.monthlyRadioButton);
        advancedSettingsPanel.add((Component)this.monthlyDayPicker, "wrap");
        advancedSettingsPanel.add(this.activeTimeLabel);
        advancedSettingsPanel.add((Component)this.allDayRadioButton, "wrap");
        advancedSettingsPanel.add(new JLabel(" "));
        advancedSettingsPanel.add(this.rangeRadioButton);
        advancedSettingsPanel.add((Component)this.beginningRangePicker, "split");
        advancedSettingsPanel.add((Component)this.hyphenLabel, "gapleft 8, gapright 8");
        advancedSettingsPanel.add(this.endingRangePicker);
        this.add((Component)advancedSettingsPanel, "wrap");
        this.add((Component)new JSeparator(), "growx, sx, wrap");
        this.add((Component)this.okButton, "split, right, push, w 50!");
        this.add((Component)this.cancelButton, "w 50!");
    }
}

