/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.ui.AbstractConnectorPropertiesPanel;
import com.mirth.connect.client.ui.ChannelSetup;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.DestinationSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ListenerSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.PollingSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.client.ui.panels.connectors.SourceSettingsPanel;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.ListenerConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.InvalidConnectorPluginProperties;
import com.mirth.connect.model.MessageStorageMode;
import com.mirth.connect.plugins.ConnectorPropertiesPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class ConnectorPanel
extends JPanel {
    private ChannelSetup channelSetup;
    private ConnectorSettingsPanel currentPanel;
    private JPanel connectorSettingsContainer;
    private ListenerSettingsPanel listenerSettingsPanel;
    private PollingSettingsPanel pollingSettingsPanel;
    private SourceSettingsPanel sourceSettingsPanel;
    private DestinationSettingsPanel destinationSettingsPanel;
    private Map<String, AbstractConnectorPropertiesPanel> connectorPropertiesPanels = new HashMap<String, AbstractConnectorPropertiesPanel>();

    public ConnectorPanel() {
        super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill", "[grow]"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.initComponents();
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).setConnectorPanel(this);
        }
    }

    public void setChannelSetup(ChannelSetup channelSetup) {
        this.channelSetup = channelSetup;
        this.destinationSettingsPanel.setChannelSetup(channelSetup);
        this.sourceSettingsPanel.setChannelSetup(channelSetup);
    }

    public void setConnectorSettingsPanel(ConnectorSettingsPanel panel) {
        if (this.currentPanel != null) {
            this.connectorSettingsContainer.remove(this.currentPanel);
        }
        this.connectorSettingsContainer.add(panel);
        this.connectorSettingsContainer.revalidate();
        this.currentPanel = panel;
        this.currentPanel.setConnectorPanel(this);
        ((TitledBorder)this.connectorSettingsContainer.getBorder()).setTitle(panel.getConnectorName() + " Settings");
        ConnectorProperties connectorProperties = this.getConnectorSettingsPanel().getDefaults();
        this.pollingSettingsPanel.setVisible(connectorProperties instanceof PollConnectorPropertiesInterface);
        this.listenerSettingsPanel.setVisible(connectorProperties instanceof ListenerConnectorPropertiesInterface);
        this.sourceSettingsPanel.setVisible(connectorProperties instanceof SourceConnectorPropertiesInterface);
        this.destinationSettingsPanel.setVisible(connectorProperties instanceof DestinationConnectorPropertiesInterface);
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).setVisible(connectorPropertiesPlugin.isSupported(connectorProperties.getName()));
        }
    }

    public SourceSettingsPanel getSourceSettingsPanel() {
        return this.sourceSettingsPanel;
    }

    public ConnectorSettingsPanel getConnectorSettingsPanel() {
        for (Component component : this.connectorSettingsContainer.getComponents()) {
            if (!component.isVisible()) continue;
            return (ConnectorSettingsPanel)component;
        }
        return null;
    }

    public Map<String, AbstractConnectorPropertiesPanel> getConnectorPluginPropertiesPanels() {
        return this.connectorPropertiesPanels;
    }

    public ConnectorProperties getProperties() {
        ConnectorSettingsPanel connectorSettingsPanel = this.getConnectorSettingsPanel();
        if (connectorSettingsPanel == null) {
            return null;
        }
        ConnectorProperties connectorProperties = connectorSettingsPanel.getProperties();
        if (connectorProperties instanceof PollConnectorPropertiesInterface) {
            this.pollingSettingsPanel.fillProperties((PollConnectorPropertiesInterface)connectorProperties);
        }
        if (connectorProperties instanceof ListenerConnectorPropertiesInterface) {
            this.listenerSettingsPanel.fillProperties((ListenerConnectorPropertiesInterface)connectorProperties);
        }
        if (connectorProperties instanceof SourceConnectorPropertiesInterface) {
            this.sourceSettingsPanel.fillProperties((SourceConnectorPropertiesInterface)connectorProperties);
        }
        if (connectorProperties instanceof DestinationConnectorPropertiesInterface) {
            this.destinationSettingsPanel.fillProperties((DestinationConnectorPropertiesInterface)connectorProperties);
        }
        if (connectorProperties != null) {
            HashSet<ConnectorPluginProperties> connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
            for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
                if (!connectorPropertiesPlugin.isSupported(connectorProperties.getName())) continue;
                connectorPluginProperties.add(this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).getProperties());
            }
            connectorProperties.setPluginProperties(connectorPluginProperties);
        }
        return connectorProperties;
    }

    public void setProperties(ConnectorProperties properties) {
        Connector.Mode mode = Connector.Mode.SOURCE;
        if (properties instanceof PollConnectorPropertiesInterface) {
            this.pollingSettingsPanel.resetInvalidProperties();
            this.pollingSettingsPanel.setProperties((PollConnectorPropertiesInterface)properties);
        }
        if (properties instanceof ListenerConnectorPropertiesInterface) {
            this.listenerSettingsPanel.resetInvalidProperties();
            this.listenerSettingsPanel.setProperties((ListenerConnectorPropertiesInterface)properties);
        }
        if (properties instanceof SourceConnectorPropertiesInterface) {
            this.sourceSettingsPanel.resetInvalidProperties();
            this.sourceSettingsPanel.setProperties((SourceConnectorPropertiesInterface)properties);
        }
        if (properties instanceof DestinationConnectorPropertiesInterface) {
            mode = Connector.Mode.DESTINATION;
            this.destinationSettingsPanel.resetInvalidProperties();
            this.destinationSettingsPanel.setProperties((DestinationConnectorPropertiesInterface)properties);
        }
        this.getConnectorSettingsPanel().resetInvalidProperties();
        this.getConnectorSettingsPanel().setProperties(properties);
        HashSet<String> addedPluginProperties = new HashSet<String>();
        if (properties.getPluginProperties() != null) {
            for (ConnectorPluginProperties connectorPluginProperties : properties.getPluginProperties()) {
                AbstractConnectorPropertiesPanel connectorPluginPropertiesPanel;
                if (connectorPluginProperties instanceof InvalidConnectorPluginProperties || (connectorPluginPropertiesPanel = this.connectorPropertiesPanels.get(connectorPluginProperties.getName())) == null) continue;
                connectorPluginPropertiesPanel.resetInvalidProperties();
                connectorPluginPropertiesPanel.setProperties(properties, connectorPluginProperties, mode, properties.getName());
                addedPluginProperties.add(connectorPluginProperties.getName());
            }
        }
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            String pluginPropertiesName = connectorPropertiesPlugin.getPluginPointName();
            if (!connectorPropertiesPlugin.isSupported(properties.getName()) || addedPluginProperties.contains(pluginPropertiesName)) continue;
            AbstractConnectorPropertiesPanel connectorPluginPropertiesPanel = this.connectorPropertiesPanels.get(pluginPropertiesName);
            connectorPluginPropertiesPanel.resetInvalidProperties();
            connectorPluginPropertiesPanel.setProperties(properties, connectorPluginPropertiesPanel.getDefaults(), mode, properties.getName());
        }
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        return this.checkProperties(this.getConnectorSettingsPanel(), properties, highlight);
    }

    public boolean checkProperties(ConnectorSettingsPanel connectorSettingsPanel, ConnectorProperties properties, boolean highlight) {
        boolean polling = true;
        Connector.Mode mode = Connector.Mode.SOURCE;
        if (properties instanceof PollConnectorPropertiesInterface) {
            this.pollingSettingsPanel.resetInvalidProperties();
            polling = this.pollingSettingsPanel.checkProperties((PollConnectorPropertiesInterface)properties, highlight);
        }
        boolean listener = true;
        if (properties instanceof ListenerConnectorPropertiesInterface) {
            this.listenerSettingsPanel.resetInvalidProperties();
            listener = this.listenerSettingsPanel.checkProperties((ListenerConnectorPropertiesInterface)properties, highlight);
        }
        boolean response = true;
        if (properties instanceof SourceConnectorPropertiesInterface) {
            this.sourceSettingsPanel.resetInvalidProperties();
            listener = this.sourceSettingsPanel.checkProperties((SourceConnectorPropertiesInterface)properties, highlight);
        }
        boolean destination = true;
        if (properties instanceof DestinationConnectorPropertiesInterface) {
            mode = Connector.Mode.DESTINATION;
            this.destinationSettingsPanel.resetInvalidProperties();
            destination = this.destinationSettingsPanel.checkProperties((DestinationConnectorPropertiesInterface)properties, highlight);
        }
        boolean pluginProperties = true;
        if (properties.getPluginProperties() != null) {
            for (ConnectorPluginProperties connectorPluginProperties : properties.getPluginProperties()) {
                AbstractConnectorPropertiesPanel connectorPluginPropertiesPanel;
                if (connectorPluginProperties instanceof InvalidConnectorPluginProperties || (connectorPluginPropertiesPanel = this.connectorPropertiesPanels.get(connectorPluginProperties.getName())) == null) continue;
                connectorPluginPropertiesPanel.resetInvalidProperties();
                if (connectorPluginPropertiesPanel.checkProperties(properties, connectorPluginProperties, mode, properties.getName(), highlight)) continue;
                pluginProperties = false;
            }
        }
        connectorSettingsPanel.resetInvalidProperties();
        boolean connector = connectorSettingsPanel.checkProperties(properties, highlight);
        return connector && polling && listener && response && destination && pluginProperties;
    }

    public String doValidate(ConnectorProperties properties, boolean highlight) {
        return this.doValidate(this.getConnectorSettingsPanel(), properties, highlight);
    }

    public String doValidate(ConnectorSettingsPanel connectorSettingsPanel, ConnectorProperties properties, boolean highlight) {
        String connectorError;
        Object error = null;
        if (!this.checkProperties(connectorSettingsPanel, properties, highlight)) {
            error = "Error in the form for connector \"" + connectorSettingsPanel.getConnectorName() + "\".\n\n";
        }
        if ((connectorError = connectorSettingsPanel.doValidate(properties, highlight)) != null) {
            if (error == null) {
                error = "";
            }
            error = (String)error + connectorError;
        }
        return error;
    }

    public void updateResponseDropDown() {
        if (this.getConnectorSettingsPanel().getProperties() instanceof SourceConnectorPropertiesInterface) {
            this.sourceSettingsPanel.updateResponseDropDown((SourceConnectorPropertiesInterface)this.getConnectorSettingsPanel().getProperties(), false);
        }
    }

    public ConnectorProperties getDefaults() {
        ConnectorProperties properties = this.getConnectorSettingsPanel().getDefaults();
        if (properties instanceof SourceConnectorPropertiesInterface) {
            if (((SourceConnectorPropertiesInterface)properties).getSourceConnectorProperties().getQueueBufferSize() == 0) {
                ((SourceConnectorPropertiesInterface)properties).getSourceConnectorProperties().setQueueBufferSize(this.channelSetup.defaultQueueBufferSize);
            }
        } else if (properties instanceof DestinationConnectorPropertiesInterface && ((DestinationConnectorPropertiesInterface)properties).getDestinationConnectorProperties().getQueueBufferSize() == 0) {
            ((DestinationConnectorPropertiesInterface)properties).getDestinationConnectorProperties().setQueueBufferSize(this.channelSetup.defaultQueueBufferSize);
        }
        HashSet<ConnectorPluginProperties> connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            if (!connectorPropertiesPlugin.isSupported(properties.getName())) continue;
            connectorPluginProperties.add(this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).getDefaults());
        }
        properties.setPluginProperties(connectorPluginProperties);
        return properties;
    }

    public VariableListHandler.TransferMode getTransferMode() {
        return this.getConnectorSettingsPanel().getTransferMode();
    }

    public String getRequiredInboundDataType() {
        return this.getConnectorSettingsPanel().getRequiredInboundDataType();
    }

    public String getRequiredOutboundDataType() {
        return this.getConnectorSettingsPanel().getRequiredOutboundDataType();
    }

    public String getInitialInboundDataType() {
        return this.getConnectorSettingsPanel().getInitialInboundDataType();
    }

    public String getInitialOutboundDataType() {
        return this.getConnectorSettingsPanel().getInitialOutboundDataType();
    }

    public String getInitialInboundResponseDataType() {
        return this.getConnectorSettingsPanel().getInitialInboundResponseDataType();
    }

    public String getInitialOutboundResponseDataType() {
        return this.getConnectorSettingsPanel().getInitialOutboundResponseDataType();
    }

    public void updatedField(String field) {
        this.getConnectorSettingsPanel().updatedField(field);
    }

    public void updateQueueWarning(MessageStorageMode messageStorageMode) {
        this.destinationSettingsPanel.updateQueueWarning(messageStorageMode);
        this.sourceSettingsPanel.updateQueueWarning(messageStorageMode);
    }

    public void updateNextFireTime() {
        this.pollingSettingsPanel.updateNextFireTime();
    }

    public void decorateConnectorType() {
        ConnectorTypeDecoration connectorTypeDecoration = this.currentPanel.getConnectorTypeDecoration();
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            ConnectorTypeDecoration tempConnectorTypeDecoration;
            if (!connectorPropertiesPlugin.isSupported(this.currentPanel.getConnectorName()) || (tempConnectorTypeDecoration = this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).getConnectorTypeDecoration()) == null) continue;
            connectorTypeDecoration = tempConnectorTypeDecoration;
        }
        this.channelSetup.decorateConnectorType(connectorTypeDecoration, this.getConnectorSettingsPanel().getDefaults() instanceof DestinationConnectorPropertiesInterface);
        this.currentPanel.doLocalDecoration(connectorTypeDecoration);
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            if (!connectorPropertiesPlugin.isSupported(this.currentPanel.getConnectorName())) continue;
            this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).doLocalDecoration(connectorTypeDecoration);
        }
    }

    ResponseHandler getResponseHandler(final ResponseHandler delegate, final Method method) {
        return new ResponseHandler(){

            @Override
            public void handle(Object response) {
                boolean handleResponse = true;
                for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
                    if (!connectorPropertiesPlugin.isSupported(ConnectorPanel.this.currentPanel.getConnectorName()) || ConnectorPanel.this.connectorPropertiesPanels.get(connectorPropertiesPlugin.getPluginPointName()).handleConnectorServiceResponse(ConnectorPanel.this.currentPanel, method, response)) continue;
                    handleResponse = false;
                }
                if (handleResponse && delegate != null) {
                    delegate.handle(response);
                }
            }
        };
    }

    private void initComponents() {
        this.listenerSettingsPanel = new ListenerSettingsPanel();
        this.add((Component)this.listenerSettingsPanel, "growx, wrap");
        this.pollingSettingsPanel = new PollingSettingsPanel(true);
        this.add((Component)this.pollingSettingsPanel, "growx, wrap");
        this.sourceSettingsPanel = new SourceSettingsPanel();
        this.add((Component)this.sourceSettingsPanel, "growx, wrap");
        this.destinationSettingsPanel = new DestinationSettingsPanel();
        this.add((Component)this.destinationSettingsPanel, "growx, wrap");
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            AbstractConnectorPropertiesPanel connectorPropertiesPanel = connectorPropertiesPlugin.getConnectorPropertiesPanel();
            connectorPropertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), connectorPropertiesPlugin.getSettingsTitle(), 0, 0, new Font("Tahoma", 1, 11)));
            this.connectorPropertiesPanels.put(connectorPropertiesPlugin.getPluginPointName(), connectorPropertiesPanel);
            this.add((Component)connectorPropertiesPanel, "growx, wrap");
        }
        this.connectorSettingsContainer = new JPanel(new BorderLayout());
        this.connectorSettingsContainer.setBackground(new Color(255, 255, 255));
        this.connectorSettingsContainer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Connector Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.add((Component)this.connectorSettingsContainer, "grow, pushy");
    }
}

