/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.panels.connectors.ConnectorPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public abstract class ConnectorSettingsPanel
extends JPanel {
    protected ConnectorPanel connectorPanel;
    private Map<String, SwingWorker<Object, Void>> workerMap = new ConcurrentHashMap<String, SwingWorker<Object, Void>>();

    public abstract String getConnectorName();

    public abstract ConnectorProperties getProperties();

    public abstract void setProperties(ConnectorProperties var1);

    public abstract ConnectorProperties getDefaults();

    public abstract boolean checkProperties(ConnectorProperties var1, boolean var2);

    public abstract void resetInvalidProperties();

    public String doValidate(ConnectorProperties properties, boolean highlight) {
        return null;
    }

    public VariableListHandler.TransferMode getTransferMode() {
        return VariableListHandler.TransferMode.VELOCITY;
    }

    public String getRequiredInboundDataType() {
        return null;
    }

    public String getRequiredOutboundDataType() {
        return null;
    }

    public String getInitialInboundDataType() {
        return null;
    }

    public String getInitialOutboundDataType() {
        return null;
    }

    public String getInitialInboundResponseDataType() {
        return null;
    }

    public String getInitialOutboundResponseDataType() {
        return null;
    }

    public List<String> getScripts(ConnectorProperties properties) {
        return new ArrayList<String>();
    }

    public void updatedField(String field) {
    }

    public ConnectorProperties getFilledProperties() {
        return this.connectorPanel.getProperties();
    }

    public final ConnectorPanel getConnectorPanel() {
        return this.connectorPanel;
    }

    public final void setConnectorPanel(ConnectorPanel connectorPanel) {
        this.connectorPanel = connectorPanel;
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        return null;
    }

    protected final void decorateConnectorType() {
        if (this.connectorPanel != null) {
            this.connectorPanel.decorateConnectorType();
        }
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
    }

    public final <T> T getServlet(Class<T> servletInterface, String workerDisplayText, String errorText) {
        return this.getServlet(servletInterface, workerDisplayText, errorText, null);
    }

    public final <T> T getServlet(Class<T> servletInterface, String workerDisplayText, String errorText, ResponseHandler responseHandler) {
        return this.getServlet(servletInterface, workerDisplayText, errorText, responseHandler, null);
    }

    public final <T> T getServlet(final Class<T> servletInterface, final String workerDisplayText, final String errorText, final ResponseHandler responseHandler, final String workerId) {
        return (T)Proxy.newProxyInstance((ClassLoader)AccessController.doPrivileged(ReflectionHelper.getClassLoaderPA(servletInterface)), new Class[]{servletInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) throws ClientException {
                final String workingId = PlatformUI.MIRTH_FRAME.startWorking(workerDisplayText);
                final ResponseHandler responseHandlerWrapper = ConnectorSettingsPanel.this.connectorPanel.getResponseHandler(responseHandler, method);
                SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                    @Override
                    public Object doInBackground() throws ClientException {
                        try {
                            if (servletInterface.isAssignableFrom(PlatformUI.MIRTH_FRAME.mirthClient.getClass())) {
                                return method.invoke((Object)PlatformUI.MIRTH_FRAME.mirthClient, args);
                            }
                            return method.invoke(PlatformUI.MIRTH_FRAME.mirthClient.getServlet(servletInterface), args);
                        }
                        catch (Throwable t) {
                            Throwable cause = t;
                            if (cause instanceof InvocationTargetException && cause.getCause() != null) {
                                cause = cause.getCause();
                            }
                            if (cause instanceof ClientException) {
                                throw (ClientException)cause;
                            }
                            throw new ClientException(cause);
                        }
                    }

                    @Override
                    public void done() {
                        block8: {
                            try {
                                if (this.isCancelled()) break block8;
                                try {
                                    if (responseHandlerWrapper != null) {
                                        responseHandlerWrapper.handle(this.get());
                                    }
                                }
                                catch (Exception e) {
                                    Throwable cause = e;
                                    if (e instanceof ExecutionException && e.getCause() != null) {
                                        cause = e.getCause();
                                    }
                                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, errorText + cause.getMessage());
                                }
                            }
                            finally {
                                PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                                if (workerId != null) {
                                    ConnectorSettingsPanel.this.workerMap.remove(workerId);
                                }
                            }
                        }
                    }
                };
                if (workerId != null) {
                    ConnectorSettingsPanel.this.workerMap.put(workerId, worker);
                }
                worker.execute();
                if (method.getReturnType().isPrimitive()) {
                    return method.getReturnType() == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Byte.valueOf((byte)0);
                }
                return null;
            }
        });
    }

    public final String getChannelId() {
        return PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getId();
    }

    public final String getChannelName() {
        return PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getName();
    }

    public SwingWorker<Object, Void> getWorker(String workerId) {
        return this.workerMap.get(workerId);
    }
}

