/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.ui.AbstractConnectorPropertiesPanel;
import com.mirth.connect.client.ui.ChannelSetup;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.InvalidConnectorPluginProperties;
import com.mirth.connect.model.MessageStorageMode;
import com.mirth.connect.plugins.ConnectorPropertiesPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DestinationSettingsPanel
extends JPanel {
    public static final String ADVANCED_QUEUE_PLUGIN_PROPERTIES = "destinationAdvancedQueuePluginProperties";
    private ChannelSetup channelSetup;
    private boolean regenerateTemplate;
    private boolean rotate;
    private boolean includeFilterTransformer;
    private int retryCount;
    private int retryIntervalMillis;
    private int threadCount;
    private String threadAssignmentVariable;
    private int queueBufferSize;
    private Set<ConnectorPluginProperties> pluginProperties;
    private JLabel queueMessagesLabel;
    private JRadioButton queueMessagesNeverRadio;
    private JRadioButton queueMessagesOnFailureRadio;
    private JRadioButton queueMessagesAlwaysRadio;
    private JLabel queueMessagesWarningLabel;
    private JLabel advancedQueueSettingsLabel;
    private JButton advancedQueueSettingsButton;
    private JLabel advancedQueueSettingsValueLabel;
    private JLabel validateResponseLabel;
    private JRadioButton validateResponseYesRadio;
    private JRadioButton validateResponseNoRadio;
    private JLabel reattachAttachmentsLabel;
    private JRadioButton reattachAttachmentsYesRadio;
    private JRadioButton reattachAttachmentsNoRadio;

    public DestinationSettingsPanel() {
        this.initComponents();
        this.initLayout();
    }

    public void setChannelSetup(ChannelSetup channelSetup) {
        this.channelSetup = channelSetup;
    }

    public void setProperties(DestinationConnectorPropertiesInterface propertiesInterface) {
        DestinationConnectorProperties properties = propertiesInterface.getDestinationConnectorProperties();
        this.retryCount = properties.getRetryCount();
        if (properties.isQueueEnabled()) {
            if (properties.isSendFirst()) {
                this.queueMessagesOnFailureRadio.setSelected(true);
            } else {
                this.queueMessagesAlwaysRadio.setSelected(true);
            }
        } else {
            this.queueMessagesNeverRadio.setSelected(true);
        }
        this.updateQueueMessages();
        this.regenerateTemplate = properties.isRegenerateTemplate();
        this.rotate = properties.isRotate();
        this.includeFilterTransformer = properties.isIncludeFilterTransformer();
        this.retryIntervalMillis = properties.getRetryIntervalMillis();
        this.threadCount = properties.getThreadCount();
        this.threadAssignmentVariable = properties.getThreadAssignmentVariable();
        this.queueBufferSize = properties.getQueueBufferSize() > 0 ? properties.getQueueBufferSize() : this.channelSetup.defaultQueueBufferSize;
        this.validateResponseLabel.setEnabled(propertiesInterface.canValidateResponse());
        this.validateResponseYesRadio.setEnabled(propertiesInterface.canValidateResponse());
        this.validateResponseNoRadio.setEnabled(propertiesInterface.canValidateResponse());
        if (properties.isValidateResponse()) {
            this.validateResponseYesRadio.setSelected(true);
        } else {
            this.validateResponseNoRadio.setSelected(true);
        }
        if (properties.isReattachAttachments()) {
            this.reattachAttachmentsYesRadio.setSelected(true);
        } else {
            this.reattachAttachmentsNoRadio.setSelected(true);
        }
        this.pluginProperties = properties.getPluginProperties();
        this.updateAdvancedSettingsLabel();
    }

    public void fillProperties(DestinationConnectorPropertiesInterface propertiesInterface) {
        DestinationConnectorProperties properties = propertiesInterface.getDestinationConnectorProperties();
        if (this.queueMessagesAlwaysRadio.isSelected()) {
            properties.setQueueEnabled(true);
            properties.setSendFirst(false);
        } else if (this.queueMessagesNeverRadio.isSelected()) {
            properties.setQueueEnabled(false);
            properties.setSendFirst(false);
        } else {
            properties.setQueueEnabled(true);
            properties.setSendFirst(true);
        }
        properties.setRegenerateTemplate(this.regenerateTemplate);
        properties.setRetryIntervalMillis(this.retryIntervalMillis);
        properties.setRetryCount(this.retryCount);
        properties.setRotate(this.rotate);
        properties.setIncludeFilterTransformer(this.includeFilterTransformer);
        properties.setThreadCount(this.threadCount);
        properties.setThreadAssignmentVariable(this.threadAssignmentVariable);
        properties.setValidateResponse(this.validateResponseYesRadio.isSelected());
        properties.setQueueBufferSize(this.queueBufferSize);
        properties.setReattachAttachments(this.reattachAttachmentsYesRadio.isSelected());
        properties.setPluginProperties(this.pluginProperties);
    }

    public boolean checkProperties(DestinationConnectorPropertiesInterface propertiesInterface, boolean highlight) {
        return true;
    }

    public void resetInvalidProperties() {
    }

    private void updateQueueMessages() {
        this.channelSetup.saveDestinationPanel();
        MessageStorageMode messageStorageMode = this.channelSetup.getMessageStorageMode();
        this.channelSetup.updateQueueWarning(messageStorageMode);
        this.updateQueueWarning(messageStorageMode);
        this.updateAdvancedSettingsLabel();
    }

    public void updateQueueWarning(MessageStorageMode messageStorageMode) {
        switch (messageStorageMode) {
            case RAW: 
            case METADATA: 
            case DISABLED: {
                if (this.queueMessagesAlwaysRadio.isSelected() || this.queueMessagesOnFailureRadio.isSelected()) {
                    this.queueMessagesWarningLabel.setText("<html>Queueing is not supported by the current message storage mode</html>");
                    break;
                }
                this.queueMessagesWarningLabel.setText("");
                break;
            }
            default: {
                this.queueMessagesWarningLabel.setText("");
            }
        }
    }

    private void updateAdvancedSettingsLabel() {
        boolean sendFirst;
        ArrayList<Object> list = new ArrayList<Object>();
        boolean queueEnabled = !this.queueMessagesNeverRadio.isSelected();
        boolean bl = sendFirst = queueEnabled && this.queueMessagesOnFailureRadio.isSelected();
        if (!queueEnabled) {
            list.add(String.valueOf(this.retryCount) + " Retr" + (this.retryCount == 1 ? "y" : "ies"));
            if (this.retryCount > 0) {
                list.add("Interval " + String.valueOf(this.retryIntervalMillis) + " ms");
            }
        } else {
            if (this.regenerateTemplate) {
                list.add("Regenerate");
            }
            if (this.rotate) {
                list.add("Rotate");
            }
            if (this.includeFilterTransformer) {
                list.add("Including Transformer");
            }
            if (sendFirst) {
                list.add(String.valueOf(this.retryCount) + " Retr" + (this.retryCount == 1 ? "y" : "ies"));
            }
            list.add("Interval " + String.valueOf(this.retryIntervalMillis) + " ms");
            if (this.threadCount > 1) {
                list.add(String.valueOf(this.threadCount) + " Threads");
                if (StringUtils.isNotBlank((CharSequence)this.threadAssignmentVariable)) {
                    list.add("Group By " + this.threadAssignmentVariable);
                }
            }
        }
        this.advancedQueueSettingsValueLabel.setText(StringUtils.join(list, (String)" / "));
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 4 8 4 4, novisualpadding, hidemode 3, fill", "[]13[grow]"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Destination Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.queueMessagesLabel = new JLabel("Queue Messages:");
        ButtonGroup queueMessagesButtonGroup = new ButtonGroup();
        ActionListener queueMessagesActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DestinationSettingsPanel.this.updateQueueMessages();
            }
        };
        this.queueMessagesNeverRadio = new MirthRadioButton("Never");
        this.queueMessagesNeverRadio.setBackground(this.getBackground());
        this.queueMessagesNeverRadio.setToolTipText("Disable the destination queue.");
        this.queueMessagesNeverRadio.addActionListener(queueMessagesActionListener);
        queueMessagesButtonGroup.add(this.queueMessagesNeverRadio);
        this.queueMessagesOnFailureRadio = new MirthRadioButton("On Failure");
        this.queueMessagesOnFailureRadio.setBackground(this.getBackground());
        this.queueMessagesOnFailureRadio.setToolTipText("<html>Attempt to send the message first before queueing it. This will allow subsequent<br/>destinations and the Postprocessor to use the response from this destination if it<br/>successfully sends before queueing.</html>");
        this.queueMessagesOnFailureRadio.addActionListener(queueMessagesActionListener);
        queueMessagesButtonGroup.add(this.queueMessagesOnFailureRadio);
        this.queueMessagesAlwaysRadio = new MirthRadioButton("Always");
        this.queueMessagesAlwaysRadio.setBackground(this.getBackground());
        this.queueMessagesAlwaysRadio.setToolTipText("<html>Immediately queue the message. Subsequent destinations and the<br/>Postprocessor will always see this destination's response as QUEUED.</html>");
        this.queueMessagesAlwaysRadio.addActionListener(queueMessagesActionListener);
        queueMessagesButtonGroup.add(this.queueMessagesAlwaysRadio);
        this.queueMessagesWarningLabel = new JLabel();
        this.queueMessagesWarningLabel.setForeground(Color.RED);
        this.advancedQueueSettingsLabel = new JLabel("Advanced Queue Settings:");
        this.advancedQueueSettingsButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.advancedQueueSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new AdvancedDialog();
            }
        });
        this.advancedQueueSettingsValueLabel = new JLabel();
        this.validateResponseLabel = new JLabel("Validate Response:");
        ButtonGroup validateResponseButtonGroup = new ButtonGroup();
        String toolTipText = "<html>Select Yes to validate the response. Responses can only be validated if the<br>response transformer's inbound properties contains a <b>Response Validation</b><br>section. If validation fails, the message will be marked as queued or errored.</html>";
        this.validateResponseYesRadio = new MirthRadioButton("Yes");
        this.validateResponseYesRadio.setBackground(this.getBackground());
        this.validateResponseYesRadio.setToolTipText(toolTipText);
        validateResponseButtonGroup.add(this.validateResponseYesRadio);
        this.validateResponseNoRadio = new MirthRadioButton("No");
        this.validateResponseNoRadio.setBackground(this.getBackground());
        this.validateResponseNoRadio.setToolTipText(toolTipText);
        validateResponseButtonGroup.add(this.validateResponseNoRadio);
        this.reattachAttachmentsLabel = new JLabel("Reattach Attachments:");
        ButtonGroup reattachAttachmentsButtonGroup = new ButtonGroup();
        toolTipText = "<html>If enabled, replacement tokens using the ${ATTACH:...} syntax will<br/>automatically be replaced with the associated attachment content<br/>before the message is sent. If disabled, the tokens will be<br/>expanded to the full ${ATTACH:channelId:messageId:attachmentId}<br/>syntax which can then be reattached in downstream channels.</html>";
        this.reattachAttachmentsYesRadio = new MirthRadioButton("Yes");
        this.reattachAttachmentsYesRadio.setBackground(this.getBackground());
        this.reattachAttachmentsYesRadio.setToolTipText(toolTipText);
        reattachAttachmentsButtonGroup.add(this.reattachAttachmentsYesRadio);
        this.reattachAttachmentsNoRadio = new MirthRadioButton("No");
        this.reattachAttachmentsNoRadio.setBackground(this.getBackground());
        this.reattachAttachmentsNoRadio.setToolTipText(toolTipText);
        reattachAttachmentsButtonGroup.add(this.reattachAttachmentsNoRadio);
    }

    private void initLayout() {
        this.add((Component)this.queueMessagesLabel, "right");
        this.add((Component)this.queueMessagesNeverRadio, "split");
        this.add(this.queueMessagesOnFailureRadio);
        this.add(this.queueMessagesAlwaysRadio);
        this.add((Component)this.queueMessagesWarningLabel, "gapbefore 16");
        this.add((Component)this.advancedQueueSettingsLabel, "newline, right");
        this.add((Component)this.advancedQueueSettingsButton, "h 22!, w 22!, split");
        this.add(this.advancedQueueSettingsValueLabel);
        this.add((Component)this.validateResponseLabel, "newline, right");
        this.add((Component)this.validateResponseYesRadio, "split");
        this.add(this.validateResponseNoRadio);
        this.add((Component)this.reattachAttachmentsLabel, "newline, right");
        this.add((Component)this.reattachAttachmentsYesRadio, "split");
        this.add(this.reattachAttachmentsNoRadio);
    }

    private class AdvancedDialog
    extends MirthDialog {
        private JPanel containerPanel;
        private JLabel regenerateTemplateLabel;
        private JRadioButton regenerateTemplateYesRadio;
        private JRadioButton regenerateTemplateNoRadio;
        private JLabel rotateLabel;
        private JRadioButton rotateYesRadio;
        private JRadioButton rotateNoRadio;
        private JLabel includeFilterTransformerLabel;
        private JRadioButton includeFilterTransformerYesRadio;
        private JRadioButton includeFilterTransformerNoRadio;
        private JLabel retryCountLabel;
        private JTextField retryCountField;
        private JLabel retryIntervalLabel;
        private JTextField retryIntervalField;
        private JLabel queueThreadsLabel;
        private JTextField queueThreadsField;
        private JLabel threadAssignmentVariableLabel;
        private JTextField threadAssignmentVariableField;
        private JLabel queueBufferSizeLabel;
        private JTextField queueBufferSizeField;
        private Map<String, AbstractConnectorPropertiesPanel> pluginPropertiesPanels;
        private JButton okButton;
        private JButton cancelButton;

        public AdvancedDialog() {
            super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
            this.setTitle("Settings");
            this.setDefaultCloseOperation(2);
            this.initComponents();
            this.initLayout();
            this.setProperties();
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
        }

        private void setProperties() {
            if (DestinationSettingsPanel.this.regenerateTemplate) {
                this.regenerateTemplateYesRadio.setSelected(true);
            } else {
                this.regenerateTemplateNoRadio.setSelected(true);
            }
            if (DestinationSettingsPanel.this.rotate) {
                this.rotateYesRadio.setSelected(true);
            } else {
                this.rotateNoRadio.setSelected(true);
            }
            if (DestinationSettingsPanel.this.includeFilterTransformer) {
                this.includeFilterTransformerYesRadio.setSelected(true);
            } else {
                this.includeFilterTransformerNoRadio.setSelected(true);
            }
            this.retryCountField.setText(String.valueOf(DestinationSettingsPanel.this.retryCount));
            this.retryIntervalField.setText(String.valueOf(DestinationSettingsPanel.this.retryIntervalMillis));
            this.queueThreadsField.setText(String.valueOf(DestinationSettingsPanel.this.threadCount));
            this.threadAssignmentVariableField.setText(StringUtils.defaultString((String)DestinationSettingsPanel.this.threadAssignmentVariable));
            boolean queueEnabled = !DestinationSettingsPanel.this.queueMessagesNeverRadio.isSelected();
            boolean sendFirst = DestinationSettingsPanel.this.queueMessagesOnFailureRadio.isSelected();
            this.regenerateTemplateLabel.setEnabled(queueEnabled);
            this.regenerateTemplateYesRadio.setEnabled(queueEnabled);
            this.regenerateTemplateNoRadio.setEnabled(queueEnabled);
            this.rotateLabel.setEnabled(queueEnabled);
            this.rotateYesRadio.setEnabled(queueEnabled);
            this.rotateNoRadio.setEnabled(queueEnabled);
            this.includeFilterTransformerLabel.setEnabled(queueEnabled && DestinationSettingsPanel.this.regenerateTemplate);
            this.includeFilterTransformerYesRadio.setEnabled(queueEnabled && DestinationSettingsPanel.this.regenerateTemplate);
            this.includeFilterTransformerNoRadio.setEnabled(queueEnabled && DestinationSettingsPanel.this.regenerateTemplate);
            this.retryCountLabel.setEnabled(!queueEnabled || sendFirst);
            this.retryCountField.setEnabled(!queueEnabled || sendFirst);
            this.retryIntervalLabel.setEnabled(queueEnabled || DestinationSettingsPanel.this.retryCount > 0);
            this.retryIntervalField.setEnabled(queueEnabled || DestinationSettingsPanel.this.retryCount > 0);
            this.queueThreadsLabel.setEnabled(queueEnabled);
            this.queueThreadsField.setEnabled(queueEnabled);
            this.threadAssignmentVariableLabel.setEnabled(queueEnabled && DestinationSettingsPanel.this.threadCount > 1);
            this.threadAssignmentVariableField.setEnabled(queueEnabled && DestinationSettingsPanel.this.threadCount > 1);
            this.queueBufferSizeLabel.setEnabled(queueEnabled);
            this.queueBufferSizeField.setEnabled(queueEnabled);
            this.queueBufferSizeField.setText(String.valueOf(DestinationSettingsPanel.this.queueBufferSize));
            for (AbstractConnectorPropertiesPanel cppPanel : this.pluginPropertiesPanels.values()) {
                cppPanel.setProperties(null, cppPanel.getDefaults(), Connector.Mode.DESTINATION, null);
                cppPanel.setLayoutComponentsEnabled(queueEnabled);
            }
            if (DestinationSettingsPanel.this.pluginProperties != null) {
                for (ConnectorPluginProperties cpp : DestinationSettingsPanel.this.pluginProperties) {
                    AbstractConnectorPropertiesPanel cppPanel;
                    if (cpp instanceof InvalidConnectorPluginProperties || (cppPanel = this.pluginPropertiesPanels.get(cpp.getName())) == null) continue;
                    cppPanel.setProperties(null, cpp, Connector.Mode.DESTINATION, null);
                    cppPanel.setLayoutComponentsEnabled(queueEnabled);
                }
            }
        }

        private boolean saveProperties() {
            this.retryCountField.setBackground(null);
            this.retryIntervalField.setBackground(null);
            this.queueThreadsField.setBackground(null);
            Object errors = "";
            if (this.retryCountField.isEnabled() && StringUtils.isBlank((CharSequence)this.retryCountField.getText())) {
                errors = (String)errors + "Retry count cannot be blank.\n";
                this.retryCountField.setBackground(UIConstants.INVALID_COLOR);
            }
            if (this.retryIntervalField.isEnabled() && NumberUtils.toInt((String)this.retryIntervalField.getText(), (int)0) <= 0) {
                errors = (String)errors + "Retry interval must be greater than zero.\n";
                this.retryIntervalField.setBackground(UIConstants.INVALID_COLOR);
            }
            if (this.queueThreadsField.isEnabled() && NumberUtils.toInt((String)this.queueThreadsField.getText(), (int)0) <= 0) {
                errors = (String)errors + "Queue threads must be greater than zero.\n";
                this.queueThreadsField.setBackground(UIConstants.INVALID_COLOR);
            }
            if (NumberUtils.toInt((String)this.queueBufferSizeField.getText()) <= 0) {
                this.queueBufferSizeField.setBackground(UIConstants.INVALID_COLOR);
                errors = (String)errors + "Queue buffer size must be greater than zero.\n";
            }
            if (StringUtils.isNotBlank((CharSequence)errors)) {
                PlatformUI.MIRTH_FRAME.alertError(this, (String)errors);
                return false;
            }
            DestinationSettingsPanel.this.regenerateTemplate = this.regenerateTemplateYesRadio.isSelected();
            DestinationSettingsPanel.this.rotate = this.rotateYesRadio.isSelected();
            DestinationSettingsPanel.this.includeFilterTransformer = this.includeFilterTransformerYesRadio.isSelected();
            DestinationSettingsPanel.this.retryCount = NumberUtils.toInt((String)this.retryCountField.getText(), (int)0);
            DestinationSettingsPanel.this.retryIntervalMillis = NumberUtils.toInt((String)this.retryIntervalField.getText(), (int)0);
            DestinationSettingsPanel.this.threadCount = NumberUtils.toInt((String)this.queueThreadsField.getText(), (int)1);
            DestinationSettingsPanel.this.threadAssignmentVariable = this.threadAssignmentVariableField.getText();
            DestinationSettingsPanel.this.queueBufferSize = NumberUtils.toInt((String)this.queueBufferSizeField.getText());
            DestinationSettingsPanel.this.pluginProperties = null;
            if (!this.pluginPropertiesPanels.isEmpty()) {
                DestinationSettingsPanel.this.pluginProperties = new HashSet<ConnectorPluginProperties>();
                for (AbstractConnectorPropertiesPanel cppPanel : this.pluginPropertiesPanels.values()) {
                    DestinationSettingsPanel.this.pluginProperties.add(cppPanel.getProperties());
                }
            }
            DestinationSettingsPanel.this.updateAdvancedSettingsLabel();
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            return true;
        }

        private void initComponents() {
            this.setBackground(UIConstants.BACKGROUND_COLOR);
            this.getContentPane().setBackground(this.getBackground());
            this.containerPanel = new JPanel();
            this.containerPanel.setBackground(this.getBackground());
            this.containerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "Advanced Queue Settings", 0, 0, new Font("Tahoma", 1, 11)));
            this.retryCountLabel = new JLabel("Retry Count Before Queue/Error:");
            this.retryCountField = new JTextField();
            this.retryCountField.setToolTipText("<html>The maximum number of times the connector will attempt to send<br/>the message before queueing or erroring.</html>");
            this.retryCountField.setDocument(new MirthFieldConstraints(0, false, false, true));
            this.retryCountField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent evt) {
                    AdvancedDialog.this.retryCountChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent evt) {
                    AdvancedDialog.this.retryCountChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent evt) {
                    AdvancedDialog.this.retryCountChanged();
                }
            });
            this.retryIntervalLabel = new JLabel("Retry Interval (ms):");
            this.retryIntervalField = new JTextField();
            this.retryIntervalField.setToolTipText("<html>The amount of time that should elapse between retry attempts to send<br/>messages. This interval applies to both the queue and initial retry attempts.</html>");
            this.retryIntervalField.setDocument(new MirthFieldConstraints(0, false, false, true));
            this.regenerateTemplateLabel = new JLabel("Regenerate Template:");
            ButtonGroup regenerateTemplateButtonGroup = new ButtonGroup();
            String toolTipText = "<html>Regenerate the template and other connector properties by replacing variables<br/>each time the connector attempts to send the message from the queue. If this is<br/>disabled, the original variable replacements will be used for each attempt.</html>";
            ActionListener regenerateTemplateActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AdvancedDialog.this.regenerateTemplateChanged();
                }
            };
            this.regenerateTemplateYesRadio = new JRadioButton("Yes");
            this.regenerateTemplateYesRadio.setBackground(this.getBackground());
            this.regenerateTemplateYesRadio.setToolTipText(toolTipText);
            this.regenerateTemplateYesRadio.addActionListener(regenerateTemplateActionListener);
            regenerateTemplateButtonGroup.add(this.regenerateTemplateYesRadio);
            this.regenerateTemplateNoRadio = new JRadioButton("No");
            this.regenerateTemplateNoRadio.setBackground(this.getBackground());
            this.regenerateTemplateNoRadio.setToolTipText(toolTipText);
            this.regenerateTemplateNoRadio.addActionListener(regenerateTemplateActionListener);
            regenerateTemplateButtonGroup.add(this.regenerateTemplateNoRadio);
            this.rotateLabel = new JLabel("Rotate Queue:");
            ButtonGroup rotateButtonGroup = new ButtonGroup();
            toolTipText = "<html>If enabled, when any message fails to be sent from the queue, the connector will<br/>place the message at the end of the queue and attempt to send the next message.<br/>This will prevent a single message from holding up the entire queue. If the order<br/>of messages processed is important, this should be disabled.</html>";
            this.rotateYesRadio = new JRadioButton("Yes");
            this.rotateYesRadio.setBackground(this.getBackground());
            this.rotateYesRadio.setToolTipText(toolTipText);
            rotateButtonGroup.add(this.rotateYesRadio);
            this.rotateNoRadio = new JRadioButton("No");
            this.rotateNoRadio.setBackground(this.getBackground());
            this.rotateNoRadio.setToolTipText(toolTipText);
            rotateButtonGroup.add(this.rotateNoRadio);
            this.includeFilterTransformerLabel = new JLabel("Include Filter/Transformer:");
            ButtonGroup includeFilterTransformerButtonGroup = new ButtonGroup();
            toolTipText = "<html>If enabled, the filter and transformer will be re-executed<br/>before every queue send attempt. This is only available<br/>when the Regenerate Template setting is enabled.</html>";
            this.includeFilterTransformerYesRadio = new JRadioButton("Yes");
            this.includeFilterTransformerYesRadio.setBackground(this.getBackground());
            this.includeFilterTransformerYesRadio.setToolTipText(toolTipText);
            includeFilterTransformerButtonGroup.add(this.includeFilterTransformerYesRadio);
            this.includeFilterTransformerNoRadio = new JRadioButton("No");
            this.includeFilterTransformerNoRadio.setBackground(this.getBackground());
            this.includeFilterTransformerNoRadio.setToolTipText(toolTipText);
            includeFilterTransformerButtonGroup.add(this.includeFilterTransformerNoRadio);
            this.queueThreadsLabel = new JLabel("Queue Threads:");
            this.queueThreadsField = new JTextField();
            this.queueThreadsField.setToolTipText("<html>The number of threads that will read from the queue and dispatch<br/>messages simultaneously. Message order is NOT guaranteed if this<br/>value is greater than one, unless an assignment variable is used below.</html>");
            this.queueThreadsField.setDocument(new MirthFieldConstraints(0, false, false, true));
            this.queueThreadsField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent evt) {
                    AdvancedDialog.this.queueThreadsChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent evt) {
                    AdvancedDialog.this.queueThreadsChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent evt) {
                    AdvancedDialog.this.queueThreadsChanged();
                }
            });
            this.threadAssignmentVariableLabel = new JLabel("Thread Assignment Variable:");
            this.threadAssignmentVariableField = new JTextField();
            this.threadAssignmentVariableField.setToolTipText("<html>When using multiple queue threads, this map variable<br/>determines how to assign messages to specific threads.<br/>If rotation is disabled, messages with the same thread<br/>assignment value will always be processed in order.</html>");
            this.queueBufferSizeLabel = new JLabel("Queue Buffer Size:");
            this.queueBufferSizeField = new JTextField();
            this.queueBufferSizeField.setDocument(new MirthFieldConstraints(0, false, false, true));
            this.queueBufferSizeField.setToolTipText("<html>The buffer size for the destination queue.<br/>Up to this many connector messages may<br/>be held in memory at once when queuing.</html>");
            this.pluginPropertiesPanels = new LinkedHashMap<String, AbstractConnectorPropertiesPanel>();
            for (ConnectorPropertiesPlugin plugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
                if (!plugin.isConnectorPropertiesPluginSupported(DestinationSettingsPanel.ADVANCED_QUEUE_PLUGIN_PROPERTIES)) continue;
                AbstractConnectorPropertiesPanel cppPanel = plugin.getConnectorPropertiesPanel();
                this.pluginPropertiesPanels.put(cppPanel.getDefaults().getName(), cppPanel);
            }
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AdvancedDialog.this.saveProperties()) {
                        AdvancedDialog.this.dispose();
                    }
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AdvancedDialog.this.dispose();
                }
            });
        }

        private void initLayout() {
            this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill", "", "[grow][][]"));
            this.containerPanel.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, fill", "[]13[grow]", "[][][][][][][][][grow]"));
            this.containerPanel.add((Component)this.retryCountLabel, "right");
            this.containerPanel.add((Component)this.retryCountField, "w 75!");
            this.containerPanel.add((Component)this.retryIntervalLabel, "newline, right");
            this.containerPanel.add((Component)this.retryIntervalField, "w 75!");
            this.containerPanel.add((Component)this.rotateLabel, "newline, right");
            this.containerPanel.add((Component)this.rotateYesRadio, "split");
            this.containerPanel.add(this.rotateNoRadio);
            this.containerPanel.add((Component)this.regenerateTemplateLabel, "newline, right");
            this.containerPanel.add((Component)this.regenerateTemplateYesRadio, "split");
            this.containerPanel.add(this.regenerateTemplateNoRadio);
            this.containerPanel.add((Component)this.includeFilterTransformerLabel, "newline, right");
            this.containerPanel.add((Component)this.includeFilterTransformerYesRadio, "split");
            this.containerPanel.add(this.includeFilterTransformerNoRadio);
            this.containerPanel.add((Component)this.queueThreadsLabel, "newline, right");
            this.containerPanel.add((Component)this.queueThreadsField, "w 75!");
            this.containerPanel.add((Component)this.threadAssignmentVariableLabel, "newline, right");
            this.containerPanel.add((Component)this.threadAssignmentVariableField, "w 75!");
            this.containerPanel.add((Component)this.queueBufferSizeLabel, "newline, right");
            this.containerPanel.add((Component)this.queueBufferSizeField, "w 75!");
            for (AbstractConnectorPropertiesPanel cppPanel : this.pluginPropertiesPanels.values()) {
                for (Component[] row : cppPanel.getLayoutComponents()) {
                    this.containerPanel.add(row[0], "newline, right");
                    this.containerPanel.add(row[1], "growx");
                }
            }
            this.add((Component)this.containerPanel, "grow, push");
            this.add((Component)new JSeparator(), "newline, growx, sx");
            this.add((Component)this.okButton, "newline, w 50!, sx, right, split");
            this.add((Component)this.cancelButton, "w 50!");
        }

        private void retryCountChanged() {
            if (NumberUtils.toInt((String)this.retryCountField.getText()) > 0) {
                this.retryIntervalField.setEnabled(true);
                this.retryIntervalLabel.setEnabled(true);
            } else if (DestinationSettingsPanel.this.queueMessagesNeverRadio.isSelected()) {
                this.retryIntervalField.setEnabled(false);
                this.retryIntervalLabel.setEnabled(false);
            }
        }

        private void regenerateTemplateChanged() {
            boolean enabled = !DestinationSettingsPanel.this.queueMessagesNeverRadio.isSelected() && this.regenerateTemplateYesRadio.isSelected();
            this.includeFilterTransformerLabel.setEnabled(enabled);
            this.includeFilterTransformerYesRadio.setEnabled(enabled);
            this.includeFilterTransformerNoRadio.setEnabled(enabled);
        }

        private void queueThreadsChanged() {
            int threadCount = NumberUtils.toInt((String)this.queueThreadsField.getText(), (int)0);
            this.threadAssignmentVariableLabel.setEnabled(threadCount > 1);
            this.threadAssignmentVariableField.setEnabled(threadCount > 1);
        }
    }
}

