/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.ui.ChannelSetup;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.MessageStorageMode;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.Step;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.math.NumberUtils;

public class SourceSettingsPanel
extends JPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private ChannelSetup channelSetup;
    private List<String> queueOnRespondFromNames;
    private List<Object> queueOffRespondFromNames;
    private JLabel sourceQueueLabel;
    private MirthComboBox sourceQueueComboBox;
    private JLabel queueWarningLabel;
    private JLabel queueBufferSizeLabel;
    private JTextField queueBufferSizeField;
    private JLabel responseLabel;
    private MirthComboBox responseComboBox;
    private JLabel processBatchLabel;
    private MirthRadioButton processBatchYesRadio;
    private MirthRadioButton processBatchNoRadio;
    private JLabel batchResponseLabel;
    private MirthRadioButton batchResponseFirstRadio;
    private MirthRadioButton batchResponseLastRadio;
    private JLabel processingThreadsLabel;
    private MirthTextField processingThreadsField;

    public SourceSettingsPanel() {
        this.initComponents();
        this.initLayout();
        this.queueWarningLabel.setVisible(false);
    }

    public void setChannelSetup(ChannelSetup channelSetup) {
        this.channelSetup = channelSetup;
    }

    public void enableMaxProcessingThreads() {
        this.processingThreadsLabel.setEnabled(true);
        this.processingThreadsField.setEnabled(true);
    }

    public void disableMaxProcessingThreads(Integer value) {
        this.processingThreadsLabel.setEnabled(false);
        this.processingThreadsField.setEnabled(false);
        if (value != null) {
            this.processingThreadsField.setText(String.valueOf(value));
        }
    }

    public void setProperties(SourceConnectorPropertiesInterface propertiesInterface) {
        SourceConnectorProperties properties = propertiesInterface.getSourceConnectorProperties();
        this.updateResponseDropDown(propertiesInterface, true);
        if (properties.isRespondAfterProcessing()) {
            this.sourceQueueComboBox.setSelectedIndex(0);
        } else {
            this.sourceQueueComboBox.setSelectedIndex(1);
        }
        if (properties.getQueueBufferSize() > 0) {
            this.queueBufferSizeField.setText(String.valueOf(properties.getQueueBufferSize()));
        } else {
            this.queueBufferSizeField.setText(String.valueOf(this.channelSetup.defaultQueueBufferSize));
        }
        this.processBatchLabel.setEnabled(propertiesInterface.canBatch());
        this.processBatchYesRadio.setEnabled(propertiesInterface.canBatch());
        this.processBatchNoRadio.setEnabled(propertiesInterface.canBatch());
        if (properties.isProcessBatch()) {
            this.processBatchYesRadio.setSelected(true);
        } else {
            this.processBatchNoRadio.setSelected(true);
        }
        this.batchResponseLabel.setEnabled(propertiesInterface.canBatch() && properties.isProcessBatch());
        this.batchResponseFirstRadio.setEnabled(propertiesInterface.canBatch() && properties.isProcessBatch());
        this.batchResponseLastRadio.setEnabled(propertiesInterface.canBatch() && properties.isProcessBatch());
        if (properties.isFirstResponse()) {
            this.batchResponseFirstRadio.setSelected(true);
        } else {
            this.batchResponseLastRadio.setSelected(true);
        }
        this.enableMaxProcessingThreads();
        this.processingThreadsField.setText(String.valueOf(properties.getProcessingThreads()));
    }

    public void updateResponseDropDown(SourceConnectorPropertiesInterface propertiesInterface, boolean channelLoad) {
        Collection vars;
        SourceConnectorProperties properties = propertiesInterface.getSourceConnectorProperties();
        boolean enabled = this.parent.isSaveEnabled();
        Channel channel = this.parent.channelEditPanel.currentChannel;
        LinkedHashSet<Object> variables = new LinkedHashSet<Object>();
        variables.addAll(Arrays.asList(SourceConnectorProperties.QUEUE_OFF_RESPONSES));
        ArrayList rulesToCheck = new ArrayList();
        rulesToCheck.addAll(channel.getSourceConnector().getFilter().getEnabledElements());
        ArrayList stepsToCheck = new ArrayList();
        stepsToCheck.addAll(channel.getSourceConnector().getTransformer().getEnabledElements());
        ArrayList<String> scripts = new ArrayList<String>();
        for (Connector connector : channel.getDestinationConnectors()) {
            ConnectorSettingsPanel tempConnector = LoadedExtensions.getInstance().getDestinationConnectors().get(connector.getTransportName());
            scripts.addAll(tempConnector.getScripts(connector.getProperties()));
            variables.add(new AbstractMap.SimpleEntry<String, String>("d" + String.valueOf(connector.getMetaDataId()), connector.getName()){

                @Override
                public String toString() {
                    return (String)this.getValue();
                }
            });
            rulesToCheck.addAll(connector.getFilter().getElements());
            stepsToCheck.addAll(connector.getTransformer().getElements());
            stepsToCheck.addAll(connector.getResponseTransformer().getElements());
        }
        for (Rule rule : rulesToCheck) {
            vars = rule.getResponseVariables();
            if (vars == null) continue;
            variables.addAll(vars);
        }
        for (Step step : stepsToCheck) {
            vars = step.getResponseVariables();
            if (vars != null) {
                variables.addAll(vars);
            }
            scripts.add(channel.getPreprocessingScript());
            scripts.add(channel.getPostprocessingScript());
            for (String script : scripts) {
                variables.addAll(JavaScriptSharedUtil.getResponseVariables((String)script));
            }
        }
        this.queueOnRespondFromNames = new ArrayList<String>(Arrays.asList(SourceConnectorProperties.QUEUE_ON_RESPONSES));
        this.queueOffRespondFromNames = new ArrayList<Object>(variables);
        if (channelLoad) {
            Object selectedItem = properties.getResponseVariable();
            for (Connector connector : channel.getDestinationConnectors()) {
                if (!selectedItem.equals("d" + String.valueOf(connector.getMetaDataId()))) continue;
                selectedItem = new AbstractMap.SimpleEntry<String, String>("d" + String.valueOf(connector.getMetaDataId()), connector.getName()){

                    @Override
                    public String toString() {
                        return (String)this.getValue();
                    }
                };
                break;
            }
            this.responseComboBox.setModel(new DefaultComboBoxModel<Object>(variables.toArray()));
            this.setSelectedItem(selectedItem);
        } else {
            this.updateSelectedResponseItem();
        }
        this.parent.setSaveEnabled(enabled);
    }

    private void updateSelectedResponseItem() {
        Object selectedItem = this.responseComboBox.getSelectedItem();
        if (this.sourceQueueComboBox.getSelectedIndex() == 0) {
            this.responseComboBox.setModel(new DefaultComboBoxModel<Object>(this.queueOffRespondFromNames.toArray()));
            this.queueBufferSizeLabel.setEnabled(false);
            this.queueBufferSizeField.setEnabled(false);
        } else {
            this.responseComboBox.setModel(new DefaultComboBoxModel<Object>(this.queueOnRespondFromNames.toArray()));
            this.queueBufferSizeLabel.setEnabled(true);
            this.queueBufferSizeField.setEnabled(true);
        }
        this.setSelectedItem(selectedItem);
        this.channelSetup.saveSourcePanel();
        MessageStorageMode messageStorageMode = this.channelSetup.getMessageStorageMode();
        this.channelSetup.updateQueueWarning(messageStorageMode);
        this.updateQueueWarning(messageStorageMode);
    }

    public void fillProperties(SourceConnectorPropertiesInterface propertiesInterface) {
        SourceConnectorProperties properties = propertiesInterface.getSourceConnectorProperties();
        properties.setQueueBufferSize(NumberUtils.toInt((String)this.queueBufferSizeField.getText()));
        if (this.responseComboBox.getSelectedItem() instanceof Map.Entry) {
            properties.setResponseVariable((String)((Map.Entry)this.responseComboBox.getSelectedItem()).getKey());
        } else {
            properties.setResponseVariable((String)this.responseComboBox.getSelectedItem());
        }
        properties.setRespondAfterProcessing(this.sourceQueueComboBox.getSelectedIndex() == 0);
        properties.setProcessBatch(this.processBatchYesRadio.isSelected());
        properties.setFirstResponse(this.batchResponseFirstRadio.isSelected());
        properties.setProcessingThreads(NumberUtils.toInt((String)this.processingThreadsField.getText(), (int)0));
    }

    public boolean checkProperties(SourceConnectorPropertiesInterface propertiesInterface, boolean highlight) {
        SourceConnectorProperties properties = propertiesInterface.getSourceConnectorProperties();
        boolean valid = true;
        if (highlight && properties.getQueueBufferSize() <= 0) {
            this.queueBufferSizeField.setBackground(UIConstants.INVALID_COLOR);
            valid = false;
        }
        if (properties.getProcessingThreads() <= 0) {
            this.processingThreadsField.setBackground(UIConstants.INVALID_COLOR);
            valid = false;
        }
        return valid;
    }

    private void setSelectedItem(Object selectedItem) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.responseComboBox.getModel();
        if (selectedItem instanceof Map.Entry) {
            for (int i = 0; i <= model.getSize() - 1; ++i) {
                if (!(model.getElementAt(i) instanceof Map.Entry) || !((String)((Map.Entry)selectedItem).getKey()).equals(((Map.Entry)model.getElementAt(i)).getKey())) continue;
                this.responseComboBox.setSelectedIndex(i);
                return;
            }
        } else if (model.getIndexOf(selectedItem) >= 0) {
            this.responseComboBox.setSelectedItem(selectedItem);
            return;
        }
        this.responseComboBox.setSelectedIndex(0);
    }

    public void resetInvalidProperties() {
        this.queueBufferSizeField.setBackground(null);
        this.processingThreadsField.setBackground(null);
    }

    public void updateQueueWarning(MessageStorageMode messageStorageMode) {
        switch (messageStorageMode) {
            case METADATA: 
            case DISABLED: {
                this.queueWarningLabel.setVisible(this.sourceQueueComboBox.getSelectedIndex() == 1);
                break;
            }
            default: {
                this.queueWarningLabel.setVisible(false);
            }
        }
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Source Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.sourceQueueLabel = new JLabel("Source Queue:");
        this.sourceQueueComboBox = new MirthComboBox();
        this.sourceQueueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"OFF (Respond after processing)", "ON (Respond before processing)"}));
        this.sourceQueueComboBox.setToolTipText("<html>Selecting OFF will process the message before sending the response (can use response from destinations)<br>Selecting ON will queue messages and immediately send a response (cannot use response from destinations)</html>");
        this.sourceQueueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSettingsPanel.this.sourceQueueComboBoxActionPerformed(evt);
            }
        });
        this.queueWarningLabel = new JLabel("Queuing is not supported by the current message storage mode.");
        this.queueWarningLabel.setForeground(Color.RED);
        this.queueBufferSizeLabel = new JLabel("Queue Buffer Size:");
        this.queueBufferSizeField = new MirthTextField();
        this.queueBufferSizeField.setDocument(new MirthFieldConstraints(0, false, false, true));
        this.queueBufferSizeField.setToolTipText("<html>The buffer size for the source queue.<br/>Up to this many connector messages may<br/>be held in memory at once when queuing.</html>");
        this.responseLabel = new JLabel("Response:");
        this.responseComboBox = new MirthComboBox();
        this.responseComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto-generate (After source transformer)", "None", "Auto-generate (Before processing)", "Auto-generate (After source transformer)", "Auto-generate (Destinations completed)", "Post-processor", "Destination 1"}));
        this.responseComboBox.setToolTipText("<html>Select a destination's response, the postprocessor return value, or a response map variable.<br/>Select <b>\"Auto-generate\"</b> to send a response generated by the inbound data type using the raw message:<br/>&nbsp;- <b>Before processing:</b> Response generated before the channel processes the message (SENT status)<br/>&nbsp;- <b>After source transformer:</b> Response generated after the channel processes the message (source status)<br/>&nbsp;- <b>Destinations completed:</b> Response generated after the channel processes the message, with a status<br/>&nbsp;&nbsp;&nbsp;&nbsp;based on the destination statuses, using a precedence of ERROR, QUEUED, SENT, FILTERED<br/></html>");
        this.processBatchLabel = new JLabel("Process Batch:");
        ButtonGroup processBatchButtonGroup = new ButtonGroup();
        this.processBatchYesRadio = new MirthRadioButton("Yes");
        this.processBatchYesRadio.setBackground(this.getBackground());
        this.processBatchYesRadio.setToolTipText("<html>Select Yes to enable batch processing. Batch messages are only supported if<br>the source connector's inbound properties contains a <b>Batch</b> section.</html>");
        this.processBatchYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSettingsPanel.this.processBatchYesRadioActionPerformed(evt);
            }
        });
        processBatchButtonGroup.add(this.processBatchYesRadio);
        this.processBatchNoRadio = new MirthRadioButton("No");
        this.processBatchNoRadio.setBackground(this.getBackground());
        this.processBatchNoRadio.setToolTipText("<html>Select Yes to enable batch processing. Batch messages are only supported if<br>the source connector's inbound properties contains a <b>Batch</b> section.</html>");
        this.processBatchNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSettingsPanel.this.processBatchNoRadioActionPerformed(evt);
            }
        });
        processBatchButtonGroup.add(this.processBatchNoRadio);
        this.batchResponseLabel = new JLabel("Batch Response:");
        ButtonGroup batchResponseButtonGroup = new ButtonGroup();
        this.batchResponseFirstRadio = new MirthRadioButton("First");
        this.batchResponseFirstRadio.setBackground(this.getBackground());
        this.batchResponseFirstRadio.setToolTipText("<html>Each message in the batch contains its own response that is generated via the method selected above.<br> Select either the response from the first or last message in the batch to be sent back to the originating system.</html>");
        batchResponseButtonGroup.add(this.batchResponseFirstRadio);
        this.batchResponseLastRadio = new MirthRadioButton("Last");
        this.batchResponseLastRadio.setBackground(this.getBackground());
        this.batchResponseLastRadio.setToolTipText("<html>Each message in the batch contains its own response that is generated via the method selected above.<br> Select either the response from the first or last message in the batch to be sent back to the originating system.</html>");
        batchResponseButtonGroup.add(this.batchResponseLastRadio);
        this.processingThreadsLabel = new JLabel("Max Processing Threads:");
        this.processingThreadsField = new MirthTextField();
        this.processingThreadsField.setDocument(new MirthFieldConstraints(0, false, false, true));
        this.processingThreadsField.setToolTipText("<html>The maximum number of messages that can process through<br/>the channel simultaneously. Note that when this value<br/>is greater than 1, message order is NOT guaranteed.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, gap 6 4", "[]12[]"));
        this.add((Component)this.sourceQueueLabel, "right");
        this.add((Component)this.sourceQueueComboBox, "split");
        this.add((Component)this.queueWarningLabel, "gapbefore 12");
        this.add((Component)this.queueBufferSizeLabel, "newline, right");
        this.add((Component)this.queueBufferSizeField, "w 50!");
        this.add((Component)this.responseLabel, "newline, right");
        this.add((Component)this.responseComboBox, "w 226:");
        this.add((Component)this.processBatchLabel, "newline, right");
        this.add((Component)this.processBatchYesRadio, "split");
        this.add(this.processBatchNoRadio);
        this.add((Component)this.batchResponseLabel, "newline, right");
        this.add((Component)this.batchResponseFirstRadio, "split");
        this.add(this.batchResponseLastRadio);
        this.add((Component)this.processingThreadsLabel, "newline, right");
        this.add((Component)this.processingThreadsField, "w 50!");
    }

    private void sourceQueueComboBoxActionPerformed(ActionEvent evt) {
        this.updateSelectedResponseItem();
    }

    private void processBatchYesRadioActionPerformed(ActionEvent evt) {
        this.batchResponseLabel.setEnabled(true);
        this.batchResponseFirstRadio.setEnabled(true);
        this.batchResponseLastRadio.setEnabled(true);
    }

    private void processBatchNoRadioActionPerformed(ActionEvent evt) {
        this.batchResponseLabel.setEnabled(false);
        this.batchResponseFirstRadio.setEnabled(false);
        this.batchResponseLastRadio.setEnabled(false);
    }
}

