/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.reference;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jdesktop.swingx.JXTable;

public class ReferenceTable
extends JXTable {
    protected Frame parent = PlatformUI.MIRTH_FRAME;

    public ReferenceTable() {
        this.setTransferHandler(new TableTransferHandler());
        this.setDragEnabled(true);
        this.setFocusable(false);
        this.setOpaque(true);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setRowHeight(20);
        this.packTable(10);
        this.setShowVerticalLines(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ReferenceTable.this.refTableMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                ReferenceTable.this.refTableMouseMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ReferenceTable.this.refTableMouseExited(evt);
            }
        });
    }

    private void refTableMouseExited(MouseEvent evt) {
        if (evt.getModifiersEx() != 1024) {
            this.clearSelection();
        }
    }

    private void refTableMouseDragged(MouseEvent evt) {
    }

    private void refTableMouseMoved(MouseEvent evt) {
        int row = this.rowAtPoint(evt.getPoint());
        int col = this.columnAtPoint(evt.getPoint());
        if (row >= 0 && row < this.getModel().getRowCount() && col >= 0 && col < this.getModel().getColumnCount()) {
            this.setRowSelectionInterval(row, row);
        }
    }

    public class TableTransferHandler
    extends TransferHandler {
        int row = -1;

        protected String exportString(JComponent c) {
            JXTable table = (JXTable)c;
            this.row = table.getSelectedRow();
            if (this.row >= 0 && this.row < table.getRowCount()) {
                return table.getValueAt(this.row, 0).toString();
            }
            return "";
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new StringSelection(this.exportString(c));
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }
}

