/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.reference;

import com.mirth.connect.client.ui.panels.reference.ReferenceTable;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class VariableReferenceTable
extends ReferenceTable {
    private Object[] tooltip;
    private String headerName = "blank";

    public VariableReferenceTable() {
        this.makeTable(null, null);
    }

    public VariableReferenceTable(String headerName, Object[] data) {
        this.makeTable(headerName, data, null);
    }

    public VariableReferenceTable(String headerName, Object[] data, Object[] tooltip) {
        this.makeTable(headerName, data, tooltip);
    }

    public VariableReferenceTable(String headerName, List<CodeTemplate> listItems) {
        this.makeTable(headerName, listItems);
    }

    private void makeTable(String headerName, List<CodeTemplate> listItems) {
        if (listItems == null) {
            return;
        }
        Object[] tooltips = new String[listItems.size()];
        Object[] names = new String[listItems.size()];
        Iterator<CodeTemplate> listItemIterator = listItems.iterator();
        int i = 0;
        while (listItemIterator.hasNext()) {
            CodeTemplate listItem = listItemIterator.next();
            names[i] = listItem.getName();
            tooltips[i] = listItem.getDescription();
            ++i;
        }
        this.makeTable(headerName, names, tooltips);
    }

    private void makeTable(String headerName, Object[] data, Object[] tooltip) {
        if (data == null) {
            return;
        }
        this.headerName = headerName;
        this.tooltip = tooltip;
        Object[][] d = new String[data.length][2];
        for (int i = 0; i < data.length; ++i) {
            d[i][0] = data[i];
            d[i][1] = null;
        }
        this.setModel(new FilterTableModel(d, new Object[]{headerName}){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        this.getColumnExt(headerName).setPreferredWidth(80);
    }

    public String getToolTipText(MouseEvent event) {
        Object o;
        int row;
        Point p = event.getPoint();
        int col = this.columnAtPoint(p);
        if (col != -1) {
            col = this.convertColumnIndexToModel(col);
        }
        if ((row = this.rowAtPoint(p)) != -1) {
            row = this.convertRowIndexToModel(row);
        }
        if (col >= 0 && row >= 0 && this.tooltip != null && (o = ((FilterTableModel)this.getModel()).getValueAt(row, col)) != null) {
            return "<html><body style=\"width:150px\"><p>" + String.valueOf(this.tooltip[row]) + "</p></body></html>";
        }
        return null;
    }

    public void updateVariables(Set<String> variables) {
        Object[][] d = new String[variables.toArray().length][2];
        for (int j = 0; j < variables.toArray().length; ++j) {
            d[j][0] = variables.toArray()[j];
            d[j][1] = null;
        }
        this.setModel(new FilterTableModel(d, new Object[]{this.headerName}){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
    }

    public void performFilter(String filterString) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof FilterTableModel) {
            FilterTableModel filterTableModel = (FilterTableModel)tableModel;
            filterTableModel.performFilter(filterString);
        }
    }

    public class FilterTableModel
    extends DefaultTableModel {
        public FilterTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void performFilter(final String filterString) {
            if (filterString == null) {
                return;
            }
            RowFilter<Object, Object> rowFilter = new RowFilter<Object, Object>(){

                @Override
                public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                    try {
                        String name = entry.getStringValue(0);
                        if (name == null) {
                            return false;
                        }
                        return filterString.trim().isEmpty() || name.trim().toLowerCase().contains(filterString.trim().toLowerCase());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        return false;
                    }
                }
            };
            VariableReferenceTable.this.setRowFilter(rowFilter);
        }
    }
}

