/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.reference;

import com.mirth.connect.client.ui.reference.CodeReference;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import org.apache.commons.lang3.StringUtils;

public class ParameterizedCodeReference
extends CodeReference {
    private String definitionString;
    private String template;

    public ParameterizedCodeReference(CodeTemplateContextSet contextSet, String category, String name, String description, String template) {
        super(contextSet, category, name, description, template.replaceAll("\\$\\{([^\\}]+)\\}", "$1"));
        this.definitionString = name.toLowerCase().replace(' ', '-');
        this.template = template.replaceAll("\\$(?!\\{)", "\\$\\$");
        this.setIconName("template");
        this.setSummary("<html><body><h4><b>" + StringUtils.trimToEmpty((String)name) + "</b></h4><hr/>" + StringUtils.trimToEmpty((String)description) + "<br/><br/><hr/><br/><code>" + StringUtils.trimToEmpty((String)this.getReplacementCode()).replaceAll("\r\n|\r|\n", "<br/>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;") + "</code></body></html>");
    }

    public String getDefinitionString() {
        return this.definitionString;
    }

    public void setDefinitionString(String definitionString) {
        this.definitionString = definitionString;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

