/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.reference;

import com.mirth.connect.client.ui.components.rsta.ac.MirthCompletion;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public abstract class Reference {
    private String id = UUID.randomUUID().toString();
    private Type type;
    private CodeTemplateContextSet contextSet;
    private String category;
    private String name;
    private String description;
    private String replacementCode;
    private String summary;
    private String iconName;
    private boolean deprecated;

    public Reference(Type type, CodeTemplateContextSet contextSet, String category) {
        this(type, contextSet, category, null);
    }

    public Reference(Type type, CodeTemplateContextSet contextSet, String category, String name) {
        this(type, contextSet, category, name, null, null);
    }

    public Reference(Type type, CodeTemplateContextSet contextSet, String category, String name, String description, String replacementCode) {
        this.type = type;
        this.contextSet = contextSet;
        this.category = category;
        this.name = name;
        this.description = description;
        this.replacementCode = replacementCode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public CodeTemplateContextSet getContextSet() {
        return this.contextSet;
    }

    public void setContextSet(CodeTemplateContextSet contextSet) {
        this.contextSet = contextSet;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getReplacementCode() {
        return this.replacementCode;
    }

    public void setReplacementCode(String replacementCode) {
        this.replacementCode = replacementCode;
    }

    public String getSummary() {
        if (StringUtils.isNotBlank((CharSequence)this.summary)) {
            return this.summary;
        }
        return this.getDescription();
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public CodeTemplate toCodeTemplate() {
        return new CodeTemplate(this.name, this.getCodeTemplateType(this.type), this.contextSet, this.replacementCode, this.description);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MirthCompletion) {
            return ((MirthCompletion)obj).getId().equals(this.id);
        }
        if (obj instanceof Reference) {
            return ((Reference)obj).getId().equals(this.id);
        }
        return false;
    }

    private CodeTemplateProperties.CodeTemplateType getCodeTemplateType(Type type) {
        return type == Type.FUNCTION ? CodeTemplateProperties.CodeTemplateType.FUNCTION : CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE;
    }

    public static enum Type {
        CLASS,
        FUNCTION,
        VARIABLE,
        CODE;

    }
}

