/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.tag;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.tag.TagLabel;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.util.ColorUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class ChannelTagLabelCache {
    private static final BufferedImage tagImage = ColorUtil.toBufferedImage((Image)UIConstants.ICON_TAG_GRAY.getImage());
    private static volatile ChannelTagLabelCache instance = null;
    private Map<ChannelTag, TagLabel> textModeMap = new HashMap<ChannelTag, TagLabel>();
    private Map<ChannelTag, TagLabel> iconModeMap = new HashMap<ChannelTag, TagLabel>();

    private ChannelTagLabelCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelTagLabelCache getInstance() {
        ChannelTagLabelCache cache = instance;
        if (cache != null) return cache;
        Class<ChannelTagLabelCache> clazz = ChannelTagLabelCache.class;
        synchronized (ChannelTagLabelCache.class) {
            cache = instance;
            if (cache != null) return cache;
            instance = cache = new ChannelTagLabelCache();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    public TagLabel getLabel(ChannelTag tag, boolean textMode) {
        Map<ChannelTag, TagLabel> map = textMode ? this.textModeMap : this.iconModeMap;
        TagLabel label = map.get(tag);
        if (label == null) {
            label = this.createLabel(tag, textMode);
            map.put(tag, label);
        }
        return label;
    }

    public void removeExpiredTags(Set<ChannelTag> allTags) {
        this.removeExpiredTags(allTags, this.textModeMap);
        this.removeExpiredTags(allTags, this.iconModeMap);
    }

    private void removeExpiredTags(Set<ChannelTag> allTags, Map<ChannelTag, TagLabel> map) {
        Iterator<ChannelTag> it = map.keySet().iterator();
        while (it.hasNext()) {
            if (allTags.contains(it.next())) continue;
            it.remove();
        }
    }

    private TagLabel createLabel(ChannelTag tag, boolean textMode) {
        TagLabel tagLabel = new TagLabel();
        tagLabel.setToolTipText(tag.getName());
        if (textMode) {
            tagLabel.decorate(true);
            tagLabel.setBackground(tag.getBackgroundColor());
            tagLabel.setForeground(ColorUtil.getForegroundColor((Color)tag.getBackgroundColor()));
            tagLabel.setText(" " + tag.getName() + " ");
        } else {
            tagLabel.setIcon(new ImageIcon(ColorUtil.tint((BufferedImage)tagImage, (Color)tag.getBackgroundColor(), (Color)ColorUtil.getForegroundColor((Color)tag.getBackgroundColor()))));
        }
        return tagLabel;
    }
}

