/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.tag;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTriStateCheckBox;
import com.mirth.connect.client.ui.tag.ChannelTagLabelCache;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SettingsPanelTags
extends AbstractSettingsPanel {
    public static final String TAB_NAME = "Tags";
    private static final int TAGS_NAME_COLUMN = 0;
    private static final int TAGS_BACKGROUND_COLUMN = 1;
    private static final int TAGS_CHANNEL_COUNT_COLUMN = 2;
    private static final int TAGS_TAG_COLUMN = 3;
    private static final int CHANNELS_SELECTED_COLUMN = 0;
    private static final int CHANNELS_NAME_COLUMN = 1;
    private static final int CHANNELS_ID_COLUMN = 2;
    private Set<ChannelTag> cachedChannelTags = new HashSet<ChannelTag>();
    private AtomicBoolean channelsTableAdjusting = new AtomicBoolean(false);
    private JPanel container;
    private JPanel leftPanel;
    private MirthTable tagsTable;
    private JScrollPane tagsScrollPane;
    private JButton tagsAddButton;
    private JButton tagsRemoveButton;
    private JPanel channelsSeparator;
    private JLabel channelsLabel;
    private JLabel channelsFilterLabel;
    private JTextField channelFilterField;
    private JLabel channelsSelectAllLabel;
    private JLabel channelsSelectSeparator;
    private JLabel channelsDeselectAllLabel;
    private MirthTable channelsTable;
    private JScrollPane channelsScrollPane;

    public SettingsPanelTags(String tabName) {
        super(tabName);
        this.initComponents();
        this.initLayout();
    }

    public Set<ChannelTag> getCachedChannelTags() {
        return this.cachedChannelTags;
    }

    @Override
    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Loading tags...");
        final int[] selectedRows = this.tagsTable.getSelectedRows();
        SwingWorker<Set<ChannelTag>, Void> worker = new SwingWorker<Set<ChannelTag>, Void>(){

            @Override
            public Set<ChannelTag> doInBackground() throws ClientException {
                if (MapUtils.isEmpty(SettingsPanelTags.this.getFrame().channelPanel.getCachedChannelIdsAndNames())) {
                    SettingsPanelTags.this.getFrame().channelPanel.retrieveChannelIdsAndNames();
                }
                return SettingsPanelTags.this.getFrame().mirthClient.getChannelTags();
            }

            @Override
            public void done() {
                try {
                    SettingsPanelTags.this.updateTagsTable((Set)this.get(), selectedRows, true);
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelTags.this.getFrame().alertThrowable((Component)((Object)SettingsPanelTags.this.getFrame()), t, "Error loading tags: " + t.toString());
                }
                finally {
                    SettingsPanelTags.this.getFrame().stopWorking(workingId);
                }
            }
        };
        worker.execute();
    }

    public void refresh() {
        try {
            this.updateTagsTable(this.getFrame().mirthClient.getChannelTags(), this.tagsTable.getSelectedRows(), false);
        }
        catch (Throwable t) {
            this.getFrame().alertThrowable((Component)((Object)this.getFrame()), t, "Error loading tags: " + t.toString(), false);
        }
    }

    public void updateTagsTable(Set<ChannelTag> tags) {
        this.updateTagsTable(tags, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTagsTable(Set<ChannelTag> tags, int[] selectedRows, boolean clearSaveEnabled) {
        ArrayList<ChannelTag> tagList = new ArrayList<ChannelTag>(tags);
        Collections.sort(tagList, new Comparator<ChannelTag>(){

            @Override
            public int compare(ChannelTag o1, ChannelTag o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.cachedChannelTags = new LinkedHashSet<ChannelTag>(tagList);
        ChannelTagLabelCache.getInstance().removeExpiredTags(this.cachedChannelTags);
        Object[][] data = new Object[tagList.size()][4];
        int i = 0;
        for (ChannelTag tag : tagList) {
            data[i][0] = tag.getName();
            data[i][1] = tag.getBackgroundColor();
            data[i][2] = tag.getChannelIds().size();
            data[i][3] = new ChannelTag(tag);
            ++i;
        }
        ((RefreshTableModel)this.tagsTable.getModel()).refreshDataVector(data);
        this.channelsTableAdjusting.set(true);
        try {
            Map<String, String> channelIdsAndNames = this.getFrame().channelPanel.getCachedChannelIdsAndNames();
            Object[][] channelData = new Object[channelIdsAndNames.size()][3];
            i = 0;
            for (Map.Entry<String, String> entry : channelIdsAndNames.entrySet()) {
                channelData[i][0] = 1;
                channelData[i][1] = entry.getValue();
                channelData[i][2] = entry.getKey();
                ++i;
            }
            ((RefreshTableModel)this.channelsTable.getModel()).refreshDataVector(channelData);
        }
        finally {
            this.channelsTableAdjusting.set(false);
        }
        if (selectedRows != null) {
            this.tagsTable.clearSelection();
            for (Object selectedRow : (Object)selectedRows) {
                if (selectedRow >= this.tagsTable.getRowCount()) continue;
                this.tagsTable.addRowSelectionInterval((int)selectedRow, (int)selectedRow);
            }
        } else if (this.tagsTable.getRowCount() > 0) {
            this.tagsTable.setRowSelectionInterval(0, 0);
        } else {
            this.tagsTable.clearSelection();
        }
        this.tagSelectionChanged();
        if (clearSaveEnabled) {
            this.setSaveEnabled(false);
        }
    }

    @Override
    public boolean doSave() {
        final String workingId = this.getFrame().startWorking("Saving tags...");
        final HashSet<ChannelTag> tags = new HashSet<ChannelTag>();
        for (int row = 0; row < this.tagsTable.getModel().getRowCount(); ++row) {
            ChannelTag tag = (ChannelTag)this.tagsTable.getModel().getValueAt(row, 3);
            tag.setName((String)this.tagsTable.getModel().getValueAt(row, 0));
            tag.setBackgroundColor((Color)this.tagsTable.getModel().getValueAt(row, 1));
            tags.add(tag);
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws ClientException {
                SettingsPanelTags.this.getFrame().mirthClient.setChannelTags(tags);
                return null;
            }

            @Override
            public void done() {
                try {
                    this.get();
                    SettingsPanelTags.this.setSaveEnabled(false);
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    SettingsPanelTags.this.getFrame().alertThrowable((Component)((Object)SettingsPanelTags.this.getFrame()), t, "Error saving tags: " + t.toString());
                }
                finally {
                    SettingsPanelTags.this.getFrame().stopWorking(workingId);
                }
            }
        };
        worker.execute();
        return true;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.container = new JPanel();
        this.container.setBackground(this.getBackground());
        this.container.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), TAB_NAME, 0, 0, new Font("Tahoma", 1, 11)));
        this.leftPanel = new JPanel();
        this.leftPanel.setBackground(this.getBackground());
        this.tagsTable = new MirthTable();
        this.tagsTable.setModel(new RefreshTableModel(new Object[]{"Name", "Color", "Channel Count", "Tag"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0 || column == 1;
            }
        });
        this.tagsTable.setDragEnabled(false);
        this.tagsTable.setRowSelectionAllowed(true);
        this.tagsTable.setSelectionMode(2);
        this.tagsTable.setRowHeight(20);
        this.tagsTable.setFocusable(true);
        this.tagsTable.setOpaque(true);
        this.tagsTable.setEditable(true);
        this.tagsTable.setSortable(true);
        this.tagsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tagsTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.tagsTable.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = SettingsPanelTags.this.tagsTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.tagsTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.tagsTable.getColumnExt(0).setCellEditor((TableCellEditor)new TagNameCellEditor());
        this.tagsTable.getColumnExt(1).setWidth(90);
        this.tagsTable.getColumnExt(1).setMinWidth(90);
        this.tagsTable.getColumnExt(1).setMaxWidth(90);
        this.tagsTable.getColumnExt(1).setCellEditor((TableCellEditor)new ColorChooserCellEditor());
        this.tagsTable.getColumnExt(1).setCellRenderer((TableCellRenderer)new CustomColorCellRenderer());
        this.tagsTable.getColumnExt(2).setWidth(90);
        this.tagsTable.getColumnExt(2).setMinWidth(90);
        this.tagsTable.getColumnExt(2).setMaxWidth(90);
        this.tagsTable.getColumnExt(2).setEditable(false);
        this.tagsTable.getColumnExt(2).setComparator(ComparatorUtils.NATURAL_COMPARATOR);
        DefaultTableCellRenderer centerAlignedRenderer = new DefaultTableCellRenderer();
        centerAlignedRenderer.setHorizontalAlignment(0);
        this.tagsTable.getColumnExt(2).setCellRenderer((TableCellRenderer)centerAlignedRenderer);
        this.tagsTable.getColumnExt(3).setVisible(false);
        this.tagsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                if (SettingsPanelTags.this.tagsTable.rowAtPoint(new Point(evt.getX(), evt.getY())) < 0) {
                    SettingsPanelTags.this.tagsTable.clearSelection();
                }
            }
        });
        this.tagsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SettingsPanelTags.this.tagSelectionChanged();
            }
        });
        this.tagsScrollPane = new JScrollPane((Component)((Object)this.tagsTable));
        this.tagsAddButton = new MirthButton("Add");
        this.tagsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelTags.this.addTag();
            }
        });
        this.tagsRemoveButton = new MirthButton("Remove");
        this.tagsRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelTags.this.removeTag();
            }
        });
        this.channelsSeparator = new JPanel();
        this.channelsSeparator.setBackground(this.getBackground());
        this.channelsSeparator.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Channels", 0, 0, new Font("Tahoma", 1, 11)));
        this.channelsLabel = new JLabel("Channel selections will be applied to the currently selected tags.");
        this.channelsFilterLabel = new JLabel("Filter:");
        this.channelFilterField = new JTextField();
        this.channelFilterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.filterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.filterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.filterChanged();
            }

            private void filterChanged() {
                SettingsPanelTags.this.channelsTable.getRowSorter().allRowsChanged();
            }
        });
        this.channelsSelectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.channelsSelectAllLabel.setForeground(Color.BLUE);
        this.channelsSelectAllLabel.setCursor(new Cursor(12));
        this.channelsSelectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getComponent().isEnabled()) {
                    for (int row = 0; row < SettingsPanelTags.this.channelsTable.getRowCount(); ++row) {
                        SettingsPanelTags.this.channelsTable.setValueAt(0, row, 0);
                    }
                    SettingsPanelTags.this.setSaveEnabled(true);
                }
            }
        });
        this.channelsSelectSeparator = new JLabel("|");
        this.channelsDeselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.channelsDeselectAllLabel.setForeground(Color.BLUE);
        this.channelsDeselectAllLabel.setCursor(new Cursor(12));
        this.channelsDeselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getComponent().isEnabled()) {
                    for (int row = 0; row < SettingsPanelTags.this.channelsTable.getRowCount(); ++row) {
                        SettingsPanelTags.this.channelsTable.setValueAt(1, row, 0);
                    }
                    SettingsPanelTags.this.setSaveEnabled(true);
                }
            }
        });
        this.channelsTable = new MirthTable();
        this.channelsTable.setModel(new RefreshTableModel(new String[]{"", "Name", "Id"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        });
        this.channelsTable.setDragEnabled(false);
        this.channelsTable.setRowSelectionAllowed(false);
        this.channelsTable.setRowHeight(20);
        this.channelsTable.setFocusable(false);
        this.channelsTable.setOpaque(true);
        this.channelsTable.getTableHeader().setReorderingAllowed(false);
        this.channelsTable.setEditable(true);
        this.channelsTable.setSortable(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.channelsTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.channelsTable.getModel());
        rowSorter.setComparator(0, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (Objects.equals(o1, o2)) {
                    return 0;
                }
                if (o1 == 0 || o1 == 2 && o2 == 1) {
                    return -1;
                }
                return 1;
            }
        });
        this.channelsTable.setRowSorter(rowSorter);
        RowFilter<TableModel, Integer> rowFilter = new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                String name = entry.getStringValue(1);
                return StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)SettingsPanelTags.this.channelFilterField.getText());
            }
        };
        rowSorter.setRowFilter(rowFilter);
        this.channelsTable.setRowFilter(rowFilter);
        this.channelsTable.getColumnExt(0).setMinWidth(20);
        this.channelsTable.getColumnExt(0).setMaxWidth(20);
        this.channelsTable.getColumn(0).setCellEditor(new TagSelectionCellEditor());
        this.channelsTable.getColumn(0).setCellRenderer(new TagSelectionCellRenderer());
        this.channelsTable.getColumnExt(2).setVisible(false);
        this.channelsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                if (!SettingsPanelTags.this.channelsTableAdjusting.get()) {
                    for (int row = 0; row < SettingsPanelTags.this.channelsTable.getModel().getRowCount(); ++row) {
                        int state = (Integer)SettingsPanelTags.this.channelsTable.getModel().getValueAt(row, 0);
                        String channelId = (String)SettingsPanelTags.this.channelsTable.getModel().getValueAt(row, 2);
                        if (state != 0 && state != 1) continue;
                        for (int tagRow : SettingsPanelTags.this.tagsTable.getSelectedModelRows()) {
                            ChannelTag tag = (ChannelTag)SettingsPanelTags.this.tagsTable.getModel().getValueAt(tagRow, 3);
                            if (state == 0) {
                                tag.getChannelIds().add(channelId);
                            } else {
                                tag.getChannelIds().remove(channelId);
                            }
                            SettingsPanelTags.this.tagsTable.getModel().setValueAt(tag.getChannelIds().size(), tagRow, 2);
                        }
                    }
                    SettingsPanelTags.this.setSaveEnabled(true);
                }
            }
        });
        this.channelsScrollPane = new JScrollPane((Component)((Object)this.channelsTable));
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        this.container.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.leftPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill", "", "[grow 100][]0[][grow 25]"));
        this.leftPanel.add((Component)this.tagsScrollPane, "grow 100, sx");
        this.leftPanel.add((Component)this.channelsSeparator, "newline, growx, sx, h 14!");
        this.leftPanel.add((Component)this.channelsLabel, "newline");
        this.leftPanel.add((Component)this.channelsFilterLabel, "right, split 5");
        this.leftPanel.add((Component)this.channelFilterField, "w 100:350");
        this.leftPanel.add((Component)this.channelsSelectAllLabel, "gapbefore 12");
        this.leftPanel.add(this.channelsSelectSeparator);
        this.leftPanel.add(this.channelsDeselectAllLabel);
        this.leftPanel.add((Component)this.channelsScrollPane, "newline, grow 25, sx");
        this.container.add((Component)this.leftPanel, "grow, push");
        this.container.add((Component)this.tagsAddButton, "top, flowy, split 2, w 60!");
        this.container.add((Component)this.tagsRemoveButton, "w 60!");
        this.add((Component)this.container, "grow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tagSelectionChanged() {
        HashSet partialChannelIds = new HashSet();
        HashSet selectedChannelIds = null;
        int[] selectedModelRows = this.tagsTable.getSelectedModelRows();
        if (selectedModelRows.length > 0) {
            this.channelsTable.setEnabled(true);
            this.tagsRemoveButton.setEnabled(true);
            this.channelsSelectAllLabel.setEnabled(true);
            this.channelsDeselectAllLabel.setEnabled(true);
            for (int selectedRow : selectedModelRows) {
                ChannelTag tag = (ChannelTag)this.tagsTable.getModel().getValueAt(selectedRow, 3);
                partialChannelIds.addAll(tag.getChannelIds());
                selectedChannelIds = selectedChannelIds == null ? new HashSet(tag.getChannelIds()) : new HashSet(CollectionUtils.intersection(selectedChannelIds, (Iterable)tag.getChannelIds()));
            }
        } else {
            this.channelsTable.setEnabled(false);
            this.tagsRemoveButton.setEnabled(false);
            this.channelsSelectAllLabel.setEnabled(false);
            this.channelsDeselectAllLabel.setEnabled(false);
            selectedChannelIds = new HashSet();
        }
        this.channelsTableAdjusting.set(true);
        try {
            for (int row = 0; row < this.channelsTable.getModel().getRowCount(); ++row) {
                String channelId = (String)this.channelsTable.getModel().getValueAt(row, 2);
                if (selectedChannelIds.contains(channelId)) {
                    this.channelsTable.getModel().setValueAt(0, row, 0);
                    continue;
                }
                if (partialChannelIds.contains(channelId)) {
                    this.channelsTable.getModel().setValueAt(2, row, 0);
                    continue;
                }
                this.channelsTable.getModel().setValueAt(1, row, 0);
            }
            try {
                this.channelsTable.updateUI();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.channelsTableAdjusting.set(false);
        }
    }

    private void addTag() {
        String name = this.getNewTagName();
        ((RefreshTableModel)this.tagsTable.getModel()).addRow(new Object[]{name, ColorUtil.getNewColor(), 0, new ChannelTag(name)});
        this.tagsTable.setRowSelectionInterval(this.tagsTable.getRowCount() - 1, this.tagsTable.getRowCount() - 1);
    }

    private String getNewTagName() {
        String name;
        int num = 1;
        while (this.tagNameExists(name = "Tag " + num++)) {
        }
        return name;
    }

    private boolean tagNameExists(String name) {
        for (int row = 0; row < this.tagsTable.getModel().getRowCount(); ++row) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((String)this.tagsTable.getModel().getValueAt(row, 0)), (CharSequence)name)) continue;
            return true;
        }
        return false;
    }

    private void removeTag() {
        int[] selectedRows = this.tagsTable.getSelectedRows();
        int[] selectedModelRows = this.tagsTable.getSelectedModelRows();
        if (selectedModelRows.length > 0) {
            Arrays.sort(selectedRows);
            Arrays.sort(selectedModelRows);
            for (int i = selectedModelRows.length - 1; i >= 0; --i) {
                ((RefreshTableModel)this.tagsTable.getModel()).removeRow(selectedModelRows[i]);
            }
            if (selectedRows[0] < this.tagsTable.getRowCount()) {
                this.tagsTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
            } else if (this.tagsTable.getRowCount() > 0) {
                this.tagsTable.setRowSelectionInterval(this.tagsTable.getRowCount() - 1, this.tagsTable.getRowCount() - 1);
            }
        }
    }

    private class TagNameCellEditor
    extends TextFieldCellEditor {
        public TagNameCellEditor() {
            this.getTextField().setDocument(new MirthFieldConstraints(24, false, true, true));
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            return evt != null && evt instanceof MouseEvent && ((MouseEvent)evt).getClickCount() >= 2;
        }

        @Override
        protected boolean valueChanged(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return false;
            }
            for (int row = 0; row < SettingsPanelTags.this.tagsTable.getRowCount(); ++row) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)((String)SettingsPanelTags.this.tagsTable.getValueAt(row, 0)))) continue;
                return false;
            }
            SettingsPanelTags.this.setSaveEnabled(true);
            return true;
        }
    }

    private class ColorChooserCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Color originalColor;
        private ColorPanel colorPanel;

        public ColorChooserCellEditor() {
            this.colorPanel = new ColorPanel();
            this.colorPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Color color = JColorChooser.showDialog((Component)((Object)PlatformUI.MIRTH_FRAME), "Edit Background Color", ColorChooserCellEditor.this.originalColor);
                    ColorChooserCellEditor.this.changeColor(color);
                    ColorChooserCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.originalColor;
        }

        private void changeColor(Color color) {
            if (this.originalColor == null || color != null && this.originalColor != color) {
                SettingsPanelTags.this.setSaveEnabled(this.originalColor != null);
                this.colorPanel.setColor(color);
                this.originalColor = color;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.colorPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            if (value instanceof Color) {
                this.changeColor((Color)value);
            }
            return this.colorPanel;
        }
    }

    private class CustomColorCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private CustomColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ColorPanel colorPanel = new ColorPanel((Color)value);
            colorPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return colorPanel;
        }
    }

    private class TagSelectionCellEditor
    extends DefaultCellEditor {
        private MirthTriStateCheckBox checkBox;
        private JPanel panel;

        public TagSelectionCellEditor() {
            super(new MirthTriStateCheckBox());
            this.checkBox = (MirthTriStateCheckBox)this.editorComponent;
            this.panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkBox.getState();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value != null) {
                this.checkBox.setState((Integer)value);
            }
            this.panel.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            this.checkBox.setBackground(this.panel.getBackground());
            return this.panel;
        }
    }

    private class TagSelectionCellRenderer
    implements TableCellRenderer {
        private MirthTriStateCheckBox checkBox;
        private JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));

        public TagSelectionCellRenderer() {
            this.checkBox = new MirthTriStateCheckBox();
            this.panel.add((Component)this.checkBox, "center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.checkBox.setState((Integer)value);
            }
            this.panel.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
            this.checkBox.setBackground(this.panel.getBackground());
            return this.panel;
        }
    }

    private class ColorPanel
    extends JPanel {
        private static final int SIZE = 18;
        private Color color;

        public ColorPanel() {
        }

        public ColorPanel(Color color) {
            this.color = color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.color != null) {
                g.setColor(this.color);
                g.fillRect(this.getWidth() / 2 - 9, 1, 18, 18);
            }
        }
    }
}

