/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.math.NumberUtils;

public class DisplayUtil {
    public static String formatNumber(int number) {
        StringBuilder str = new StringBuilder();
        Formatter f = new Formatter(str, Locale.getDefault());
        f.format("%,d", number);
        return str.toString();
    }

    public static String formatNumber(long number) {
        StringBuilder str = new StringBuilder();
        Formatter f = new Formatter(str, Locale.getDefault());
        f.format("%,d", number);
        return str.toString();
    }

    public static String formatNumber(float number) {
        StringBuilder str = new StringBuilder();
        Formatter f = new Formatter(str, Locale.getDefault());
        f.format("%,.0f", Float.valueOf(number));
        return str.toString();
    }

    public static void setResizable(Dialog dialog, boolean resizable) {
        if (DisplayUtil.isJDK11OrGreater()) {
            resizable = true;
        }
        dialog.setResizable(resizable);
    }

    public static void setResizable(Frame frame, boolean resizable) {
        if (DisplayUtil.isJDK11OrGreater()) {
            resizable = true;
        }
        frame.setResizable(resizable);
    }

    public static boolean isJDK11OrGreater() {
        String version = System.getProperty("java.version");
        int index = version.indexOf(45);
        if (index > 0) {
            version = version.substring(0, index);
        }
        if ((index = version.indexOf(46)) > 0) {
            version = version.substring(0, index);
        }
        return NumberUtils.toDouble((String)version) >= 11.0;
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) throws HeadlessException {
        return DisplayUtil.showInputDialog(parentComponent, message, "Input", 3, null, null, initialSelectionValue);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return DisplayUtil.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        JOptionPane optionPane = new JOptionPane(message, messageType, 2);
        optionPane.setWantsInput(true);
        optionPane.setSelectionValues(selectionValues);
        optionPane.setInitialSelectionValue(initialSelectionValue);
        optionPane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        JDialog dialog = optionPane.createDialog(parentComponent, title);
        DisplayUtil.setResizable(dialog, false);
        optionPane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object value = optionPane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return (String)value;
    }
}

