/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.util;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.model.Channel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class PortUsageDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private MirthTable portsTable;
    private JScrollPane portsScrollPane;
    private JSeparator separator;
    private JButton closeButton;

    public PortUsageDialog(Window owner) {
        super(owner, "Ports in Use", true);
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.setPorts();
        this.setPreferredSize(new Dimension(600, 216));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.portsTable = new MirthTable();
        this.portsTable.setModel(new RefreshTableModel(new Object[]{"Port", "Channel Name", "Status"}, 0));
        this.portsTable.setDragEnabled(false);
        this.portsTable.setRowSelectionAllowed(true);
        this.portsTable.setSelectionMode(0);
        this.portsTable.setRowHeight(20);
        this.portsTable.setFocusable(true);
        this.portsTable.setOpaque(true);
        this.portsTable.getTableHeader().setReorderingAllowed(true);
        this.portsTable.setEditable(false);
        this.portsTable.setSortable(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.portsTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.portsTable.getColumnExt(0).setPreferredWidth(25);
        this.portsTable.getColumnExt(1).setPreferredWidth(300);
        this.portsTable.getColumnExt(2).setPreferredWidth(25);
        this.portsScrollPane = new JScrollPane((Component)((Object)this.portsTable));
        this.separator = new JSeparator();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(evt -> this.close());
        this.getRootPane().registerKeyboardAction(evt -> this.close(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void initToolTips() {
        this.portsTable.getColumnExt(0).setToolTipText("<html>The listener port number in use.</html>");
        this.portsTable.getColumnExt(1).setToolTipText("<html>The channel name to which the listenser port is assigned.</html>");
        this.portsTable.getColumnExt(2).setToolTipText("<html>The status of the listener port, such as:<br> - started or stopped for deployed channels<br> - enabled or disabled for undeployed channels</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        this.add((Component)this.portsScrollPane, "grow, push");
        this.add((Component)this.separator, "newline, sx, growx");
        this.add((Component)this.closeButton, "right");
    }

    private void setPorts() {
        List ports = new ArrayList();
        try {
            ports = this.parent.mirthClient.getChannelPortsInUse();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        Object[][] data = new Object[ports.size()][4];
        for (int i = 0; i < ports.size(); ++i) {
            Ports port = (Ports)ports.get(i);
            data[i][0] = port.getPort().toString();
            data[i][1] = port.getName();
            String enabled = "";
            try {
                Channel channel = this.getChannelById(port.getId().toString());
                String string = enabled = channel.getExportData().getMetadata().isEnabled() ? "Enabled" : "Disabled";
                if (enabled == "Enabled") {
                    enabled = this.parent.mirthClient.getChannelStatus(port.getId().toString()).getState().toString();
                }
            }
            catch (ClientException clientException) {
                // empty catch block
            }
            data[i][2] = enabled;
        }
        ((RefreshTableModel)this.portsTable.getModel()).refreshDataVector(data);
        this.portsTable.setSortOrder(0, SortOrder.ASCENDING);
    }

    public Channel getChannelById(String id) throws ClientException {
        for (Channel channel : this.parent.mirthClient.getAllChannels()) {
            if (!channel.getId().equalsIgnoreCase(id)) continue;
            return channel;
        }
        return null;
    }

    private void close() {
        this.dispose();
    }
}

