/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLParserUtil {
    private Logger logger = LogManager.getLogger(this.getClass());
    private String[] keywords = new String[]{"INTO", "DISTINCT", "UNIQUE", "FIRST", "MIDDLE", "SKIP", "LIMIT"};
    private final String SQL_PATTERN = "[s|S][e|E][l|L][e|E][c|C][t|T].*[f|F][r|R][o|O][m|M][\\s]";
    String _sqlStatement = "";

    public SQLParserUtil(String statement) {
        this._sqlStatement = statement.replaceAll("\\[", "").replaceAll("\\]", "").replace('\n', ' ').replace('\r', ' ');
    }

    public SQLParserUtil() {
    }

    public String[] Parse(String statement) {
        this._sqlStatement = statement.replaceAll("\\[", "").replaceAll("\\]", "").replace('\n', ' ').replace('\r', ' ');
        return this.Parse();
    }

    public String[] Parse() {
        try {
            ArrayList<String> varList = new ArrayList<String>();
            Pattern pattern = Pattern.compile("[s|S][e|E][l|L][e|E][c|C][t|T].*[f|F][r|R][o|O][m|M][\\s]", 8);
            Matcher matcher = pattern.matcher(this._sqlStatement);
            while (matcher.find()) {
                String key = matcher.group();
                int fromClause = key.toUpperCase().indexOf(" FROM ");
                if (fromClause <= 0) continue;
                String columnText = key.substring(6, fromClause).replaceAll("`", "");
                columnText = this.removeNestedFunctions(columnText, 0);
                String[] vars = columnText.split(",");
                for (int i = 0; i < vars.length; ++i) {
                    String var;
                    if (vars[i].length() <= 0) continue;
                    for (int j = 0; j < this.keywords.length; ++j) {
                        int index = vars[i].toUpperCase().indexOf(this.keywords[j]);
                        int size = this.keywords[j].length();
                        if (index == -1) continue;
                        if (index > 0) {
                            if (!vars[i].substring(index - 1, index).equals(" ") || vars[i].length() != index + size && !vars[i].substring(index + size, index + size + 1).equals(" ")) continue;
                            vars[i] = vars[i].replaceAll(vars[i].substring(index, index + size), "");
                            continue;
                        }
                        if (vars[i].length() != index + size && !vars[i].substring(index + size, index + size + 1).equals(" ")) continue;
                        vars[i] = vars[i].replaceAll(vars[i].substring(index, index + size), "");
                    }
                    if (vars[i].length() <= 0) continue;
                    if (vars[i].toUpperCase().indexOf(" AS ") != -1) {
                        var = vars[i].substring(vars[i].toUpperCase().indexOf(" AS ") + 4).replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "");
                    } else {
                        if (vars[i].indexOf(40) != -1 || vars[i].indexOf(41) != -1 || vars[i].indexOf(125) != -1 || vars[i].indexOf(123) != -1 || vars[i].indexOf(42) != -1) continue;
                        vars[i] = vars[i].trim();
                        var = vars[i].replaceAll(" ", "").replaceAll("\\(", "").replaceAll("\\)", "");
                        if (var.lastIndexOf(46) != -1) {
                            var = var.substring(var.lastIndexOf(46) + 1);
                        }
                    }
                    if (StringUtils.substring((String)var, (int)0, (int)1).equals("\"") && StringUtils.substring((String)var, (int)-1).equals("\"") || StringUtils.substring((String)var, (int)0, (int)1).equals("'") && StringUtils.substring((String)var, (int)-1).equals("'")) {
                        var = StringUtils.substring((String)var, (int)1, (int)-1);
                    }
                    if (StringUtils.substring((String)var, (int)0, (int)2).equals("\\\"") && StringUtils.substring((String)var, (int)-2).equals("\\\"") || StringUtils.substring((String)var, (int)0, (int)2).equals("\\'") && StringUtils.substring((String)var, (int)-2).equals("\\'")) {
                        var = StringUtils.substring((String)var, (int)2, (int)-2);
                    }
                    var = StringUtils.lowerCase((String)var);
                    varList.add(var);
                }
            }
            return varList.toArray(new String[varList.size()]);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return new String[0];
        }
    }

    private String removeNestedFunctions(String string, int currentIndex) {
        while (currentIndex < ((String)string).length()) {
            if (((String)string).charAt(currentIndex) == '(') {
                string = this.removeNestedFunctions((String)string, currentIndex + 1);
            } else if (((String)string).charAt(currentIndex) == ')') {
                string = ((String)string).substring(0, ((String)string).substring(0, currentIndex).lastIndexOf(40)) + ((String)string).substring(currentIndex + 1, ((String)string).length());
                return string;
            }
            ++currentIndex;
        }
        return string;
    }

    public static void main(String[] args) {
        SQLParserUtil squ = new SQLParserUtil("SELECT `pd_lname`,`pd_fname`,    `pd_tname` FROM `patients`;");
        String[] columns = squ.Parse();
        for (int i = 0; i < columns.length; ++i) {
            System.out.println(columns[i]);
        }
    }
}

