/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.editors.FrameModeSettingsPanel;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameModeProperties;
import com.mirth.connect.plugins.TransmissionModeClientProvider;
import com.mirth.connect.util.TcpUtil;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public abstract class FrameTransmissionModeClientProvider
extends TransmissionModeClientProvider {
    private static final String DEFAULT_SETTINGS_TOOLTIP = "<html>Enter the bytes to send before the beginning and after the end of the actual message.<br/>An even number of characters must be entered, and only the characters 0-9 and A-F are allowed.<br/><br/><b>Sample Frame: SOM <i>&lt;Message Data&gt;</i> EOM</b></html>";
    private String settingsToolTipText;
    protected FrameModeSettingsPanel settingsPanel;

    @Override
    public void initialize(ActionListener actionListener) {
        super.initialize(actionListener);
        this.settingsPanel = new FrameModeSettingsPanel(this);
        this.settingsToolTipText = DEFAULT_SETTINGS_TOOLTIP;
    }

    @Override
    public TransmissionModeProperties getProperties() {
        FrameModeProperties properties = new FrameModeProperties();
        properties.setStartOfMessageBytes(this.settingsPanel.startOfMessageBytesField.getText());
        properties.setEndOfMessageBytes(this.settingsPanel.endOfMessageBytesField.getText());
        return properties;
    }

    @Override
    public TransmissionModeProperties getDefaultProperties() {
        return new FrameModeProperties();
    }

    @Override
    public void setProperties(TransmissionModeProperties properties) {
        FrameModeProperties props = (FrameModeProperties)properties;
        this.settingsPanel.startOfMessageBytesField.getDocument().removeDocumentListener(this);
        this.settingsPanel.endOfMessageBytesField.getDocument().removeDocumentListener(this);
        this.settingsPanel.startOfMessageBytesField.setText(props.getStartOfMessageBytes());
        this.settingsPanel.endOfMessageBytesField.setText(props.getEndOfMessageBytes());
        this.changeSampleValue();
        this.settingsPanel.startOfMessageBytesField.getDocument().addDocumentListener(this);
        this.settingsPanel.endOfMessageBytesField.getDocument().addDocumentListener(this);
    }

    @Override
    public boolean checkProperties(TransmissionModeProperties properties, boolean highlight) {
        boolean valid = true;
        FrameModeProperties props = (FrameModeProperties)properties;
        if (!TcpUtil.isValidHexString((String)props.getStartOfMessageBytes())) {
            valid = false;
            if (highlight) {
                this.settingsPanel.startOfMessageBytesField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!TcpUtil.isValidHexString((String)props.getEndOfMessageBytes())) {
            valid = false;
            if (highlight) {
                this.settingsPanel.endOfMessageBytesField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    @Override
    public void resetInvalidProperties() {
        this.settingsPanel.startOfMessageBytesField.setBackground(null);
        this.settingsPanel.endOfMessageBytesField.setBackground(null);
    }

    @Override
    public JComponent getSettingsComponent() {
        return this.settingsPanel;
    }

    @Override
    public String getSampleLabel() {
        return "Sample Frame:";
    }

    @Override
    public String getSampleValue() {
        String startOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.settingsPanel.startOfMessageBytesField.getText());
        String endOfMessageAbbreviation = TcpUtil.convertHexToAbbreviation((String)this.settingsPanel.endOfMessageBytesField.getText());
        String startReplaced = startOfMessageAbbreviation.replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
        String endReplaced = endOfMessageAbbreviation.replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
        String newSettingsToolTipText = this.settingsToolTipText.replace("SOM", startReplaced).replace("EOM", endReplaced);
        this.settingsPanel.startOfMessageBytes0XLabel.setToolTipText(newSettingsToolTipText);
        this.settingsPanel.startOfMessageBytesField.setToolTipText(newSettingsToolTipText);
        this.settingsPanel.messageDataLabel.setToolTipText(newSettingsToolTipText);
        this.settingsPanel.endOfMessageBytes0XLabel.setToolTipText(newSettingsToolTipText);
        this.settingsPanel.endOfMessageBytesField.setToolTipText(newSettingsToolTipText);
        return ("<html><b>" + startReplaced + "</b> <i>&lt;Message Data&gt;</i> <b>" + endReplaced + "</b></html>").trim();
    }
}

