/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import com.mirth.connect.plugins.DashboardTablePlugin;
import com.mirth.connect.plugins.dashboardstatus.DashboardConnectorStatusServletInterface;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.table.TableCellRenderer;

public class DashboardConnectorStatusColumn
extends DashboardColumnPlugin {
    private static final String _SOURCE_CONNECTOR = "_0";
    private Map<String, Object[]> currentStates;
    private ImageIcon greenBullet;
    private ImageIcon yellowBullet;
    private ImageIcon redBullet;
    private ImageIcon blackBullet;
    private Map<Integer, ImageIcon> iconMap = new HashMap<Integer, ImageIcon>();

    public DashboardConnectorStatusColumn(String name) {
        super(name);
        this.greenBullet = new ImageIcon(Frame.class.getResource("images/bullet_green.png"));
        this.yellowBullet = new ImageIcon(Frame.class.getResource("images/bullet_yellow.png"));
        this.redBullet = new ImageIcon(Frame.class.getResource("images/bullet_red.png"));
        this.blackBullet = new ImageIcon(Frame.class.getResource("images/bullet_black.png"));
        this.iconMap.put(Color.green.getRGB(), this.greenBullet);
        this.iconMap.put(Color.yellow.getRGB(), this.yellowBullet);
        this.iconMap.put(Color.red.getRGB(), this.redBullet);
        this.iconMap.put(Color.black.getRGB(), this.blackBullet);
    }

    @Override
    public TableCellRenderer getCellRenderer() {
        return new ImageCellRenderer();
    }

    @Override
    public String getColumnHeader() {
        return "Connection";
    }

    @Override
    public int getMaxWidth() {
        return 104;
    }

    @Override
    public int getMinWidth() {
        return 104;
    }

    @Override
    public Object getTableData(ChannelGroup group) {
        return new CellData(null, "");
    }

    @Override
    public Object getTableData(String channelId) {
        String connectorName = channelId + _SOURCE_CONNECTOR;
        if (this.currentStates != null && this.currentStates.containsKey(connectorName)) {
            Object[] stateData = this.currentStates.get(connectorName);
            ImageIcon icon = this.iconMap.get(((Color)stateData[0]).getRGB());
            return new CellData(icon, "<html>" + (String)stateData[1] + "</html>");
        }
        return new CellData(this.blackBullet, "Unknown");
    }

    @Override
    public Object getTableData(String channelId, Integer metaDataId) {
        String connectorName = channelId + "_" + (metaDataId == null ? 0 : metaDataId);
        if (this.currentStates != null && this.currentStates.containsKey(connectorName)) {
            Object[] stateData = this.currentStates.get(connectorName);
            ImageIcon icon = this.iconMap.get(((Color)stateData[0]).getRGB());
            return new CellData(icon, "<html>" + (String)stateData[1] + "</html>");
        }
        return new CellData(this.blackBullet, "Unknown");
    }

    @Override
    public boolean isDisplayFirst() {
        return false;
    }

    @Override
    public void tableUpdate(List<DashboardStatus> status) {
        try {
            DashboardTablePlugin plugin;
            String serverId = "";
            Iterator<DashboardTablePlugin> iterator = LoadedExtensions.getInstance().getDashboardTablePlugins().values().iterator();
            while (iterator.hasNext() && (serverId = (plugin = iterator.next()).getServerId()) == null) {
            }
            this.currentStates = ((DashboardConnectorStatusServletInterface)PlatformUI.MIRTH_FRAME.mirthClient.getServlet(DashboardConnectorStatusServletInterface.class)).getConnectorStateMap(serverId);
        }
        catch (ClientException e) {
            this.currentStates = null;
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), (Throwable)e, false);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void reset() {
    }

    @Override
    public String getPluginPointName() {
        return "Dashboard Status Column";
    }
}

