/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.globalmapviewer;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ForbiddenException;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.DashboardTabPlugin;
import com.mirth.connect.plugins.DashboardTablePlugin;
import com.mirth.connect.plugins.globalmapviewer.GlobalMapPanel;
import com.mirth.connect.plugins.globalmapviewer.GlobalMapServletInterface;
import com.mirth.connect.util.StringUtil;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class GlobalMapClient
extends DashboardTabPlugin {
    private GlobalMapPanel globalMapPanel = new GlobalMapPanel();
    private Vector<Object> data;
    private int selectedRow;

    public GlobalMapClient(String name) {
        super(name);
    }

    @Override
    public JComponent getTabComponent() {
        return this.globalMapPanel;
    }

    @Override
    public void prepareData() throws ClientException {
        this.prepareData(null);
    }

    @Override
    public void prepareData(List<DashboardStatus> statuses) throws ClientException {
        final HashSet channelIds = new HashSet();
        final HashMap channelNameMap = new HashMap();
        final HashSet selectedServer = new HashSet();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DashboardTablePlugin plugin;
                    Set<DashboardStatus> channelStatuses = PlatformUI.MIRTH_FRAME.dashboardPanel.getSelectedChannelStatuses();
                    if (channelStatuses != null) {
                        for (DashboardStatus channelStatus : channelStatuses) {
                            channelIds.add(channelStatus.getChannelId());
                            channelNameMap.put(channelStatus.getChannelId(), channelStatus.getName());
                        }
                    }
                    String serverId = null;
                    Iterator<DashboardTablePlugin> iterator = LoadedExtensions.getInstance().getDashboardTablePlugins().values().iterator();
                    while (iterator.hasNext() && (serverId = (plugin = iterator.next()).getServerId()) == null) {
                    }
                    selectedServer.add(serverId);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.data = new Vector();
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        Map globalMaps = null;
        this.selectedRow = 0;
        String currentlySelectedServer = this.globalMapPanel.getSelectedServer();
        String currentlySelectedMap = this.globalMapPanel.getSelectedMap();
        String currentlySelectedVar = this.globalMapPanel.getSelectedVar();
        try {
            globalMaps = ((GlobalMapServletInterface)PlatformUI.MIRTH_FRAME.mirthClient.getServlet(GlobalMapServletInterface.class)).getAllMapsPost(channelIds, true);
        }
        catch (ClientException e) {
            if (e instanceof ForbiddenException) {
                this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, false);
            }
            throw e;
        }
        if (globalMaps != null) {
            TreeMap<String, Object> sortedGlobalMaps = new TreeMap<String, Object>();
            TreeMap<String, Map> workingGlobalMaps = new TreeMap<String, Map>();
            String selectedServerId = null;
            if (!selectedServer.isEmpty()) {
                selectedServerId = (String)selectedServer.iterator().next();
            }
            for (Map.Entry serverEntry : globalMaps.entrySet()) {
                if (selectedServerId != null && !selectedServerId.equals(serverEntry.getKey())) continue;
                TreeMap sortedServerGlobalMaps = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry entry : ((Map)serverEntry.getValue()).entrySet()) {
                    if (entry.getKey() == null) {
                        workingGlobalMaps.put((String)serverEntry.getKey(), (Map)entry.getValue());
                        continue;
                    }
                    sortedServerGlobalMaps.put((String)channelNameMap.get(entry.getKey()), (Map)entry.getValue());
                }
                sortedGlobalMaps.put((String)serverEntry.getKey(), sortedServerGlobalMaps);
            }
            for (Map.Entry serverEntry : sortedGlobalMaps.entrySet()) {
                for (Map.Entry entry : ((Map)serverEntry.getValue()).entrySet()) {
                    String string = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                    for (Map.Entry<String, String> entry2 : map.entrySet()) {
                        Object mapValue = this.deserializeGlobalMapVariableValue((Serializer)serializer, entry2);
                        sortedMap.put(entry2.getKey(), mapValue);
                    }
                    for (Map.Entry entry3 : sortedMap.entrySet()) {
                        Vector<Object> row = new Vector<Object>();
                        String entryKey = StringUtil.valueOf(entry3.getKey());
                        row.add(serverEntry.getKey());
                        row.add(string);
                        row.add(StringUtil.valueOf((Object)entryKey));
                        row.add(StringUtil.valueOf(entry3.getValue()));
                        this.data.add(row);
                        if (!StringUtils.equals((CharSequence)((CharSequence)serverEntry.getKey()), (CharSequence)currentlySelectedServer) || !StringUtils.equals((CharSequence)entryKey, (CharSequence)currentlySelectedVar) || !StringUtils.equals((CharSequence)string, (CharSequence)currentlySelectedMap)) continue;
                        this.selectedRow = this.data.size();
                    }
                }
            }
            if (MapUtils.isNotEmpty(workingGlobalMaps)) {
                for (Map.Entry serverEntry : workingGlobalMaps.entrySet()) {
                    TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                    for (Map.Entry<String, String> entry : ((Map)serverEntry.getValue()).entrySet()) {
                        Object mapValue = this.deserializeGlobalMapVariableValue((Serializer)serializer, entry);
                        sortedMap.put(entry.getKey(), mapValue);
                    }
                    for (Map.Entry entry : sortedMap.entrySet()) {
                        Vector<Object> row = new Vector<Object>();
                        String entryKey = StringUtil.valueOf(entry.getKey());
                        row.add(serverEntry.getKey());
                        row.add("<Global Map>");
                        row.add(entryKey);
                        row.add(StringUtil.valueOf(entry.getValue()));
                        this.data.add(row);
                        if (!StringUtils.equals((CharSequence)((CharSequence)serverEntry.getKey()), (CharSequence)currentlySelectedServer) || !StringUtils.equals((CharSequence)entryKey, (CharSequence)currentlySelectedVar) || !StringUtils.equals((CharSequence)"<Global Map>", (CharSequence)currentlySelectedMap)) continue;
                        this.selectedRow = this.data.size();
                    }
                }
            }
        }
    }

    private Object deserializeGlobalMapVariableValue(Serializer serializer, Map.Entry<String, String> mapEntry) {
        Object mapValue = "";
        try {
            mapValue = serializer.deserialize(mapEntry.getValue(), Object.class);
        }
        catch (Exception e) {
            mapValue = mapEntry.getValue();
        }
        return mapValue;
    }

    @Override
    public void update() {
        this.globalMapPanel.updateTable(this.data, this.selectedRow);
    }

    @Override
    public void update(List<DashboardStatus> statuses) {
        this.update();
    }

    @Override
    public String getPluginPointName() {
        return "Global Maps";
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void reset() {
    }
}

