/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.rulebuilder;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Rule;
import com.mirth.connect.plugins.rulebuilder.RuleBuilderRule;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class RuleBuilderPanel
extends EditorPanel<Rule> {
    private static final int VALUE_COLUMN = 0;
    private static final String VALUE_COLUMN_NAME = "Value";
    private ActionListener nameActionListener;
    private JLabel behaviorLabel;
    private JLabel acceptLabel;
    private JLabel fieldLabel;
    private JTextField fieldField;
    private JLabel conditionLabel;
    private Map<RuleBuilderRule.Condition, JRadioButton> conditionRadioMap;
    private JLabel valuesLabel;
    private MirthTable valuesTable;
    private JScrollPane valuesScrollPane;
    private JButton newButton;
    private JButton deleteButton;

    public RuleBuilderPanel() {
        this.initComponents();
        this.initLayout();
    }

    @Override
    public Rule getDefaults() {
        return new RuleBuilderRule();
    }

    @Override
    public Rule getProperties() {
        RuleBuilderRule props = new RuleBuilderRule();
        props.setField(this.fieldField.getText());
        props.setCondition(this.getSelectedCondition());
        props.setValues(this.getValues());
        return props;
    }

    @Override
    public void setProperties(Rule properties) {
        RuleBuilderRule props = (RuleBuilderRule)properties;
        this.fieldField.setText(props.getField());
        this.conditionRadioMap.get(props.getCondition()).setSelected(true);
        this.conditionRadioActionPerformed(props.getCondition());
        this.setValues(props.getValues());
        properties.setName(this.updateName());
    }

    @Override
    public String checkProperties(Rule properties, boolean highlight) {
        RuleBuilderRule props = (RuleBuilderRule)properties;
        Object errors = "";
        if (StringUtils.isBlank((CharSequence)props.getField())) {
            errors = (String)errors + "The field cannot be blank.\n";
            if (highlight) {
                this.fieldField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    @Override
    public void resetInvalidProperties() {
        this.fieldField.setBackground(null);
    }

    @Override
    public void setNameActionListener(ActionListener actionListener) {
        this.nameActionListener = actionListener;
    }

    @Override
    public void stopEditing() {
        if (this.valuesTable.isEditing()) {
            this.valuesTable.getCellEditor(this.valuesTable.getEditingRow(), this.valuesTable.getEditingColumn()).stopCellEditing();
        }
    }

    public void setValues(List<String> values) {
        Object[][] tableData = new Object[values.size()][1];
        for (int i = 0; i < values.size(); ++i) {
            tableData[i][0] = values.get(i);
        }
        ((RefreshTableModel)this.valuesTable.getModel()).refreshDataVector(tableData);
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.valuesTable.getRowCount(); ++i) {
            if (((String)this.valuesTable.getValueAt(i, 0)).length() <= 0) continue;
            values.add((String)this.valuesTable.getValueAt(i, 0));
        }
        return values;
    }

    public void deselectRows() {
        this.valuesTable.clearSelection();
        this.deleteButton.setEnabled(false);
    }

    public int getSelectedRow() {
        if (this.valuesTable.isEditing()) {
            return this.valuesTable.getEditingRow();
        }
        return this.valuesTable.getSelectedRow();
    }

    private void setValuesEnabled(boolean enabled) {
        if (this.valuesTable.isEditing()) {
            this.valuesTable.getCellEditor().stopCellEditing();
        }
        this.valuesScrollPane.setEnabled(enabled);
        this.valuesTable.setEnabled(enabled);
        this.valuesLabel.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.deselectRows();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.behaviorLabel = new JLabel("Behavior:");
        this.acceptLabel = new JLabel("Accept");
        this.fieldLabel = new JLabel("Field:");
        this.fieldField = new JTextField();
        this.fieldField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            private void documentChanged(DocumentEvent evt) {
                try {
                    RuleBuilderPanel.this.updateName(evt.getDocument().getText(0, evt.getDocument().getLength()));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.conditionLabel = new JLabel("Condition:");
        this.conditionRadioMap = new LinkedHashMap<RuleBuilderRule.Condition, JRadioButton>();
        ButtonGroup conditionButtonGroup = new ButtonGroup();
        for (final RuleBuilderRule.Condition condition : RuleBuilderRule.Condition.values()) {
            JRadioButton radio = new JRadioButton(condition.toString());
            radio.setBackground(this.getBackground());
            radio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RuleBuilderPanel.this.conditionRadioActionPerformed(condition);
                }
            });
            conditionButtonGroup.add(radio);
            this.conditionRadioMap.put(condition, radio);
        }
        this.valuesLabel = new JLabel("Values:");
        this.valuesTable = new MirthTable();
        this.valuesTable.setModel(new RefreshTableModel(new String[]{VALUE_COLUMN_NAME}, 0){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.valuesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RuleBuilderPanel.this.deleteButton.setEnabled(RuleBuilderPanel.this.getSelectedRow() >= 0);
            }
        });
        class RegExTableCellEditor
        extends TextFieldCellEditor {
            RegExTableCellEditor() {
            }

            @Override
            public boolean stopCellEditing() {
                RuleBuilderPanel.this.deleteButton.setEnabled(true);
                return super.stopCellEditing();
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    RuleBuilderPanel.this.deleteButton.setEnabled(false);
                }
                return editable;
            }

            @Override
            protected boolean valueChanged(String value) {
                return true;
            }
        }
        this.valuesTable.getColumnModel().getColumn(this.valuesTable.getColumnModel().getColumnIndex(VALUE_COLUMN_NAME)).setCellEditor(new RegExTableCellEditor());
        this.valuesTable.setCustomEditorControls(true);
        this.valuesTable.setSelectionMode(0);
        this.valuesTable.setRowSelectionAllowed(true);
        this.valuesTable.setRowHeight(20);
        this.valuesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.valuesTable.setDragEnabled(false);
        this.valuesTable.setOpaque(true);
        this.valuesTable.setSortable(false);
        this.valuesTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.valuesTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.valuesTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RuleBuilderPanel.this.updateName();
                    }
                });
            }
        });
        this.valuesScrollPane = new JScrollPane((Component)((Object)this.valuesTable));
        this.valuesScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RuleBuilderPanel.this.deselectRows();
            }
        });
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleBuilderPanel.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleBuilderPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setEnabled(false);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, gap 6"));
        this.add((Component)this.behaviorLabel, "right, gapafter 6");
        this.add(this.acceptLabel);
        this.add((Component)this.fieldLabel, "newline, right, gapafter 6");
        this.add((Component)this.fieldField, "sx, growx");
        this.add((Component)this.conditionLabel, "newline, right, gapafter 6");
        for (JRadioButton radio : this.conditionRadioMap.values()) {
            this.add((Component)radio, "split " + this.conditionRadioMap.size());
        }
        this.add((Component)this.valuesLabel, "newline, top, right, gapafter 6");
        this.add((Component)this.valuesScrollPane, "grow, push, sy");
        this.add((Component)this.newButton, "top, flowy, split 2, sgx");
        this.add((Component)this.deleteButton, "top, sgx");
    }

    private void conditionRadioActionPerformed(RuleBuilderRule.Condition condition) {
        this.setValuesEnabled(condition.isValuesEnabled());
        this.updateName(condition);
    }

    private RuleBuilderRule.Condition getSelectedCondition() {
        for (Map.Entry<RuleBuilderRule.Condition, JRadioButton> entry : this.conditionRadioMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return RuleBuilderRule.Condition.values()[0];
    }

    private String updateName() {
        return this.updateName(this.fieldField.getText(), this.getSelectedCondition());
    }

    private String updateName(String fieldText) {
        return this.updateName(fieldText, this.getSelectedCondition());
    }

    private String updateName(RuleBuilderRule.Condition condition) {
        return this.updateName(this.fieldField.getText(), condition);
    }

    private String updateName(String fieldText, RuleBuilderRule.Condition condition) {
        StringBuilder builder = new StringBuilder("Accept message if \"").append(fieldText).append("\" ");
        if (condition.isValuesEnabled()) {
            boolean first = true;
            for (String value : this.getValues()) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                if (first) {
                    builder.append(condition.getPresentTense()).append(' ');
                } else {
                    builder.append(" or ");
                }
                builder.append(value);
                first = false;
            }
            if (first) {
                if (condition == RuleBuilderRule.Condition.EQUALS) {
                    builder.append("is blank");
                } else if (condition == RuleBuilderRule.Condition.NOT_EQUAL) {
                    builder.append("is not blank");
                } else {
                    builder.append(condition.getPresentTense()).append(" \"\"");
                }
            }
        } else {
            builder.append(condition.getPresentTense());
        }
        String name = builder.toString();
        if (this.nameActionListener != null) {
            this.nameActionListener.actionPerformed(new ActionEvent(this, 1001, name));
        }
        return name;
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0 && !this.valuesTable.isEditing()) {
            ((RefreshTableModel)this.valuesTable.getModel()).removeRow(this.valuesTable.convertRowIndexToModel(selectedRow));
            if (this.valuesTable.getRowCount() > 0) {
                if (selectedRow < this.valuesTable.getRowCount()) {
                    this.valuesTable.setRowSelectionInterval(selectedRow, selectedRow);
                } else {
                    this.valuesTable.setRowSelectionInterval(this.valuesTable.getRowCount() - 1, this.valuesTable.getRowCount() - 1);
                }
            }
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        ((RefreshTableModel)this.valuesTable.getModel()).addRow(new Object[]{""});
        this.valuesTable.setRowSelectionInterval(this.valuesTable.getRowCount() - 1, this.valuesTable.getRowCount() - 1);
    }
}

