/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.xsltstep;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Step;
import com.mirth.connect.plugins.xsltstep.XsltStep;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class XsltStepPanel
extends EditorPanel<Step> {
    private JLabel sourceXMLLabel;
    private JTextField sourceXMLField;
    private JLabel resultLabel;
    private JTextField resultField;
    private JLabel transformerFactoryLabel;
    private JRadioButton transformerFactoryDefaultRadio;
    private JRadioButton transformerFactoryCustomRadio;
    private JTextField transformerFactoryCustomField;
    private JLabel xsltTemplateLabel;
    private MirthRTextScrollPane xsltTemplateTextArea;

    public XsltStepPanel() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
    }

    @Override
    public Step getDefaults() {
        return new XsltStep();
    }

    @Override
    public Step getProperties() {
        XsltStep props = new XsltStep();
        props.setSourceXml(this.sourceXMLField.getText().trim());
        props.setResultVariable(this.resultField.getText().trim());
        props.setUseCustomFactory(this.transformerFactoryCustomRadio.isSelected());
        props.setCustomFactory(this.transformerFactoryCustomField.getText().trim());
        props.setTemplate(this.xsltTemplateTextArea.getText());
        return props;
    }

    @Override
    public void setProperties(Step properties) {
        XsltStep props = (XsltStep)properties;
        this.sourceXMLField.setText(props.getSourceXml());
        this.resultField.setText(props.getResultVariable());
        if (props.isUseCustomFactory()) {
            this.transformerFactoryCustomRadio.setSelected(true);
            this.customRadioActionPerformed();
        } else {
            this.transformerFactoryDefaultRadio.setSelected(true);
            this.defaultRadioActionPerformed();
        }
        this.transformerFactoryCustomField.setText(props.getCustomFactory());
        this.xsltTemplateTextArea.setText(props.getTemplate());
    }

    @Override
    public String checkProperties(Step properties, boolean highlight) {
        XsltStep props = (XsltStep)properties;
        Object errors = "";
        if (StringUtils.isBlank((CharSequence)props.getSourceXml())) {
            errors = (String)errors + "The source XML string cannot be blank.\n";
            if (highlight) {
                this.sourceXMLField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getResultVariable())) {
            errors = (String)errors + "The result variable cannot be blank.\n";
            if (highlight) {
                this.resultField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    @Override
    public void resetInvalidProperties() {
        this.sourceXMLField.setBackground(null);
        this.resultField.setBackground(null);
    }

    @Override
    public void setNameActionListener(ActionListener actionListener) {
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.sourceXMLLabel = new JLabel("Source XML String:");
        this.sourceXMLField = new JTextField();
        this.resultLabel = new JLabel("Result:");
        this.resultField = new JTextField();
        this.transformerFactoryLabel = new JLabel("Transformer Factory:");
        ButtonGroup factoryButtonGroup = new ButtonGroup();
        this.transformerFactoryDefaultRadio = new MirthRadioButton("Default");
        this.transformerFactoryDefaultRadio.setBackground(this.getBackground());
        this.transformerFactoryDefaultRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XsltStepPanel.this.defaultRadioActionPerformed();
            }
        });
        factoryButtonGroup.add(this.transformerFactoryDefaultRadio);
        this.transformerFactoryCustomRadio = new MirthRadioButton("Custom");
        this.transformerFactoryCustomRadio.setBackground(this.getBackground());
        this.transformerFactoryCustomRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XsltStepPanel.this.customRadioActionPerformed();
            }
        });
        factoryButtonGroup.add(this.transformerFactoryCustomRadio);
        this.transformerFactoryCustomField = new MirthTextField();
        this.xsltTemplateLabel = new JLabel("XSLT Template:");
        this.xsltTemplateTextArea = new MirthRTextScrollPane(null, true, "text/xml", false);
        this.xsltTemplateTextArea.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initToolTips() {
        String toolTipText = "<html>Select default to use the platform default Tra4nsformer Factory.<br/>Select custom to provide a custom Transformer Factory class.</html>";
        this.transformerFactoryDefaultRadio.setToolTipText(toolTipText);
        this.transformerFactoryCustomRadio.setToolTipText(toolTipText);
        this.transformerFactoryCustomField.setToolTipText("The fully-qualified class name of the custom Transformer Factory.");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, gap 12 6"));
        this.add((Component)this.sourceXMLLabel, "right");
        this.add((Component)this.sourceXMLField, "growx");
        this.add((Component)this.resultLabel, "newline, right");
        this.add((Component)this.resultField, "growx");
        this.add((Component)this.transformerFactoryLabel, "newline, right");
        this.add((Component)this.transformerFactoryDefaultRadio, "split 3");
        this.add(this.transformerFactoryCustomRadio);
        this.add((Component)this.transformerFactoryCustomField, "growx");
        this.add((Component)this.xsltTemplateLabel, "newline, right, top");
        this.add((Component)((Object)this.xsltTemplateTextArea), "grow, push");
    }

    private void defaultRadioActionPerformed() {
        this.transformerFactoryCustomField.setEnabled(false);
    }

    private void customRadioActionPerformed() {
        this.transformerFactoryCustomField.setEnabled(true);
    }
}

