/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;

public class EOLPreservingRSyntaxDocument
extends RSyntaxDocument {
    private static final char[] CR = new char[]{'\r'};
    private static final char[] LF = new char[]{'\n'};
    private static final char[] CRLF = new char[]{'\r', '\n'};
    private boolean replaceControlCharacters;
    private TreeMap<Integer, char[]> eolMap = new TreeMap();
    private UndoableEdit lastEdit = null;

    public EOLPreservingRSyntaxDocument(String syntaxStyle) {
        this(syntaxStyle, true);
    }

    public EOLPreservingRSyntaxDocument(String syntaxStyle, boolean replaceControlCharacters) {
        super(syntaxStyle);
        this.replaceControlCharacters = replaceControlCharacters;
    }

    public EOLPreservingRSyntaxDocument(TokenMakerFactory tmf, String syntaxStyle, boolean replaceControlCharacters) {
        super(tmf, syntaxStyle);
        this.replaceControlCharacters = replaceControlCharacters;
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        InsertStringResult result = this.insertStringImpl(offset, str, a);
        this.lastEdit = result.edit;
        super.insertString(offset, result.str, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InsertStringResult insertStringImpl(int offset, String str, AttributeSet a) throws BadLocationException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new InsertStringResult(str, null);
        }
        BufferedReader reader = null;
        CompoundEdit edit = new CompoundEdit();
        try {
            Integer key;
            int nch;
            reader = new PeekReader(new StringReader(str));
            StringBuilder builder = new StringBuilder();
            TreeMap<Integer, char[]> tempMap = new TreeMap<Integer, char[]>();
            char[] buff = new char[1024];
            int cOffset = offset;
            boolean wasCR = false;
            while ((nch = reader.read(buff, 0, buff.length)) != -1) {
                for (int i = 0; i < nch; ++i) {
                    boolean updated;
                    char c = buff[i];
                    if (c == '\r') {
                        updated = false;
                        if (i == nch - 1 && !((PeekReader)reader).peek() && Arrays.equals(this.eolMap.get(offset), LF)) {
                            edit.addEdit(new ChangeEOLEdit(offset, CRLF));
                            this.eolMap.put(offset, CRLF);
                            updated = true;
                        }
                        if (!updated && (wasCR || i == nch - 1 && !((PeekReader)reader).peek())) {
                            tempMap.put(cOffset++, CR);
                            builder.append(LF);
                        }
                        wasCR = true;
                        continue;
                    }
                    if (c == '\n') {
                        updated = false;
                        if (cOffset == offset && Arrays.equals(this.eolMap.get(offset - 1), CR)) {
                            edit.addEdit(new ChangeEOLEdit(offset - 1, CRLF));
                            this.eolMap.put(offset - 1, CRLF);
                            updated = true;
                        }
                        if (!updated) {
                            if (wasCR) {
                                tempMap.put(cOffset++, CRLF);
                                builder.append(LF);
                            } else {
                                tempMap.put(cOffset++, LF);
                                builder.append(LF);
                            }
                        }
                        wasCR = false;
                        continue;
                    }
                    if (this.replaceControlCharacters && c != '\t' && (c < ' ' || c == '\u007f')) {
                        if (wasCR) {
                            tempMap.put(cOffset++, CR);
                            builder.append(LF);
                        }
                        ++cOffset;
                        builder.append((char)(c == '\u007f' ? 9249 : 9216 + c));
                        wasCR = false;
                        continue;
                    }
                    if (wasCR) {
                        tempMap.put(cOffset++, CR);
                        builder.append(LF);
                    }
                    ++cOffset;
                    builder.append(c);
                    wasCR = false;
                }
            }
            str = builder.toString();
            Integer n = key = this.eolMap.isEmpty() ? null : this.eolMap.lastKey();
            while (key != null && key >= offset) {
                edit.addEdit(new ChangeEOLEdit(key, null));
                char[] eol = this.eolMap.remove(key);
                int newKey = key + str.length();
                edit.addEdit(new ChangeEOLEdit(newKey, eol));
                this.eolMap.put(newKey, eol);
                key = this.eolMap.lowerKey(key);
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                edit.addEdit(new ChangeEOLEdit((Integer)entry.getKey(), (char[])entry.getValue()));
            }
            this.eolMap.putAll(tempMap);
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        edit.end();
        return new InsertStringResult(str, edit);
    }

    public void remove(int offs, int len) throws BadLocationException {
        RemoveResult result = this.removeImpl(offs, len);
        this.lastEdit = result.edit;
        super.remove(offs, result.len);
    }

    private RemoveResult removeImpl(int offs, int len) throws BadLocationException {
        CompoundEdit edit = new CompoundEdit();
        if (Arrays.equals(this.eolMap.get(offs - 1), CR) && Arrays.equals(this.eolMap.get(offs + len), LF)) {
            edit.addEdit(new ChangeEOLEdit(offs - 1, CRLF));
            this.eolMap.put(offs - 1, CRLF);
            ++len;
        }
        for (Integer offset : this.eolMap.keySet().toArray(new Integer[this.eolMap.size()])) {
            if (offset < offs) continue;
            edit.addEdit(new ChangeEOLEdit(offset, null));
            char[] eol = this.eolMap.remove(offset);
            if (offset < offs + len) continue;
            edit.addEdit(new ChangeEOLEdit(offset - len, eol));
            this.eolMap.put(offset - len, eol);
        }
        edit.end();
        return new RemoveResult(len, edit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, String text, AttributeSet a) throws BadLocationException {
        this.lastEdit = null;
        if (length == 0 && StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        RemoveResult removeResult = this.removeImpl(offset, length);
        InsertStringResult insertResult = this.insertStringImpl(offset, text, a);
        if (removeResult.edit != null) {
            if (insertResult.edit != null) {
                CompoundEdit edit = new CompoundEdit();
                edit.addEdit(removeResult.edit);
                edit.addEdit(insertResult.edit);
                edit.end();
                this.lastEdit = edit;
            } else {
                this.lastEdit = removeResult.edit;
            }
        } else if (insertResult.edit != null) {
            this.lastEdit = insertResult.edit;
        }
        this.writeLock();
        try {
            super.remove(offset, removeResult.len);
            super.insertString(offset, insertResult.str, a);
        }
        finally {
            this.writeUnlock();
        }
    }

    public char[] getEOL(int line) {
        int i = 0;
        for (char[] eol : this.eolMap.values()) {
            if (i == line) {
                return eol;
            }
            ++i;
        }
        return null;
    }

    public String getText(int offset, int length) throws BadLocationException {
        if (this.replaceControlCharacters) {
            try {
                int nch;
                StringBuilder builder = new StringBuilder();
                StringReader reader = new StringReader(super.getText(offset, length));
                char[] buff = new char[1024];
                while ((nch = ((Reader)reader).read(buff, 0, buff.length)) != -1) {
                    for (int i = 0; i < nch; ++i) {
                        if (buff[i] >= '\u2400' && buff[i] <= '\u241f') {
                            buff[i] = (char)(buff[i] - 9216);
                            continue;
                        }
                        if (buff[i] != '\u2421') continue;
                        buff[i] = 127;
                    }
                    builder.append(buff, 0, nch);
                }
                return builder.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getText(offset, length);
    }

    public String getEOLFixedText(int offset, int length) throws BadLocationException {
        String text = this.getText(offset, length);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char[] eol = this.eolMap.get(offset + i);
            if (ArrayUtils.isNotEmpty((char[])eol)) {
                builder.append(eol);
                continue;
            }
            builder.append(text.charAt(i));
        }
        return builder.toString();
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent evt) {
        if (this.lastEdit != null) {
            CompoundEdit edit = new CompoundEdit();
            edit.addEdit(evt.getEdit());
            edit.addEdit(this.lastEdit);
            edit.end();
            super.fireUndoableEditUpdate(new UndoableEditEvent(evt.getSource(), edit));
            this.lastEdit = null;
        } else {
            super.fireUndoableEditUpdate(evt);
        }
    }

    private class InsertStringResult {
        public String str;
        public UndoableEdit edit;

        public InsertStringResult(String str, UndoableEdit edit) {
            this.str = str;
            this.edit = edit;
        }
    }

    private class PeekReader
    extends BufferedReader {
        public PeekReader(Reader in) {
            super(in);
        }

        public boolean peek() throws IOException {
            this.mark(1);
            try {
                boolean bl = this.read() != -1;
                return bl;
            }
            finally {
                this.reset();
            }
        }
    }

    private class ChangeEOLEdit
    implements UndoableEdit {
        private int offset;
        private char[] oldEOL;
        private char[] newEOL;

        public ChangeEOLEdit(int offset, char[] newEOL) {
            this.offset = offset;
            this.oldEOL = EOLPreservingRSyntaxDocument.this.eolMap.get(offset);
            this.newEOL = newEOL;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.oldEOL != null) {
                EOLPreservingRSyntaxDocument.this.eolMap.put(this.offset, this.oldEOL);
            } else {
                EOLPreservingRSyntaxDocument.this.eolMap.remove(this.offset);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.newEOL != null) {
                EOLPreservingRSyntaxDocument.this.eolMap.put(this.offset, this.newEOL);
            } else {
                EOLPreservingRSyntaxDocument.this.eolMap.remove(this.offset);
            }
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public void die() {
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public boolean replaceEdit(UndoableEdit anEdit) {
            return false;
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return null;
        }

        @Override
        public String getUndoPresentationName() {
            return null;
        }

        @Override
        public String getRedoPresentationName() {
            return null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
            if (this.newEOL != null) {
                if (this.oldEOL != null) {
                    builder.append("Replace ").append(this.getEOLDisplay(this.oldEOL)).append(" with ").append(this.getEOLDisplay(this.newEOL)).append(" at offset ").append(this.offset);
                } else {
                    builder.append("Add ").append(this.getEOLDisplay(this.newEOL)).append(" at offset ").append(this.offset);
                }
            } else if (this.oldEOL != null) {
                builder.append("Remove ").append(this.getEOLDisplay(this.oldEOL)).append(" at offset ").append(this.offset);
            } else {
                builder.append("Do nothing at offset ").append(this.offset);
            }
            return builder.append(']').toString();
        }

        private String getEOLDisplay(char[] eol) {
            if (Arrays.equals(eol, CR)) {
                return "CR";
            }
            if (Arrays.equals(eol, LF)) {
                return "LF";
            }
            if (Arrays.equals(eol, CRLF)) {
                return "CRLF";
            }
            return Arrays.toString(eol);
        }
    }

    private class RemoveResult {
        public int len;
        public UndoableEdit edit;

        public RemoveResult(int len, UndoableEdit edit) {
            this.len = len;
            this.edit = edit;
        }
    }
}

