/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.HashSet;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.tokenmarker.Token;

public class SyntaxUtilities {
    public static final HashSet<Character> invalidCharSet = new HashSet();

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, String match) {
        int length = offset + match.length();
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match.charAt(j);
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] styles = new SyntaxStyle[12];
        styles[1] = new SyntaxStyle(new Color(4361181), true, false);
        styles[2] = new SyntaxStyle(new Color(4361181), true, false);
        styles[6] = new SyntaxStyle(new Color(16300800), false, true);
        styles[7] = new SyntaxStyle(new Color(11877180), false, false);
        styles[8] = new SyntaxStyle(new Color(11877180), false, true);
        styles[3] = new SyntaxStyle(new Color(180229), false, false);
        styles[4] = new SyntaxStyle(new Color(0xEDDD3D), false, false);
        styles[5] = new SyntaxStyle(new Color(9086657), true, true);
        styles[9] = new SyntaxStyle(new Color(8757691), false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        styles[11] = new SyntaxStyle(new Color(0xEDDD3D), false, false);
        return styles;
    }

    public static SyntaxStyle[] getSyntaxStyles(String name) {
        SyntaxStyle[] styles = new SyntaxStyle[12];
        if (name.equals("RUBY BLUE")) {
            styles[1] = new SyntaxStyle(new Color(4361181), true, false);
            styles[2] = new SyntaxStyle(new Color(4361181), true, false);
            styles[6] = new SyntaxStyle(new Color(16300800), false, true);
            styles[7] = new SyntaxStyle(new Color(0xEDDD3D), false, false);
            styles[8] = new SyntaxStyle(new Color(8757691), false, true);
            styles[3] = new SyntaxStyle(new Color(180229), false, false);
            styles[4] = new SyntaxStyle(new Color(0xEDDD3D), false, false);
            styles[5] = new SyntaxStyle(new Color(9086657), true, true);
            styles[9] = new SyntaxStyle(Color.lightGray, false, true);
            styles[10] = new SyntaxStyle(Color.red, false, true);
            styles[11] = new SyntaxStyle(new Color(0xEDDD3D), false, false);
            return styles;
        }
        Color maroon = new Color(11546720);
        Color darkBlue = new Color(128);
        Color darkGreen = Color.GREEN.darker().darker();
        Color darkPurple = new Color(10494192).darker();
        Color darkRed = Color.red.darker();
        styles[1] = new SyntaxStyle(darkGreen, false, false);
        styles[2] = new SyntaxStyle(darkGreen, false, false);
        styles[6] = new SyntaxStyle(Color.blue, false, false);
        styles[7] = new SyntaxStyle(Color.orange, false, false);
        styles[8] = new SyntaxStyle(darkPurple, false, true);
        styles[3] = new SyntaxStyle(maroon, false, false);
        styles[4] = new SyntaxStyle(darkRed, false, false);
        styles[5] = new SyntaxStyle(darkGreen, false, false);
        styles[9] = new SyntaxStyle(Color.gray.darker(), false, true);
        styles[10] = new SyntaxStyle(Color.red, false, false);
        styles[11] = new SyntaxStyle(maroon, false, false);
        return styles;
    }

    public static int paintSyntaxLine(Segment line, Token tokens, SyntaxStyle[] styles, TabExpander expander, Graphics gfx, int x, int y) {
        byte id;
        Font defaultFont = gfx.getFont();
        Color defaultColor = gfx.getColor();
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                if (!defaultColor.equals(gfx.getColor())) {
                    gfx.setColor(defaultColor);
                }
                if (!defaultFont.equals(gfx.getFont())) {
                    gfx.setFont(defaultFont);
                }
            } else {
                styles[id].setGraphicsFlags(gfx, defaultFont);
            }
            line.count = length;
            int tokenLength = line.getEndIndex();
            for (int i = line.getBeginIndex(); i < tokenLength; ++i) {
                if (invalidCharSet.contains(Character.valueOf(line.array[i]))) {
                    Font oldFont = gfx.getFont();
                    gfx.setFont(new Font(oldFont.getFamily(), 1, oldFont.getSize()));
                    Color oldColor = gfx.getColor();
                    gfx.setColor(Color.RED);
                    x = Utilities.drawTabbedText(new Segment(new char[]{'?'}, 0, 1), x, y, gfx, expander, 0);
                    gfx.setColor(oldColor);
                    gfx.setFont(oldFont);
                } else {
                    x = Utilities.drawTabbedText(new Segment(line.array, line.getBeginIndex(), 1), x, y, gfx, expander, 0);
                }
                ++line.offset;
                ++offset;
                line.count = --length;
            }
            tokens = tokens.next;
        }
        return x;
    }

    private SyntaxUtilities() {
    }

    static {
        invalidCharSet.add(Character.valueOf('\u0000'));
        invalidCharSet.add(Character.valueOf('\u0001'));
        invalidCharSet.add(Character.valueOf('\u0002'));
        invalidCharSet.add(Character.valueOf('\u0003'));
        invalidCharSet.add(Character.valueOf('\u0004'));
        invalidCharSet.add(Character.valueOf('\u0005'));
        invalidCharSet.add(Character.valueOf('\u0006'));
        invalidCharSet.add(Character.valueOf('\u0007'));
        invalidCharSet.add(Character.valueOf('\b'));
        invalidCharSet.add(Character.valueOf('\u000b'));
        invalidCharSet.add(Character.valueOf('\f'));
        invalidCharSet.add(Character.valueOf('\u000e'));
        invalidCharSet.add(Character.valueOf('\u000f'));
        invalidCharSet.add(Character.valueOf('\u0010'));
        invalidCharSet.add(Character.valueOf('\u0011'));
        invalidCharSet.add(Character.valueOf('\u0012'));
        invalidCharSet.add(Character.valueOf('\u0013'));
        invalidCharSet.add(Character.valueOf('\u0014'));
        invalidCharSet.add(Character.valueOf('\u0015'));
        invalidCharSet.add(Character.valueOf('\u0016'));
        invalidCharSet.add(Character.valueOf('\u0017'));
        invalidCharSet.add(Character.valueOf('\u0018'));
        invalidCharSet.add(Character.valueOf('\u0019'));
        invalidCharSet.add(Character.valueOf('\u001a'));
        invalidCharSet.add(Character.valueOf('\u001b'));
        invalidCharSet.add(Character.valueOf('\u001c'));
        invalidCharSet.add(Character.valueOf('\u001d'));
        invalidCharSet.add(Character.valueOf('\u001e'));
        invalidCharSet.add(Character.valueOf('\u001f'));
        invalidCharSet.add(Character.valueOf('\u007f'));
    }
}

