/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit;

import com.mirth.connect.client.ui.UIConstants;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JPopupMenu;
import org.syntax.jedit.DefaultInputHandler;
import org.syntax.jedit.InputHandler;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.SyntaxUtilities;

public class TextAreaDefaults {
    public String STYLE = "Default";
    public InputHandler inputHandler = new DefaultInputHandler();
    public SyntaxDocument document;
    public boolean editable;
    public boolean caretVisible;
    public boolean caretBlinks;
    public boolean blockCaret;
    public int electricScroll;
    public int cols;
    public int rows;
    public SyntaxStyle[] styles;
    public Color caretColor;
    public Color selectionColor;
    public Color lineHighlightColor;
    public Color foreground;
    public Color background;
    public boolean lineHighlight;
    public Color bracketHighlightColor;
    public boolean bracketHighlight;
    public Color eolMarkerColor;
    public boolean eolMarkers;
    public boolean paintInvalid;
    public Font font;
    public JPopupMenu popup;

    public TextAreaDefaults() {
        this.inputHandler.addDefaultKeyBindings();
        this.document = new SyntaxDocument();
        this.editable = true;
        this.blockCaret = false;
        this.caretVisible = true;
        this.caretBlinks = true;
        this.electricScroll = 1;
        this.cols = 1;
        this.rows = 1;
        if (this.STYLE.equals("RUBY BLUE")) {
            this.styles = SyntaxUtilities.getSyntaxStyles(this.STYLE);
            this.caretColor = Color.white;
            this.background = new Color(1187377);
            this.foreground = Color.white;
            this.selectionColor = new Color(3692143);
            this.lineHighlightColor = new Color(2440794);
            this.lineHighlight = true;
            this.bracketHighlightColor = new Color(3692143);
            this.bracketHighlight = true;
            this.eolMarkerColor = new Color(39321);
            this.eolMarkers = false;
            this.paintInvalid = false;
            this.font = new Font(UIConstants.MONOSPACED_FONT_NAME, 0, 14);
        } else {
            this.styles = SyntaxUtilities.getSyntaxStyles(this.STYLE);
            this.caretColor = Color.black;
            this.background = Color.white;
            this.foreground = Color.black;
            this.selectionColor = new Color(13030366);
            this.lineHighlightColor = new Color(2440794);
            this.lineHighlight = false;
            this.bracketHighlightColor = Color.darkGray;
            this.bracketHighlight = true;
            this.eolMarkerColor = Color.lightGray;
            this.eolMarkers = true;
            this.paintInvalid = false;
            this.font = new Font(UIConstants.MONOSPACED_FONT_NAME, 0, 12);
        }
    }
}

