/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_RESOURCE_OBSERVATION;
import ca.uhn.hl7v2.model.v28.segment.AIG;
import ca.uhn.hl7v2.model.v28.segment.AIL;
import ca.uhn.hl7v2.model.v28.segment.AIP;
import ca.uhn.hl7v2.model.v28.segment.AIS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCM_I21_RESOURCE_DETAIL
extends AbstractGroup {
    public CCM_I21_RESOURCE_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(AIS.class, true, false, true);
            this.add(AIG.class, true, false, true);
            this.add(AIL.class, true, false, true);
            this.add(AIP.class, true, false, true);
            this.add(CCM_I21_RESOURCE_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCM_I21_RESOURCE_DETAIL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public AIS getAIS() {
        AIS retVal = (AIS)this.getTyped("AIS", AIS.class);
        return retVal;
    }

    public AIG getAIG() {
        AIG retVal = (AIG)this.getTyped("AIG", AIG.class);
        return retVal;
    }

    public AIL getAIL() {
        AIL retVal = (AIL)this.getTyped("AIL", AIL.class);
        return retVal;
    }

    public AIP getAIP() {
        AIP retVal = (AIP)this.getTyped("AIP", AIP.class);
        return retVal;
    }

    public CCM_I21_RESOURCE_OBSERVATION getRESOURCE_OBSERVATION() {
        CCM_I21_RESOURCE_OBSERVATION retVal = (CCM_I21_RESOURCE_OBSERVATION)this.getTyped("RESOURCE_OBSERVATION", CCM_I21_RESOURCE_OBSERVATION.class);
        return retVal;
    }

    public CCM_I21_RESOURCE_OBSERVATION getRESOURCE_OBSERVATION(int rep) {
        CCM_I21_RESOURCE_OBSERVATION retVal = (CCM_I21_RESOURCE_OBSERVATION)this.getTyped("RESOURCE_OBSERVATION", rep, CCM_I21_RESOURCE_OBSERVATION.class);
        return retVal;
    }

    public int getRESOURCE_OBSERVATIONReps() {
        return this.getReps("RESOURCE_OBSERVATION");
    }

    public List<CCM_I21_RESOURCE_OBSERVATION> getRESOURCE_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("RESOURCE_OBSERVATION", CCM_I21_RESOURCE_OBSERVATION.class);
    }

    public void insertRESOURCE_OBSERVATION(CCM_I21_RESOURCE_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCE_OBSERVATION", (Structure)structure, rep);
    }

    public CCM_I21_RESOURCE_OBSERVATION insertRESOURCE_OBSERVATION(int rep) throws HL7Exception {
        return (CCM_I21_RESOURCE_OBSERVATION)super.insertRepetition("RESOURCE_OBSERVATION", rep);
    }

    public CCM_I21_RESOURCE_OBSERVATION removeRESOURCE_OBSERVATION(int rep) throws HL7Exception {
        return (CCM_I21_RESOURCE_OBSERVATION)super.removeRepetition("RESOURCE_OBSERVATION", rep);
    }
}

