/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.DPR_O48_DONOR_REGISTRATION;
import ca.uhn.hl7v2.model.v28.segment.AL1;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.OBX;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DPR_O48_DONOR
extends AbstractGroup {
    public DPR_O48_DONOR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(OBX.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(AL1.class, false, true, false);
            this.add(ARV.class, false, true, false);
            this.add(DPR_O48_DONOR_REGISTRATION.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DPR_O48_DONOR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = (PD1)this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public AL1 getAL1() {
        AL1 retVal = (AL1)this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = (AL1)this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public ARV getARV() {
        ARV retVal = (ARV)this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = (ARV)this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", (Structure)structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public DPR_O48_DONOR_REGISTRATION getDONOR_REGISTRATION() {
        DPR_O48_DONOR_REGISTRATION retVal = (DPR_O48_DONOR_REGISTRATION)this.getTyped("DONOR_REGISTRATION", DPR_O48_DONOR_REGISTRATION.class);
        return retVal;
    }
}

