/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.EAR_U08_COMMAND_RESPONSE;
import ca.uhn.hl7v2.model.v28.segment.EQU;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EAR_U08
extends AbstractMessage {
    public EAR_U08() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EAR_U08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EQU.class, true, false);
            this.add(EAR_U08_COMMAND_RESPONSE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EAR_U08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public EQU getEQU() {
        return (EQU)this.getTyped("EQU", EQU.class);
    }

    public EAR_U08_COMMAND_RESPONSE getCOMMAND_RESPONSE() {
        return (EAR_U08_COMMAND_RESPONSE)this.getTyped("COMMAND_RESPONSE", EAR_U08_COMMAND_RESPONSE.class);
    }

    public EAR_U08_COMMAND_RESPONSE getCOMMAND_RESPONSE(int rep) {
        return (EAR_U08_COMMAND_RESPONSE)this.getTyped("COMMAND_RESPONSE", rep, EAR_U08_COMMAND_RESPONSE.class);
    }

    public int getCOMMAND_RESPONSEReps() {
        return this.getReps("COMMAND_RESPONSE");
    }

    public List<EAR_U08_COMMAND_RESPONSE> getCOMMAND_RESPONSEAll() throws HL7Exception {
        return this.getAllAsList("COMMAND_RESPONSE", EAR_U08_COMMAND_RESPONSE.class);
    }

    public void insertCOMMAND_RESPONSE(EAR_U08_COMMAND_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMAND_RESPONSE", (Structure)structure, rep);
    }

    public EAR_U08_COMMAND_RESPONSE insertCOMMAND_RESPONSE(int rep) throws HL7Exception {
        return (EAR_U08_COMMAND_RESPONSE)super.insertRepetition("COMMAND_RESPONSE", rep);
    }

    public EAR_U08_COMMAND_RESPONSE removeCOMMAND_RESPONSE(int rep) throws HL7Exception {
        return (EAR_U08_COMMAND_RESPONSE)super.removeRepetition("COMMAND_RESPONSE", rep);
    }
}

